/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.antlion.tamable.goal;

import dev.xylonity.companions.common.entity.ai.antlion.tamable.AbstractAntlionAttackGoal;
import dev.xylonity.companions.common.entity.companion.AntlionEntity;
import dev.xylonity.companions.common.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class AntlionAdultAttackGoal
extends AbstractAntlionAttackGoal {
    private static final int TOTAL_DURATION = 80;
    private static final int ASCEND_DURATION = 65;
    private static final int DIVE_DURATION = 15;
    private Vec3 hoverPoint;
    private double ascendSpeed;
    private double diveSpeed;
    private double groundLevel;
    private boolean hasStartedDive;

    public AntlionAdultAttackGoal(AntlionEntity antlion, int minCd, int maxCd) {
        super(antlion, 80, minCd, maxCd);
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && this.antlion.getVariant() == 2 && this.antlion.m_5448_() != null && this.antlion.m_20280_((Entity)this.antlion.m_5448_()) <= 256.0;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.hasStartedDive = false;
        Vec3 targetPos = this.antlion.m_5448_() != null ? this.antlion.m_5448_().m_20182_() : this.antlion.m_20182_();
        this.hoverPoint = targetPos.m_82520_(0.0, 10.0, 0.0);
        this.ascendSpeed = this.antlion.m_20182_().m_82554_(this.hoverPoint) / 65.0;
        this.antlion.setAttackType(1);
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        LivingEntity target = this.antlion.m_5448_();
        if (target == null || !target.m_6084_()) {
            this.m_8041_();
            return;
        }
        if (!this.hasStartedDive) {
            Vec3 delta = this.hoverPoint.m_82546_(this.antlion.m_20182_());
            double remaining = delta.m_82553_();
            if (remaining <= 0.3) {
                this.startDive();
            } else {
                Vec3 motion = delta.m_82541_().m_82490_(Math.min(this.ascendSpeed, remaining));
                this.antlion.m_20256_(motion);
                this.antlion.m_6478_(MoverType.SELF, motion);
            }
        } else {
            this.antlion.m_21573_().m_26573_();
            this.antlion.m_20334_(0.0, this.diveSpeed, 0.0);
            if (this.antlion.m_20096_() || this.antlion.m_20186_() <= this.groundLevel) {
                this.m_8041_();
                return;
            }
        }
        if (this.attackTicks >= 80) {
            this.m_8041_();
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.antlion.setAttackType(0);
        this.hasStartedDive = false;
        this.performAttack(null);
    }

    private void startDive() {
        this.antlion.cycleState();
        this.groundLevel = this.getGroundLevel();
        this.diveSpeed = -((this.antlion.m_20186_() - this.groundLevel) / 15.0);
        this.hasStartedDive = true;
    }

    private double getGroundLevel() {
        BlockPos.MutableBlockPos pos = this.antlion.m_20183_().m_122032_();
        int y = pos.m_123342_();
        while (y > this.antlion.m_9236_().m_141937_()) {
            pos.m_142448_(--y);
            if (this.antlion.m_9236_().m_8055_((BlockPos)pos).m_60812_((BlockGetter)this.antlion.m_9236_(), (BlockPos)pos).m_83281_()) continue;
            return y + 1;
        }
        return this.antlion.m_9236_().m_141937_();
    }

    @Override
    protected int attackDelay() {
        return -1;
    }

    @Override
    protected int attackType() {
        return 1;
    }

    @Override
    protected int variant() {
        return 2;
    }

    @Override
    protected void performAttack(LivingEntity target) {
        for (LivingEntity e : this.antlion.m_9236_().m_45976_(LivingEntity.class, this.antlion.m_20191_().m_82400_(1.0))) {
            if (Util.areEntitiesLinked((Entity)e, (Entity)this.antlion)) continue;
            this.antlion.m_7327_((Entity)e);
        }
    }
}

