/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity;

import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.knightlib.registry.KnightLibItems;
import dev.xylonity.knightlib.registry.KnightLibParticles;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class CompanionEntity
extends TamableAnimal
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> MAIN_ACTION = SynchedEntityData.m_135353_(CompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SIT_VARIATION = SynchedEntityData.m_135353_(CompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> NO_MOVEMENT = SynchedEntityData.m_135353_(CompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ChunkPos lastChunkPos;

    protected CompanionEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.isNoMovement()) {
            this.m_21573_().m_26573_();
            this.m_20256_(Vec3.f_82478_);
        }
        if (this.shouldKeepChunkLoaded() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ChunkPos currentChunkPos = new ChunkPos(this.m_20183_());
            if (!currentChunkPos.equals((Object)this.lastChunkPos)) {
                if (this.lastChunkPos != null) {
                    level2.m_8602_(this.lastChunkPos.f_45578_, this.lastChunkPos.f_45579_, false);
                }
                level2.m_8602_(currentChunkPos.f_45578_, currentChunkPos.f_45579_, true);
                this.lastChunkPos = currentChunkPos;
            }
        }
    }

    public void m_6043_() {
        if (this.m_21824_() && this.shouldKeepChunkLoaded()) {
            return;
        }
        super.m_6043_();
    }

    public boolean m_21532_() {
        return this.m_21824_() && this.shouldKeepChunkLoaded();
    }

    public boolean m_8023_() {
        return this.m_21824_() && this.shouldKeepChunkLoaded();
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.lastChunkPos != null) {
                level2.m_8602_(this.lastChunkPos.f_45578_, this.lastChunkPos.f_45579_, false);
            }
        }
        super.m_142687_(pReason);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() != null && pSource.m_7639_().equals((Object)this.m_269323_()) & !pSource.m_7639_().m_6144_()) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAIN_ACTION, (Object)1);
        this.f_19804_.m_135372_(NO_MOVEMENT, (Object)false);
        this.f_19804_.m_135372_(SIT_VARIATION, (Object)0);
    }

    public void setMainAction(int action, @Nullable Player player) {
        ArrayList<Integer> allowedActions = new ArrayList<Integer>();
        allowedActions.add(0);
        allowedActions.add(1);
        if (CompanionsConfig.SHOULD_COMPANIONS_WANDER) {
            allowedActions.add(2);
        }
        int newAction = (Integer)allowedActions.get(action % allowedActions.size());
        this.f_19804_.m_135381_(MAIN_ACTION, (Object)newAction);
        if (player != null) {
            switch (newAction) {
                case 0: {
                    player.m_5661_((Component)Component.m_237110_((String)"main_action.companions.client_message.is_sitting", (Object[])new Object[]{this.m_7755_()}), true);
                    break;
                }
                case 1: {
                    player.m_5661_((Component)Component.m_237110_((String)"main_action.companions.client_message.is_following", (Object[])new Object[]{this.m_7755_()}), true);
                    break;
                }
                case 2: {
                    player.m_5661_((Component)Component.m_237110_((String)"main_action.companions.client_message.is_wandering", (Object[])new Object[]{this.m_7755_()}), true);
                    break;
                }
                default: {
                    player.m_5661_((Component)Component.m_237110_((String)"main_action.companions.client_message.is_working", (Object[])new Object[]{this.m_7755_()}), true);
                }
            }
        }
    }

    public int getMainAction() {
        return (Integer)this.f_19804_.m_135370_(MAIN_ACTION);
    }

    public boolean isNoMovement() {
        return (Boolean)this.f_19804_.m_135370_(NO_MOVEMENT);
    }

    public void setNoMovement(boolean isNoMovement) {
        this.f_19804_.m_135381_(NO_MOVEMENT, (Object)isNoMovement);
    }

    public int getSitVariation() {
        return (Integer)this.f_19804_.m_135370_(SIT_VARIATION);
    }

    public void setSitVariation(int variation) {
        this.f_19804_.m_135381_(SIT_VARIATION, (Object)variation);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("CompanionsMainAction")) {
            this.setMainAction(pCompound.m_128451_("CompanionsMainAction"), null);
        }
        if (pCompound.m_128441_("CompanionsSitVariation")) {
            this.setSitVariation(pCompound.m_128451_("CompanionsSitVariation"));
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("CompanionsMainAction", this.getMainAction());
        pCompound.m_128405_("CompanionsSitVariation", this.getSitVariation());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void defaultMainActionInteraction(Player pPlayer) {
        this.setMainAction(this.getMainAction() + 1, pPlayer);
        if (this.getMainAction() == 0) {
            this.setSitVariation(new Random().nextInt(0, this.sitAnimationsAmount()));
            this.m_6710_(null);
            this.m_21839_(true);
        } else {
            this.m_21839_(false);
        }
    }

    public boolean handleDefaultMainActionAndHeal(Player pPlayer, InteractionHand hand) {
        if (this.m_9236_().f_46443_) {
            return true;
        }
        ItemStack stack = pPlayer.m_21120_(hand);
        Item item = stack.m_41720_();
        if (this.m_21824_() && pPlayer == this.m_269323_()) {
            if (item == KnightLibItems.SMALL_ESSENCE.get() && this.m_21223_() != this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.m_5634_(this.m_21223_() * 0.05f);
                this.summonHealParticles();
            } else if (item == KnightLibItems.GREAT_ESSENCE.get() && this.m_21223_() != this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.m_5634_(this.m_21223_() * 0.2f);
                this.summonHealParticles();
            } else {
                this.defaultMainActionInteraction(pPlayer);
            }
            return true;
        }
        return false;
    }

    public void tameInteraction(Player pPlayer) {
        super.m_21828_(pPlayer);
        this.f_21344_.m_26569_();
        this.m_6710_(null);
        this.m_9236_().m_7605_((Entity)this, (byte)7);
        this.setMainAction(0, pPlayer);
        this.setSitVariation(new Random().nextInt(0, this.sitAnimationsAmount()));
        this.m_21839_(true);
    }

    private void summonHealParticles() {
        for (int i = 0; i < 10; ++i) {
            double dx = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dy = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            double dz = (this.f_19796_.m_188500_() - 0.5) * 1.25;
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel level2 = (ServerLevel)level;
            if (level2.f_46441_.m_188501_() < 0.45f) {
                level2.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 0.15, this.m_20189_(), 1, dx, dy, dz, 0.1);
            }
            if (!(level2.f_46441_.m_188501_() < 0.25f)) continue;
            level2.m_8767_((ParticleOptions)((SimpleParticleType)KnightLibParticles.STARSET.get()), this.m_20185_(), this.m_20186_() + 0.15, this.m_20189_(), 1, dx, dy, dz, 0.1);
        }
    }

    protected abstract boolean canThisCompanionWork();

    protected abstract int sitAnimationsAmount();

    protected abstract boolean shouldKeepChunkLoaded();

    public boolean m_6072_() {
        return true;
    }
}

