/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.container;

import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.common.item.blockitem.CoinItem;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsMenuTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CorneliusContainerMenu
extends AbstractContainerMenu {
    private final CorneliusEntity cornelius;
    private final Container entityInventory;
    private boolean gameActive = false;
    public static final int BUTTON_START_GAME = 0;
    public static final int BUTTON_STOP_GAME = 1;
    public static final int ACTION_LOSE = 2;
    public static final int ACTION_TIE = 3;
    public static final int ACTION_WIN = 4;
    public static final int ACTION_JACK = 5;
    private static final List<Object> ALLOWED_BET_KEYS = new ArrayList<Object>();
    private static String cachedBets = null;

    public CorneliusContainerMenu(int windowId, Inventory playerInv, CorneliusEntity cornelius) {
        super((MenuType)CompanionsMenuTypes.CORNELIUS_CONTAINER.get(), windowId);
        int col;
        this.cornelius = cornelius;
        this.entityInventory = cornelius.inventory;
        CorneliusContainerMenu.m_38869_((Container)this.entityInventory, (int)2);
        this.entityInventory.m_5856_(playerInv.f_35978_);
        this.m_38897_(new MainCoinSlot(this.entityInventory, 0, 8, 118));
        this.m_38897_(new MainCoinSlot(this.entityInventory, 1, 26, 118));
        this.m_38897_(new MainCoinSlot(this.entityInventory, 2, 44, 118));
        this.m_38897_(new CrupierCoinSlot(this.entityInventory, 3, 62, 7));
        this.m_38897_(new CrupierCoinSlot(this.entityInventory, 4, 80, 7));
        this.m_38897_(new CrupierCoinSlot(this.entityInventory, 5, 98, 7));
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return CorneliusContainerMenu.this.gameActive ? 1 : 0;
            }

            public void m_6422_(int value) {
                CorneliusContainerMenu.this.gameActive = value != 0;
            }
        });
        int PLAYER_INVENTORY_START_Y = 144;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 144 + row * 18));
            }
        }
        int HOTBAR_START_Y = 202;
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 202));
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.entityInventory.m_6542_(player) && this.cornelius.m_6084_() && this.cornelius.m_20270_((Entity)player) < 8.0f;
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.entityInventory.m_5785_(player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            itemstack = stackInSlot.m_41777_();
            int containerSize = this.entityInventory.m_6643_();
            if (index < containerSize ? !this.m_38903_(stackInSlot, containerSize, this.f_38839_.size(), true) : !this.m_38903_(stackInSlot, 0, containerSize, false)) {
                return ItemStack.f_41583_;
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6366_(@NotNull Player player, int buttonId) {
        if (buttonId == 0) {
            this.gameActive = true;
            this.m_38946_();
            return true;
        }
        if (buttonId == 1) {
            this.gameActive = false;
            this.m_38946_();
            return true;
        }
        if (buttonId >= 2 && buttonId <= 5) {
            this.pay(switch (buttonId) {
                case 5 -> 2.5;
                case 4 -> 2.0;
                case 3 -> 1.0;
                default -> 0.0;
            }, player);
            this.gameActive = false;
            this.m_38946_();
            return true;
        }
        return super.m_6366_(player, buttonId);
    }

    private void pay(double multiplier, Player player) {
        for (int i = 3; i <= 5; ++i) {
            ItemStack bet = this.entityInventory.m_8020_(i);
            if (bet.m_41619_()) continue;
            int payoutTotal = (int)Math.floor((double)bet.m_41613_() * multiplier);
            int toSlot = Math.min(payoutTotal, bet.m_41741_());
            int overflow = payoutTotal - toSlot;
            this.entityInventory.m_6836_(i, new ItemStack((ItemLike)bet.m_41720_(), toSlot));
            if (overflow <= 0) continue;
            ItemEntity drop = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), new ItemStack((ItemLike)bet.m_41720_(), overflow));
            player.m_9236_().m_7967_((Entity)drop);
        }
        this.entityInventory.m_6596_();
    }

    private static boolean isAllowedBet(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        CorneliusContainerMenu.parsePossibleBets();
        for (Object object : ALLOWED_BET_KEYS) {
            TagKey anyTag;
            Item item;
            if (!(object instanceof Item ? stack.m_150930_(item = (Item)object) : object instanceof TagKey && stack.m_204117_(anyTag = (TagKey)object))) continue;
            return true;
        }
        return false;
    }

    private static void parsePossibleBets() {
        String[] parts;
        String raw = CompanionsConfig.CORNELIUS_JACKBLACK_BETS;
        if (raw == null) {
            raw = "";
        }
        if (raw.equals(cachedBets)) {
            return;
        }
        ALLOWED_BET_KEYS.clear();
        cachedBets = raw;
        for (String part : parts = raw.split(";")) {
            boolean isTag;
            ResourceLocation resourceLocation;
            String string = part.trim();
            if (string.isEmpty() || (resourceLocation = ResourceLocation.m_135820_((String)((isTag = string.startsWith("#")) ? string.substring(1).trim() : string))) == null) continue;
            if (isTag) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourceLocation);
                ALLOWED_BET_KEYS.add(tag);
                continue;
            }
            BuiltInRegistries.f_257033_.m_6612_(resourceLocation).ifPresent(ALLOWED_BET_KEYS::add);
        }
    }

    public static class MainCoinSlot
    extends Slot {
        public MainCoinSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return stack.m_41720_() instanceof CoinItem;
        }
    }

    public class CrupierCoinSlot
    extends Slot {
        public CrupierCoinSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return CorneliusContainerMenu.isAllowedBet(stack) && !CorneliusContainerMenu.this.gameActive;
        }

        public boolean m_8010_(@NotNull Player player) {
            return !CorneliusContainerMenu.this.gameActive;
        }

        public boolean m_150651_(@NotNull Player pPlayer) {
            return !CorneliusContainerMenu.this.gameActive && super.m_150651_(pPlayer);
        }
    }
}

