/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.projectile.RespawnTotemRingProjectile;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class RespawnTotemBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final Map<UUID, CompoundTag> savedEntities = new ConcurrentHashMap<UUID, CompoundTag>();
    private final List<RespawnData> pending = new ArrayList<RespawnData>();
    private int tickCount = 0;
    private boolean isCapturing = false;
    private int charges = 0;
    private int captureCooldown = 0;

    public RespawnTotemBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CompanionsBlockEntities.RESPAWN_TOTEM.get(), pos, state);
    }

    public void queueRespawn(CompoundTag nbt, int delay) {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sv = (ServerLevel)level;
        this.pending.add(new RespawnData(nbt, sv.m_46467_() + (long)delay));
        this.m_6596_();
    }

    public void setCharges(int charges) {
        this.charges = charges;
        this.sync();
    }

    public int getCharges() {
        return this.charges;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean captureNearby() {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.f_46443_) {
            return false;
        }
        boolean captureFlag = false;
        for (Entity e : this.f_58857_.m_45976_(TamableAnimal.class, new AABB(this.f_58858_).m_82400_(5.0))) {
            if (e.m_213877_()) continue;
            CompoundTag data = new CompoundTag();
            e.m_20223_(data);
            this.savedEntities.put(e.m_20148_(), data);
            e.getPersistentData().m_128356_("RespawnTotemPos", this.f_58858_.m_121878_());
            e.getPersistentData().m_128359_("RespawnTotemDim", this.f_58857_.m_46472_().m_135782_().toString());
            captureFlag = true;
        }
        this.m_6596_();
        return captureFlag;
    }

    public int getCaptureCooldown() {
        return this.captureCooldown;
    }

    public void setCaptureCooldown(int captureCooldown) {
        this.captureCooldown = captureCooldown;
    }

    public void setCapturing(boolean capturing) {
        if (capturing && this.getCaptureCooldown() > 0) {
            return;
        }
        this.isCapturing = capturing;
    }

    public boolean isCapturing() {
        return this.isCapturing;
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Charges", this.getCharges());
        ListTag list = new ListTag();
        this.savedEntities.forEach((uuid, data) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("Uuid", uuid);
            entry.m_128365_("Data", (Tag)data);
            list.add((Object)entry);
        });
        tag.m_128365_("RespawnList", (Tag)list);
        ListTag list2 = new ListTag();
        for (RespawnData p : this.pending) {
            CompoundTag e = new CompoundTag();
            e.m_128356_("When", p.time);
            e.m_128365_("Nbt", (Tag)p.nbt);
            list2.add((Object)e);
        }
        tag.m_128365_("RespawnPending", (Tag)list2);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.savedEntities.clear();
        this.charges = tag.m_128451_("Charges");
        ListTag list = tag.m_128437_("RespawnList", 10);
        for (Tag t : list) {
            CompoundTag entry = (CompoundTag)t;
            this.savedEntities.put(entry.m_128342_("Uuid"), entry.m_128469_("Data"));
        }
        this.pending.clear();
        ListTag list2 = tag.m_128437_("RespawnPending", 10);
        for (Tag t : list2) {
            CompoundTag e = (CompoundTag)t;
            this.pending.add(new RespawnData(e.m_128469_("Nbt"), e.m_128454_("When")));
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.charges = tag.m_128451_("Charges");
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("Charges", this.getCharges());
        return tag;
    }

    public void sync() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket pkt = ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(this.f_58858_), false).forEach(arg_0 -> RespawnTotemBlockEntity.lambda$sync$1((Packet)pkt, arg_0));
    }

    public static <X extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, X blockEntity) {
        ServerLevel sv;
        if (!(blockEntity instanceof RespawnTotemBlockEntity)) {
            return;
        }
        RespawnTotemBlockEntity t = (RespawnTotemBlockEntity)blockEntity;
        if (level instanceof ServerLevel) {
            sv = (ServerLevel)level;
            long now = sv.m_46467_();
            Iterator<RespawnData> it = t.pending.iterator();
            while (it.hasNext()) {
                RespawnData p = it.next();
                if (now < p.time) continue;
                Entity spawned = EntityType.m_20645_((CompoundTag)p.nbt, (Level)sv, e -> {
                    BlockPos sPos = RespawnTotemBlockEntity.findSpawn(sv, pos, 5);
                    double x = sPos != null ? (double)sPos.m_123341_() + 0.5 : (double)pos.m_123341_() + 0.5;
                    double y = sPos != null ? sPos.m_123342_() : pos.m_123342_() + 1;
                    double z = sPos != null ? (double)sPos.m_123343_() + 0.5 : (double)pos.m_123343_() + 0.5;
                    e.m_6034_(x, y, z);
                    return e;
                });
                if (spawned != null) {
                    for (int i = 0; i < 20; ++i) {
                        double dx = (sv.f_46441_.m_188500_() - 0.5) * 2.0;
                        double dy = (sv.f_46441_.m_188500_() - 0.5) * 2.0;
                        double dz = (sv.f_46441_.m_188500_() - 0.5) * 2.0;
                        sv.m_8767_((ParticleOptions)ParticleTypes.f_123759_, spawned.m_20185_(), spawned.m_20186_() + (double)spawned.m_20206_() * 0.5, spawned.m_20189_(), 1, dx, dy, dz, 0.1);
                    }
                    t.setCharges(t.getCharges() - 1);
                    if (spawned instanceof CompanionEntity) {
                        CompanionEntity c = (CompanionEntity)spawned;
                        c.setMainAction(0, null);
                    } else if (spawned instanceof TamableAnimal) {
                        TamableAnimal tamableAnimal = (TamableAnimal)spawned;
                        tamableAnimal.m_21839_(true);
                    }
                    sv.m_7967_(spawned);
                }
                it.remove();
            }
        }
        if (t.isCapturing()) {
            if (level instanceof ServerLevel) {
                sv = (ServerLevel)level;
                for (int i = 0; i < 20; ++i) {
                    double dx = (sv.f_46441_.m_188500_() - 0.5) * 2.0;
                    double dy = (sv.f_46441_.m_188500_() - 0.5) * 2.0;
                    double dz = (sv.f_46441_.m_188500_() - 0.5) * 2.0;
                    sv.m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 1, dx, dy, dz, 0.1);
                }
                RespawnTotemRingProjectile ring = (RespawnTotemRingProjectile)((EntityType)CompanionsEntities.RESPAWN_TOTEM_RING_PROJECTILE.get()).m_20615_(level);
                if (ring != null) {
                    ring.m_6034_((double)pos.m_123341_() + 0.5, t.getRingSpawnY(level, pos) + 0.015, (double)pos.m_123343_() + 0.5);
                    level.m_7967_((Entity)ring);
                }
            }
            if (t.captureNearby()) {
                t.setCharges(CompanionsConfig.RESPAWN_TOTEM_CHARGES);
            }
            t.setCapturing(false);
            t.setCaptureCooldown(40);
            t.m_6596_();
        }
        if (t.getCaptureCooldown() > 0) {
            t.setCaptureCooldown(t.getCaptureCooldown() - 1);
        }
        if (t.tickCount % 10 == 0 && t.getCharges() > 0) {
            double dx = (new Random().nextDouble() - 0.5) * 0.5;
            double dy = (new Random().nextDouble() - 0.5) * 0.5;
            double dz = (new Random().nextDouble() - 0.5) * 0.5;
            if (level instanceof ServerLevel) {
                ServerLevel sv2 = (ServerLevel)level;
                sv2.m_8767_((ParticleOptions)CompanionsParticles.RESPAWN_TOTEM.get(), (double)t.m_58899_().m_123341_() + 0.5, (double)t.m_58899_().m_123342_() + 1.5 * Math.random(), (double)t.m_58899_().m_123343_() + 0.5, 1, dx, dy, dz, 0.02);
            }
        }
        ++t.tickCount;
    }

    private static BlockPos findSpawn(ServerLevel level, BlockPos center, int radius) {
        for (int i = 0; i < 80; ++i) {
            int z;
            int y;
            int dx = new Random().nextInt(radius * 2 + 1) - radius;
            int dz = new Random().nextInt(radius * 2 + 1) - radius;
            int x = center.m_123341_() + dx;
            BlockPos ret = new BlockPos(x, y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z = center.m_123343_() + dz), z);
            if (!level.m_8055_(ret).m_60795_() || !level.m_8055_(ret.m_7494_()).m_60795_()) continue;
            return ret;
        }
        return null;
    }

    private double getRingSpawnY(Level level, BlockPos basePos) {
        BlockPos below1 = basePos.m_7495_();
        if (!level.m_8055_(below1).m_60795_()) {
            int airCount;
            BlockPos below2 = below1.m_7495_();
            if (!level.m_8055_(below2).m_60795_()) {
                airCount = 0;
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    if (!level.m_8055_(below2.m_121945_(dir)).m_60795_()) continue;
                    ++airCount;
                }
                if (airCount >= 3) {
                    return below2.m_123342_();
                }
            }
            airCount = 0;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (!level.m_8055_(below1.m_121945_(dir)).m_60795_()) continue;
                ++airCount;
            }
            if (airCount >= 3) {
                return below1.m_123342_();
            }
        }
        return basePos.m_123342_();
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public double getTick(Object o) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static /* synthetic */ void lambda$sync$1(Packet pkt, ServerPlayer p) {
        p.f_8906_.m_9829_(pkt);
    }

    private static class RespawnData {
        CompoundTag nbt;
        long time;

        RespawnData(CompoundTag nbt, long time) {
            this.nbt = nbt;
            this.time = time;
        }
    }
}

