/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.companion.CroissantDragonEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public class CroissantEggBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SPASM = RawAnimation.begin().thenPlay("spasms");
    private int tickCounter = 0;
    private boolean spasm = false;

    public CroissantEggBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CompanionsBlockEntities.CROISSANT_EGG.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T F) {
        if (F instanceof CroissantEggBlockEntity) {
            CroissantEggBlockEntity egg = (CroissantEggBlockEntity)F;
            ++egg.tickCounter;
            if (egg.tickCounter >= CompanionsConfig.CROISSANT_EGG_LIFETIME) {
                level.m_46961_(pos, false);
                Entity croissantDragonEntity = ((EntityType)CompanionsEntities.CROISSANT_DRAGON.get()).m_20615_(level);
                if (croissantDragonEntity instanceof CroissantDragonEntity) {
                    CroissantDragonEntity croissantDragon = (CroissantDragonEntity)croissantDragonEntity;
                    croissantDragon.m_20219_(egg.m_58899_().m_252807_());
                    level.m_7967_((Entity)croissantDragon);
                }
            }
            if (egg.tickCounter % 200 == 0) {
                egg.spasm = true;
                TickScheduler.scheduleBoth((Level)level, () -> {
                    egg.spasm = false;
                }, (int)40);
            }
            if (egg.tickCounter % 25 == 0) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)egg.m_58899_().m_123341_() + 0.5, (double)egg.m_58899_().m_123342_(), (double)egg.m_58899_().m_123343_() + 0.5, 0.0015, 0.1, 0.0015);
            }
        }
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public double getTick(Object o) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.spasm) {
            event.getController().setAnimation(this.SPASM);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

