/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.ai.navigator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.xylonity.companions.common.ai.navigator.BonusPathFinder;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class GroundNavigator
extends GroundPathNavigation {
    private static final float EPSILON = 1.0E-8f;
    private Vec3 lastPos = Vec3.f_82478_;
    private int noMoveTicks = 0;
    private final Cache<BlockPos, Boolean> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(5L, TimeUnit.SECONDS).build();

    public GroundNavigator(Mob entity, Level world) {
        super(entity, world);
    }

    @NotNull
    protected PathFinder m_5532_(int maxVisitedNodes) {
        this.f_26508_ = new WalkNodeEvaluator();
        this.f_26508_.m_77351_(true);
        return new BonusPathFinder(this.f_26508_, maxVisitedNodes);
    }

    protected void m_7636_() {
        Vec3 curr;
        int lastIdx;
        if (this.f_26496_ == null || this.f_26496_.m_77392_()) {
            return;
        }
        Vec3 entityPos = this.m_7475_();
        int nextIdx = this.f_26496_.m_77399_();
        double yFloor = Math.floor(entityPos.f_82480_);
        for (lastIdx = nextIdx; lastIdx < this.f_26496_.m_77398_() && (double)this.f_26496_.m_77375_((int)lastIdx).f_77272_ == yFloor; ++lastIdx) {
        }
        Vec3 base = entityPos.m_82492_((double)this.f_26494_.m_20205_(), 0.0, (double)this.f_26494_.m_20205_());
        this.attemptShortcut(this.f_26496_, entityPos, lastIdx, base);
        if (this.hasReached(this.f_26496_, 1.0f) || this.isAtElevationChange(this.f_26496_) && this.hasReached(this.f_26496_, 1.0f)) {
            this.f_26496_.m_77374_();
        }
        if (!this.f_26496_.m_77392_()) {
            Vec3 target = this.f_26496_.m_77380_((Entity)this.f_26494_);
            this.f_26494_.m_21566_().m_6849_(target.f_82479_, target.f_82480_, target.f_82481_, this.f_26497_);
            if (this.f_26494_.f_19862_ && this.f_26494_.m_20096_()) {
                BlockPos abovePos;
                BlockPathTypes aboveType;
                float malus;
                Direction dir = this.f_26494_.m_6350_();
                BlockPos frontPos = this.f_26494_.m_20183_().m_121945_(dir);
                BlockState state = this.f_26495_.m_8055_(frontPos);
                VoxelShape shape = state.m_60812_((BlockGetter)this.f_26495_, frontPos);
                double shapeHeight = shape.m_83297_(Direction.Axis.Y);
                if (shapeHeight > 0.0 && shapeHeight <= 1.0 && (malus = this.f_26494_.m_21439_(aboveType = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, (abovePos = frontPos.m_7494_()).m_123341_(), abovePos.m_123342_(), abovePos.m_123343_(), this.f_26494_))) >= 0.0f && malus < 8.0f) {
                    this.f_26494_.m_21569_().m_24901_();
                }
            }
        }
        this.noMoveTicks = (curr = Vec3.m_82528_((Vec3i)this.f_26494_.m_20183_()).m_82520_(0.0, (double)(this.f_26494_.m_20206_() / 2.0f), 0.0)).m_82554_(this.lastPos) < 0.01 ? ++this.noMoveTicks : 0;
        this.lastPos = curr;
        if (this.noMoveTicks > 10) {
            this.cache.invalidateAll();
            this.f_26496_ = null;
            this.f_26494_.m_21566_().m_6849_(this.f_26494_.m_20185_(), this.f_26494_.m_20186_(), this.f_26494_.m_20189_(), 0.0);
            if (this.m_26567_() != null) {
                this.m_7864_(this.m_26567_(), (int)this.f_26494_.m_21133_(Attributes.f_22277_));
            }
            this.noMoveTicks = 0;
        }
        this.m_6481_(entityPos);
    }

    private boolean hasReached(Path path, float threshold) {
        Vec3 pathPos = path.m_77380_((Entity)this.f_26494_);
        if (Math.abs(this.f_26494_.m_20185_() - pathPos.f_82479_) >= (double)threshold) {
            return false;
        }
        if (Math.abs(this.f_26494_.m_20189_() - pathPos.f_82481_) >= (double)threshold) {
            return false;
        }
        return Math.abs(this.f_26494_.m_20186_() - pathPos.f_82480_) <= 1.001;
    }

    private boolean isAtElevationChange(Path path) {
        int currIndex = path.m_77399_();
        int endIndex = Math.min(path.m_77398_(), currIndex + Mth.m_14167_((float)(this.f_26494_.m_20205_() * 0.5f)) + 1);
        int currY = path.m_77375_((int)currIndex).f_77272_;
        for (int i = currIndex + 1; i < endIndex; ++i) {
            if (path.m_77375_((int)i).f_77272_ == currY) continue;
            return true;
        }
        return false;
    }

    private boolean attemptShortcut(Path path, Vec3 entityPos, int pathLength, Vec3 base) {
        int nextNodeIndex = path.m_77399_();
        for (int i = pathLength - 1; i > nextNodeIndex; --i) {
            Vec3 vec = path.m_77382_((Entity)this.f_26494_, i).m_82546_(entityPos);
            if (!this.catchF(vec, base)) continue;
            path.m_77393_(i);
            return false;
        }
        return true;
    }

    private boolean catchF(Vec3 vec, Vec3 base) {
        int stepZ;
        float tNextZ;
        float tDeltaZ;
        int stepY;
        float tNextY;
        float tDeltaY;
        int stepX;
        float tNextX;
        float tDeltaX;
        float maxT = (float)vec.m_82553_();
        if (maxT < 1.0E-8f) {
            return true;
        }
        float dx = (float)vec.f_82479_ / maxT;
        float dy = (float)vec.f_82480_ / maxT;
        float dz = (float)vec.f_82481_ / maxT;
        if (Math.abs(dx) < 1.0E-8f) {
            tDeltaX = Float.POSITIVE_INFINITY;
            tNextX = Float.POSITIVE_INFINITY;
            stepX = 0;
        } else {
            stepX = dx > 0.0f ? 1 : -1;
            float voxelBoundaryX = stepX > 0 ? (float)(Mth.m_14107_((double)base.f_82479_) + 1) : (float)Mth.m_14107_((double)base.f_82479_);
            tDeltaX = 1.0f / Math.abs(dx);
            tNextX = (float)(((double)voxelBoundaryX - base.f_82479_) / (double)dx);
        }
        int currentX = Mth.m_14107_((double)base.f_82479_);
        if (Math.abs(dy) < 1.0E-8f) {
            tDeltaY = Float.POSITIVE_INFINITY;
            tNextY = Float.POSITIVE_INFINITY;
            stepY = 0;
        } else {
            stepY = dy > 0.0f ? 1 : -1;
            float voxelBoundaryY = stepY > 0 ? (float)(Mth.m_14107_((double)base.f_82480_) + 1) : (float)Mth.m_14107_((double)base.f_82480_);
            tDeltaY = 1.0f / Math.abs(dy);
            tNextY = (float)(((double)voxelBoundaryY - base.f_82480_) / (double)dy);
        }
        int currentY = Mth.m_14107_((double)base.f_82480_);
        if (Math.abs(dz) < 1.0E-8f) {
            tDeltaZ = Float.POSITIVE_INFINITY;
            tNextZ = Float.POSITIVE_INFINITY;
            stepZ = 0;
        } else {
            stepZ = dz > 0.0f ? 1 : -1;
            float voxelBoundaryZ = stepZ > 0 ? (float)(Mth.m_14107_((double)base.f_82481_) + 1) : (float)Mth.m_14107_((double)base.f_82481_);
            tDeltaZ = 1.0f / Math.abs(dz);
            tNextZ = (float)(((double)voxelBoundaryZ - base.f_82481_) / (double)dz);
        }
        int currentZ = Mth.m_14107_((double)base.f_82481_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float t = 0.0f;
        while (t <= maxT) {
            if (tNextX < tNextY) {
                if (tNextX < tNextZ) {
                    currentX += stepX;
                    t = tNextX;
                    tNextX += tDeltaX;
                } else {
                    currentZ += stepZ;
                    t = tNextZ;
                    tNextZ += tDeltaZ;
                }
            } else if (tNextY < tNextZ) {
                currentY += stepY;
                t = tNextY;
                tNextY += tDeltaY;
            } else {
                currentZ += stepZ;
                t = tNextZ;
                tNextZ += tDeltaZ;
            }
            pos.m_122178_(currentX, currentY, currentZ);
            BlockPos immutablePos = pos.m_7949_();
            Boolean isPathfindable = (Boolean)this.cache.getIfPresent((Object)immutablePos);
            if (isPathfindable == null) {
                BlockState blockState = this.f_26495_.m_8055_((BlockPos)pos);
                isPathfindable = blockState.m_60647_((BlockGetter)this.f_26495_, (BlockPos)pos, PathComputationType.LAND);
                this.cache.put((Object)immutablePos, (Object)isPathfindable);
            }
            if (!isPathfindable.booleanValue()) {
                return false;
            }
            BlockPathTypes pathType = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, currentX, currentY, currentZ, this.f_26494_);
            float malus = this.f_26494_.m_21439_(pathType);
            if (!(malus < 0.0f) && !(malus >= 8.0f) && pathType != BlockPathTypes.DAMAGE_FIRE && pathType != BlockPathTypes.DANGER_FIRE && pathType != BlockPathTypes.DAMAGE_OTHER) continue;
            return false;
        }
        return true;
    }
}

