/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.companions.client.projectile.model.SoulMageBookModel;
import dev.xylonity.companions.common.entity.projectile.SoulMageBookEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class SoulMageBookRenderer
extends GeoEntityRenderer<SoulMageBookEntity> {
    public SoulMageBookRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SoulMageBookModel());
        this.addRenderLayer(new SoulMageBookGlowLayer((GeoRenderer<SoulMageBookEntity>)this));
    }

    public void render(@NotNull SoulMageBookEntity entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, entity.m_5830_() ? 0xF00000 : packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SoulMageBookEntity animatable) {
        return new ResourceLocation("companions", "textures/entity/soul_mage_book.png");
    }

    static class SoulMageBookGlowLayer
    extends GeoRenderLayer<SoulMageBookEntity> {
        private static final ResourceLocation EMB_TEXTURE = new ResourceLocation("companions", "textures/entity/soul_mage_book_glow.png");

        public SoulMageBookGlowLayer(GeoRenderer<SoulMageBookEntity> entityRenderer) {
            super(entityRenderer);
        }

        public void render(PoseStack poseStack, SoulMageBookEntity entity, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            RenderType glowRenderType = RenderType.m_110473_((ResourceLocation)EMB_TEXTURE);
            float r = entity.getCurrentRed() / 255.0f;
            float g = entity.getCurrentGreen() / 255.0f;
            float b = entity.getCurrentBlue() / 255.0f;
            VertexConsumer glowBuffer = bufferSource.m_6299_(glowRenderType);
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)entity, glowRenderType, glowBuffer, partialTick, packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
        }
    }
}

