/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.blockentity.VoltaicPillarBlockEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class StaticElectricConnectionLayer<T extends AbstractTeslaBlockEntity>
extends GeoRenderLayer<T> {
    private final ResourceLocation texture;
    private final int totalFrames;
    private final int ticksPerFrame;

    public StaticElectricConnectionLayer(GeoRenderer<T> renderer, ResourceLocation texture, int totalFrames, int ticksPerFrame) {
        super(renderer);
        this.texture = texture;
        this.totalFrames = totalFrames;
        this.ticksPerFrame = ticksPerFrame;
    }

    public void render(PoseStack poseStack, T animatable, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!((AbstractTeslaBlockEntity)((Object)animatable)).isActive()) {
            return;
        }
        int frame = this.calculateCurrentFrame(animatable);
        for (TeslaConnectionManager.ConnectionNode node : TeslaConnectionManager.getInstance().getOutgoing(((AbstractTeslaBlockEntity)((Object)animatable)).asConnectionNode())) {
            AbstractTeslaBlockEntity be;
            if (node == null) continue;
            if (node.isEntity()) {
                Entity entity = CompanionsEntityTracker.getEntityByUUID(node.entityId());
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                Vec3 offset = new Vec3(0.0, 1.25, 0.0);
                Vec3 dir = livingEntity.m_20182_().m_82546_(animatable.m_58899_().m_252807_()).m_82520_(0.0, (double)livingEntity.m_20206_() * 1.1, 0.0);
                this.renderConnection(bufferSource, poseStack, offset, dir, frame, packedLight);
                continue;
            }
            if (!node.isBlock() || !((be = TeslaConnectionManager.getInstance().getBlockEntity(node)) instanceof VoltaicPillarBlockEntity)) continue;
            Vec3 offset = ((AbstractTeslaBlockEntity)((Object)animatable)).electricalChargeOriginOffset();
            Vec3 blockPos = be.m_58899_().m_252807_();
            Vec3 blockPosVec = new Vec3(blockPos.f_82479_, blockPos.f_82480_, blockPos.f_82481_);
            Vec3 dir = blockPosVec.m_82546_(animatable.m_58899_().m_252807_()).m_82549_(be.electricalChargeEndOffset());
            this.renderConnection(bufferSource, poseStack, offset, dir, frame, packedLight);
        }
    }

    private int calculateCurrentFrame(T animatable) {
        if (animatable.m_58904_() != null) {
            long elapsed = animatable.m_58904_().m_46467_() - (long)((AbstractTeslaBlockEntity)((Object)animatable)).getAnimationStartTick();
            return (int)(elapsed / (long)this.ticksPerFrame) % this.totalFrames + 1;
        }
        return 0;
    }

    private void renderConnection(MultiBufferSource bufferSource, PoseStack poseStack, Vec3 p0, Vec3 p1, int frame, int light) {
        int[] indices;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(AutoGlowingTexture.getRenderType((ResourceLocation)this.texture));
        Matrix4f positionMatrix = poseStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
        float x0 = (float)p0.f_82479_;
        float y0 = (float)p0.f_82480_;
        float z0 = (float)p0.f_82481_;
        float x1 = (float)p1.f_82479_;
        float y1 = (float)p1.f_82480_;
        float z1 = (float)p1.f_82481_;
        float dx = x1 - x0;
        float dy = y1 - y0;
        float dz = z1 - z0;
        if (dx == 0.0f) {
            dx = 0.001f;
        }
        float dHorizontal = Mth.m_14116_((float)(dx * dx + dz * dz));
        float length = Mth.m_14116_((float)(dHorizontal * dHorizontal + dy * dy));
        float offset = 0.5f;
        float yOffset = offset * (dHorizontal / length);
        float xOffset = offset * (dy / length) * (dx / dHorizontal);
        float zOffset = offset * (dy / length) * (dz / dHorizontal);
        float frameSize = 1.0f / (float)this.totalFrames;
        float v0 = (float)frame * frameSize;
        float v1 = v0 + frameSize;
        VertexCoordinates[] vertices = new VertexCoordinates[]{new VertexCoordinates(x0 + xOffset, y0 - yOffset, z0 + zOffset, 0.0f, v1), new VertexCoordinates(x1 + xOffset, y1 - yOffset, z1 + zOffset, 1.0f, v1), new VertexCoordinates(x1 - xOffset, y1 + yOffset, z1 - zOffset, 1.0f, v0), new VertexCoordinates(x0 - xOffset, y0 + yOffset, z0 - zOffset, 0.0f, v0)};
        for (int i : indices = new int[]{0, 1, 2, 3, 3, 2, 1, 0}) {
            this.produceVertex(vertexConsumer, positionMatrix, normalMatrix, light, vertices[i].x, vertices[i].y, vertices[i].z, vertices[i].u, vertices[i].v);
        }
    }

    private void produceVertex(VertexConsumer vertexConsumer, Matrix4f positionMatrix, Matrix3f normalMatrix, int light, float x, float y, float z, float textureU, float textureV) {
        vertexConsumer.m_252986_(positionMatrix, x, y, z).m_6122_(255, 255, 255, 255).m_7421_(textureU, textureV).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private record VertexCoordinates(float x, float y, float z, float u, float v) {
    }
}

