/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.entity.model;

import dev.xylonity.companions.common.entity.hostile.SacredPontiffEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class SacredPontiffModel
extends GeoModel<SacredPontiffEntity> {
    public ResourceLocation getModelResource(SacredPontiffEntity animatable) {
        if (animatable.getState() >= 5) {
            return new ResourceLocation("companions", "geo/his_holiness.geo.json");
        }
        return new ResourceLocation("companions", "geo/sacred_pontiff.geo.json");
    }

    public ResourceLocation getTextureResource(SacredPontiffEntity animatable) {
        if (animatable.getState() >= 5) {
            if (animatable.m_21224_()) {
                int frames = 21;
                int perTick = 10;
                int frameIndex = animatable.f_20919_ / perTick % frames;
                return new ResourceLocation("companions", String.format("textures/entity/his_holiness_petrification%d.png", frameIndex));
            }
            return new ResourceLocation("companions", "textures/entity/his_holiness_" + animatable.f_19797_ / 2 % 10 + ".png");
        }
        return new ResourceLocation("companions", "textures/entity/sacred_pontiff_" + animatable.f_19797_ / 2 % 5 + ".png");
    }

    public ResourceLocation getAnimationResource(SacredPontiffEntity animatable) {
        if (animatable.getState() >= 5) {
            return new ResourceLocation("companions", "animations/his_holiness.animation.json");
        }
        return new ResourceLocation("companions", "animations/sacred_pontiff.animation.json");
    }

    public void setCustomAnimations(SacredPontiffEntity animatable, long instanceId, AnimationState<SacredPontiffEntity> animationState) {
        Entity camera;
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * 0.5f * ((float)Math.PI / 180));
        }
        if ((camera = Minecraft.m_91087_().m_91288_()) == null) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        Vec3 cameraPos = camera.m_20299_(partialTick);
        Vec3 entityPos = animatable.m_20299_(partialTick);
        Vec3 diff = new Vec3(cameraPos.f_82479_ - entityPos.f_82479_, 0.0, cameraPos.f_82481_ - entityPos.f_82481_).m_82541_();
        Vec3 view = animatable.m_20252_(partialTick).m_82541_();
        view = new Vec3(view.f_82479_, 0.0, view.f_82481_).m_82541_();
        Vec3 lateral = new Vec3(-view.f_82481_, 0.0, view.f_82479_);
        float dot = (float)(diff.f_82479_ * lateral.f_82479_ + diff.f_82481_ * lateral.f_82481_);
        dot = Mth.m_14036_((float)dot, (float)-1.0f, (float)1.0f);
        CoreGeoBone leftEyeBone = this.getAnimationProcessor().getBone("left_eye");
        CoreGeoBone rightEyeBone = this.getAnimationProcessor().getBone("right_eye");
        float baseLeftEyeX = -0.0f;
        float baseRightEyeX = 0.0f;
        if (leftEyeBone != null) {
            leftEyeBone.setPosX(baseLeftEyeX - dot);
        }
        if (rightEyeBone != null) {
            rightEyeBone.setPosX(baseRightEyeX - dot);
        }
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
    }
}

