/*
 * Decompiled with CFR 0.152.
 */
package dev.the_millman.christmasfestivity.core.loot;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="christmasfestivity")
public class LootHandler {
    @SubscribeEvent
    public static void lootLoad(LootTableLoadEvent event) {
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix)) {
            String file;
            switch (file = name.substring(name.indexOf(prefix) + prefix.length())) {
                case "simple_dungeon": 
                case "igloo_chest": 
                case "spawn_bonus_chest": 
                case "woodland_mansion": {
                    event.getTable().addPool(LootHandler.getInjectPool(file));
                    break;
                }
            }
        }
    }

    public static LootPool getInjectPool(String entryName) {
        return LootPool.m_79043_().m_79076_(LootHandler.getInjectEntry(entryName, 1)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).name("christmasfestivity_inject").m_79082_();
    }

    private static LootPoolSingletonContainer.Builder<?> getInjectEntry(String name, int weight) {
        ResourceLocation table = new ResourceLocation("christmasfestivity", "inject/" + name);
        return LootTableReference.m_79776_((ResourceLocation)table).m_79707_(weight);
    }
}

