/*
 * Decompiled with CFR 0.152.
 */
package dev.the_millman.christmasfestivity.common.blocks;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FourLightBlock
extends Block {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    protected static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.f_55154_.entrySet().stream().filter(property -> ((Direction)property.getKey()).m_122434_().m_122479_()).collect(Util.m_137448_());
    protected final VoxelShape[] collisionShapeByIndex;
    protected final VoxelShape[] shapeByIndex;
    private final Object2IntMap<BlockState> stateToIndex = new Object2IntOpenHashMap();

    public FourLightBlock(float pNodeWidth, float pExtensionWidth, float pNodeHeight, float pExtensionHeight, float pCollisionHeight, BlockBehaviour.Properties properties) {
        super(properties);
        this.collisionShapeByIndex = this.makeShapes(pNodeWidth, pExtensionWidth, pCollisionHeight, 3.0f, pCollisionHeight);
        this.shapeByIndex = this.makeShapes(pNodeWidth, pExtensionWidth, pNodeHeight, 3.0f, pExtensionHeight);
        for (BlockState blockstate : this.f_49792_.m_61056_()) {
            this.getAABBIndex(blockstate);
        }
    }

    protected VoxelShape[] makeShapes(float pNodeWidth, float pExtensionWidth, float pNodeHeight, float pExtensionBottom, float pExtensionHeight) {
        float f = 8.0f - pNodeWidth;
        float f1 = 8.0f + pNodeWidth;
        float f2 = 8.0f - pExtensionWidth;
        float f3 = 8.0f + pExtensionWidth;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)3.0, (double)f, (double)f1, (double)pNodeHeight, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)pExtensionBottom, (double)3.0, (double)f3, (double)pExtensionHeight, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)pExtensionBottom, (double)f2, (double)f3, (double)pExtensionHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)3.0, (double)pExtensionBottom, (double)f2, (double)f3, (double)pExtensionHeight, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)pExtensionBottom, (double)f2, (double)16.0, (double)pExtensionHeight, (double)f3);
        VoxelShape voxelshape5 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.m_83040_(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.m_83110_((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.m_83110_((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeByIndex[this.getAABBIndex(pState)];
    }

    private static int indexFor(Direction facing) {
        return 1 << facing.m_122416_();
    }

    protected int getAABBIndex(BlockState state) {
        return this.stateToIndex.computeIfAbsent((Object)state, newState -> {
            int i = 0;
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                i |= FourLightBlock.indexFor(Direction.NORTH);
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                i |= FourLightBlock.indexFor(Direction.EAST);
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                i |= FourLightBlock.indexFor(Direction.SOUTH);
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                i |= FourLightBlock.indexFor(Direction.WEST);
            }
            return i;
        });
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)NORTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)EAST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)((Boolean)state.m_61143_((Property)SOUTH)))).m_61124_((Property)SOUTH, (Comparable)((Boolean)state.m_61143_((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)((Boolean)state.m_61143_((Property)WEST)))).m_61124_((Property)WEST, (Comparable)((Boolean)state.m_61143_((Property)EAST)));
            }
        }
        return super.m_6943_(state, mirror);
    }
}

