/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.integration.kubejs.affixjs;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.AffixSettingBuilder;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.data.AffixSetting;
import top.theillusivec4.champions.common.affix.core.CombatLifeCycleAffix;
import top.theillusivec4.champions.common.integration.kubejs.ChampionsKubeJSPlugin;
import top.theillusivec4.champions.common.integration.kubejs.affixjs.AffixBehavior;

public class CustomAffix
extends CombatLifeCycleAffix {
    private final AffixBehavior behavior;

    public CustomAffix(AffixSetting setting, AffixBehavior behavior) {
        this.setting = setting;
        this.behavior = behavior;
    }

    @Override
    public void onInitialSpawn(IChampion champion) {
        if (this.behavior.onInitialSpawnCallback != null) {
            this.behavior.onInitialSpawnCallback.onInitialSpawn(champion);
        }
    }

    @Override
    public void onSpawn(IChampion champion) {
        if (this.behavior.onSpawnCallback != null) {
            this.behavior.onSpawnCallback.onSpawn(champion);
        }
    }

    @Override
    public void onServerUpdate(IChampion champion) {
        if (this.behavior.onServerUpdateCallback != null) {
            this.behavior.onServerUpdateCallback.onServerUpdate(champion);
        }
    }

    @Override
    public void onClientUpdate(IChampion champion) {
        if (this.behavior.onClientUpdateCallback != null) {
            this.behavior.onClientUpdateCallback.onClientUpdate(champion);
        }
    }

    @Override
    public boolean onAttack(IChampion champion, LivingEntity target, DamageSource source, float amount) {
        if (this.behavior.onAttackCallback != null) {
            return this.behavior.onAttackCallback.onAttack(champion, target, source, amount);
        }
        return super.onAttack(champion, target, source, amount);
    }

    @Override
    public boolean onAttacked(IChampion champion, DamageSource source, float amount) {
        if (this.behavior.onAttackedCallback != null) {
            return this.behavior.onAttackedCallback.onAttacked(champion, source, amount);
        }
        return super.onAttacked(champion, source, amount);
    }

    @Override
    public float onHurt(IChampion champion, DamageSource source, float amount, float newAmount) {
        if (this.behavior.onHurtCallback != null) {
            return this.behavior.onHurtCallback.onHurt(champion, source, amount, newAmount);
        }
        return super.onHurt(champion, source, amount, newAmount);
    }

    @Override
    public float onHeal(IChampion champion, float amount, float newAmount) {
        if (this.behavior.onHealCallback != null) {
            return this.behavior.onHealCallback.onHeal(champion, amount, newAmount);
        }
        return super.onHeal(champion, amount, newAmount);
    }

    @Override
    public float onDamage(IChampion champion, DamageSource source, float amount, float newAmount) {
        if (this.behavior.onDamageCallback != null) {
            return this.behavior.onDamageCallback.onDamage(champion, source, amount, newAmount);
        }
        return super.onDamage(champion, source, amount, newAmount);
    }

    @Override
    public boolean onDeath(IChampion champion, DamageSource source) {
        if (this.behavior.onDeathCallback != null) {
            return this.behavior.onDeathCallback.onDeath(champion, source);
        }
        return super.onDeath(champion, source);
    }

    public static class Builder
    extends BuilderBase<CustomAffix> {
        private final AffixBehavior behavior = new AffixBehavior();
        private final AffixSettingBuilder settingBuilder = new AffixSettingBuilder();

        public Builder(ResourceLocation id) {
            super(id);
        }

        public RegistryInfo<?> getRegistryType() {
            return ChampionsKubeJSPlugin.CUSTOM_AFFIX;
        }

        public Builder behavior(Consumer<AffixBehavior> consumer) {
            consumer.accept(this.behavior);
            return this;
        }

        public Builder settings(Consumer<AffixSettingBuilder> consumer) {
            consumer.accept(this.settingBuilder);
            return this;
        }

        public CustomAffix createObject() {
            AffixSetting setting = this.settingBuilder.setType(this.id).build();
            CustomAffix affix = new CustomAffix(setting, this.behavior);
            Champions.API.addCategory(setting.category(), affix);
            return affix;
        }
    }
}

