/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.capability.BossCapability;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class MeleeShieldAttackGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:shieldmelee");
    private final BossType bossType;
    protected final Mob mob;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final double attackInterval;
    private long lastCanUseCheck;
    int shieldTicks = 0;

    public MeleeShieldAttackGoal(Mob entity, double speed) {
        this.mob = entity;
        this.speedModifier = speed;
        this.followingTargetEvenIfNotSeen = true;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        this.bossType = ((BossCapability)this.mob.getCapability(BossCapability.BOSS_CAP).orElse(null)).getBossType();
        this.attackInterval = this.bossType.getCustomAttributeValueOrDefault("attack_speed", 1.0f);
    }

    public boolean m_8036_() {
        long timeDiff = this.mob.m_9236_().m_46467_();
        if (timeDiff - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = timeDiff;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null || !livingentity.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
        this.mob.m_6672_(InteractionHand.MAIN_HAND);
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
        double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
            this.pathedTargetX = livingentity.m_20185_();
            this.pathedTargetY = livingentity.m_20186_();
            this.pathedTargetZ = livingentity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
            if (d0 > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d0 > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)livingentity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity target, double dist) {
        double d0 = this.getAttackReachSqr(target);
        if (dist <= d0 && this.ticksUntilNextAttack <= 0) {
            this.resetAttackCooldown();
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)target);
        }
        if (this.shieldTicks == -20 && BrutalBosses.rand.nextInt(20) == 0) {
            this.mob.m_6672_(InteractionHand.OFF_HAND);
            this.shieldTicks = BrutalBosses.rand.nextInt(10) + 20;
        }
        if (this.shieldTicks > -20) {
            --this.shieldTicks;
            if (this.shieldTicks == 0) {
                this.mob.m_5810_();
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = (int)(20.0 / this.attackInterval);
    }

    protected double getAttackReachSqr(LivingEntity entity) {
        return (double)(this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f) * (double)this.bossType.getVisualScale();
    }
}

