/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.item;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import net.unusual.blockfactorysbosses.AnimationTickHolder;
import net.unusual.blockfactorysbosses.client.model.Modelchestplate;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModItems;

public abstract class DragonBonesItem
extends ArmorItem {
    public DragonBonesItem(ArmorItem.Type type, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_266425_(ArmorItem.Type type) {
                return (new int[]{13, 15, 16, 11})[type.m_266308_().m_20749_()] * 35;
            }

            public int m_7366_(ArmorItem.Type type) {
                return (new int[]{3, 6, 8, 3})[type.m_266308_().m_20749_()];
            }

            public int m_6646_() {
                return 9;
            }

            public SoundEvent m_7344_() {
                return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.armor.equip_netherite"));
            }

            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlockFactorysBossesModItems.DRAGON_BONE.get())});
            }

            public String m_6082_() {
                return "dragon_bones";
            }

            public float m_6651_() {
                return 2.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, type, properties);
    }

    public static class Boots
    extends DragonBonesItem {
        public Boots() {
            super(ArmorItem.Type.BOOTS, new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41486_());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "block_factorys_bosses:textures/entities/dragon_armor_boots.png";
        }
    }

    public static class Leggings
    extends DragonBonesItem {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS, new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41486_());
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            int index = Mth.m_14143_((float)((float)(Math.round(AnimationTickHolder.getRenderTime()) % 40) * 0.4f));
            return "block_factorys_bosses:textures/entities/dragon_leggings/dragon_leggings_" + index + ".png";
        }
    }

    public static class Chestplate
    extends DragonBonesItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41486_());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                @OnlyIn(value=Dist.CLIENT)
                public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelchestplate<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelchestplate.LAYER_LOCATION)).body, "left_arm", new Modelchestplate<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelchestplate.LAYER_LOCATION)).leftArm, "right_arm", new Modelchestplate<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)Modelchestplate.LAYER_LOCATION)).rightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            int index = Mth.m_14143_((float)((float)(Math.round(AnimationTickHolder.getRenderTime()) % 40) * 0.4f));
            return "block_factorys_bosses:textures/entities/dragon_chestplate/dragon_chestplate_" + index + ".png";
        }
    }
}

