/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.belt;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class ChorusTotemItem
extends WearableArtifactItem {
    @Override
    public boolean hasNonCosmeticEffects() {
        return ModGameRules.CHORUS_TOTEM_TELEPORTATION_CHANCE.get() > 0.0;
    }

    @Override
    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        if (ModGameRules.CHORUS_TOTEM_TELEPORTATION_CHANCE.fuzzyEquals(1.0)) {
            tooltip.add(this.tooltipLine("constant", new Object[0]));
        } else {
            tooltip.add(this.tooltipLine("chance", new Object[0]));
        }
        if (!ModGameRules.CHORUS_TOTEM_DO_CONSUME_ON_USE.get().booleanValue()) {
            tooltip.add(this.tooltipLine("not_consumed", new Object[0]));
        }
    }

    public static ItemStack findTotem(LivingEntity entity) {
        if (ModItems.CHORUS_TOTEM.get().isOnCooldown(entity)) {
            return ItemStack.f_41583_;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack handItem = entity.m_21120_(hand);
            if (!handItem.m_150930_((Item)ModItems.CHORUS_TOTEM.get())) continue;
            return handItem;
        }
        return PlatformServices.platformHelper.findAllEquippedBy(entity, ModItems.CHORUS_TOTEM.get()).findFirst().orElse(ItemStack.f_41583_);
    }

    public static void teleport(LivingEntity entity, ServerLevel level) {
        double oldX = entity.m_20185_();
        double oldY = entity.m_20186_();
        double oldZ = entity.m_20189_();
        for (int i = 0; i < 32; ++i) {
            double newX = entity.m_20185_() + (entity.m_217043_().m_188500_() - 0.5) * 32.0;
            double newY = Mth.m_14008_((double)(entity.m_20186_() + (double)entity.m_217043_().m_188503_(16) - 8.0), (double)level.m_141937_(), (double)(level.m_141937_() + level.m_143344_() - 1));
            double newZ = entity.m_20189_() + (entity.m_217043_().m_188500_() - 0.5) * 32.0;
            Vec3 oldPos = entity.m_20182_();
            if (oldPos.m_82531_(newX, newY, newZ) < 256.0) continue;
            if (entity.m_20159_()) {
                entity.m_8127_();
            }
            if (!entity.m_20984_(newX, newY, newZ, true)) continue;
            entity.m_9236_().m_214171_(GameEvent.f_238175_, oldPos, GameEvent.Context.m_223717_((Entity)entity));
            entity.m_9236_().m_6263_(null, oldX, oldY, oldZ, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity.m_9236_().m_6263_(null, newX, newY, newZ, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
            break;
        }
    }
}

