/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.inventory;

import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearFurnaceBlockEntity;
import com.github.alexmodguy.alexscaves.server.inventory.ACMenuRegistry;
import com.github.alexmodguy.alexscaves.server.inventory.NuclearFurnaceResultSlot;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class NuclearFurnaceMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;
    protected final Level level;

    public NuclearFurnaceMenu(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(5), (ContainerData)new SimpleContainerData(5));
    }

    public NuclearFurnaceMenu(int id, Inventory inventory, Container furnaceContainer, ContainerData dataAccess) {
        super((MenuType)ACMenuRegistry.NUCLEAR_FURNACE_MENU.get(), id);
        this.container = furnaceContainer;
        this.data = dataAccess;
        this.level = inventory.f_35978_.m_9236_();
        this.m_38897_(new Slot(furnaceContainer, 0, 67, 17));
        this.m_38897_(new FuelSlot(this, furnaceContainer, 1, 67, 53, false));
        this.m_38897_(new FuelSlot(this, furnaceContainer, 2, 37, 53, true));
        this.m_38897_((Slot)new NuclearFurnaceResultSlot(inventory.f_35978_, furnaceContainer, 3, 127, 35));
        this.m_38897_((Slot)new NuclearFurnaceResultSlot(inventory.f_35978_, furnaceContainer, 4, 37, 17));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(dataAccess);
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slotIndex == 3 || slotIndex == 4) {
                if (!this.m_38903_(itemstack1, 5, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (slotIndex != 2 && slotIndex != 1 && slotIndex != 0 ? (this.canSmelt(itemstack1) ? !this.m_38903_(itemstack1, 0, 1, false) : (this.isFuel(itemstack1) ? !this.m_38903_(itemstack1, 1, 2, false) : (this.isBarrel(itemstack1) ? !this.m_38903_(itemstack1, 2, 3, false) : (slotIndex >= 4 && slotIndex < 30 ? !this.m_38903_(itemstack1, 30, 39, false) : slotIndex >= 30 && slotIndex < 39 && !this.m_38903_(itemstack1, 5, 30, false))))) : !this.m_38903_(itemstack1, 5, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    private boolean canSmelt(ItemStack stack) {
        return this.level.m_7465_().m_44015_(NuclearFurnaceBlockEntity.getRecipeType(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.level).isPresent();
    }

    private boolean isFuel(ItemStack stack) {
        return stack.m_204117_(ACTagRegistry.NUCLEAR_FURNACE_RODS);
    }

    private boolean isBarrel(ItemStack stack) {
        return stack.m_204117_(ACTagRegistry.NUCLEAR_FURNACE_BARRELS);
    }

    public float getWasteScale() {
        int i = this.data.m_6413_(0);
        return (float)i / (float)NuclearFurnaceBlockEntity.MAX_WASTE;
    }

    public float getBarrelScale() {
        int i = this.data.m_6413_(1);
        return (float)i / (float)NuclearFurnaceBlockEntity.MAX_BARRELING_TIME;
    }

    public float getFissionScale() {
        int i = this.data.m_6413_(2);
        return (float)i / (float)NuclearFurnaceBlockEntity.getMaxFissionTime();
    }

    public float getCookScale() {
        int i = this.data.m_6413_(3);
        int j = this.data.m_6413_(4);
        return (float)i / (float)j;
    }

    private class FuelSlot
    extends Slot {
        private final NuclearFurnaceMenu menu;
        private final boolean barrel;

        public FuelSlot(NuclearFurnaceMenu nuclearFurnaceMenu2, Container container, int slot, int x, int y, boolean barrel) {
            super(container, slot, x, y);
            this.menu = nuclearFurnaceMenu2;
            this.barrel = barrel;
        }

        public boolean m_5857_(ItemStack stack) {
            return this.barrel ? this.menu.isBarrel(stack) : this.menu.isFuel(stack);
        }
    }
}

