/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.mojang.datafixers.DataFixUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class LanternfishEntity
extends WaterAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(LanternfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float landProgress;
    private float prevLandProgress;
    private float circleSpeed = 1.0f;
    private float fishPitch = 0.0f;
    private float prevFishPitch = 0.0f;
    private int baitballCooldown = 100 + this.f_19796_.m_188503_(100);
    private int circleTime = 0;
    private int maxCircleTime = 300;
    private BlockPos circlePos;
    private LanternfishEntity groupLeader;
    private int groupSize = 1;

    public LanternfishEntity(EntityType<? extends WaterAnimal> type, Level level) {
        super(type, level);
        this.f_21342_ = new LanternfishMoveControl();
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SwimInSchoolGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new JoinSchoolGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22276_, 2.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20072_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            Vec3 delta = this.m_20184_();
            this.m_6478_(MoverType.SELF, delta);
            this.m_20256_(delta.m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_5625_(float f) {
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double dist) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean sit) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)sit);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public void m_8119_() {
        boolean grounded;
        super.m_8119_();
        this.prevLandProgress = this.landProgress;
        this.prevFishPitch = this.fishPitch;
        boolean bl = grounded = this.m_20096_() && !this.m_20072_();
        if (grounded && this.landProgress < 5.0f) {
            this.landProgress += 1.0f;
        }
        if (!grounded && this.landProgress > 0.0f) {
            this.landProgress -= 1.0f;
        }
        this.fishPitch = Mth.m_14036_((float)((float)this.m_20184_().f_82480_ * 3.0f), (float)-1.4f, (float)1.4f) * -57.295776f;
        if (!this.m_20072_() && this.m_6084_() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_5496_((SoundEvent)ACSoundRegistry.LANTERNFISH_FLOP.get(), this.m_6121_(), this.m_6100_());
        }
        if (this.baitballCooldown > 0) {
            --this.baitballCooldown;
        }
    }

    public float getFishPitch(float partialTick) {
        return this.prevFishPitch + (this.fishPitch - this.prevFishPitch) * partialTick;
    }

    protected void m_6229_(int prevAir) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(prevAir - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269483_(), 2.0f);
            }
        } else {
            this.m_20301_(200);
        }
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 10.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public float getLandProgress(float partialTicks) {
        return (this.prevLandProgress + (this.landProgress - this.prevLandProgress) * partialTicks) * 0.2f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag platTag = new CompoundTag();
        this.m_7380_(platTag);
        CompoundTag compound = bucket.m_41784_();
        compound.m_128365_("FishBucketTag", (Tag)platTag);
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        if (compound.m_128441_("FishBucketTag")) {
            this.m_7378_(compound.m_128469_("FishBucketTag"));
        }
        this.m_20301_(2000);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ACItemRegistry.LANTERNFISH_BUCKET.get());
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public void leaveGroup() {
        if (this.groupLeader != null) {
            this.groupLeader.decreaseGroupSize();
        }
        this.groupLeader = null;
    }

    protected boolean hasNoLeader() {
        return !this.hasGroupLeader();
    }

    public boolean hasGroupLeader() {
        return this.groupLeader != null && this.groupLeader.m_6084_();
    }

    private void increaseGroupSize() {
        ++this.groupSize;
    }

    private void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canGroupGrow() {
        return this.isGroupLeader() && this.groupSize < this.getMaxGroupSize();
    }

    private int getMaxGroupSize() {
        return 20;
    }

    public int m_5792_() {
        return this.getMaxGroupSize();
    }

    public boolean m_7296_(int sizeIn) {
        return false;
    }

    public boolean isGroupLeader() {
        return this.groupSize > 1;
    }

    public boolean inRangeOfGroupLeader() {
        return this.m_20280_((Entity)this.groupLeader) <= 121.0;
    }

    public static boolean checkLanternfishSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return level.m_6425_(pos).m_205070_(FluidTags.f_13131_) && pos.m_123342_() < level.m_5736_() - 30;
    }

    public void moveToGroupLeader() {
        if (this.hasGroupLeader()) {
            this.m_21573_().m_26519_(this.groupLeader.m_20185_(), this.groupLeader.m_20186_(), this.groupLeader.m_20189_(), 1.0);
        }
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos down = this.m_20183_();
        while (!world.m_6425_(down).m_76178_() && down.m_123342_() > world.m_141937_()) {
            down = down.m_7495_();
        }
        this.m_6034_((float)down.m_123341_() + 0.5f, down.m_123342_() + 2, (float)down.m_123343_() + 0.5f);
    }

    public LanternfishEntity createAndSetLeader(LanternfishEntity leader) {
        this.groupLeader = leader;
        leader.increaseGroupSize();
        return leader;
    }

    public void createFromStream(Stream<LanternfishEntity> stream) {
        stream.limit(this.getMaxGroupSize() - this.groupSize).filter(fishe -> fishe != this).forEach(fishe -> fishe.createAndSetLeader(this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new GroupData(this);
        } else {
            this.createAndSetLeader(((GroupData)((Object)spawnDataIn)).groupLeader);
        }
        if (reason == MobSpawnType.NATURAL) {
            this.doInitialPosing((LevelAccessor)worldIn);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean isCircling() {
        return this.circlePos != null && this.circleTime < this.maxCircleTime;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.LANTERNFISH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.LANTERNFISH_HURT.get();
    }

    private class LanternfishMoveControl
    extends MoveControl {
        public LanternfishMoveControl() {
            super((Mob)LanternfishEntity.this);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.f_24974_.m_20072_()) {
                double maxDist;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
                double d5 = vector3d.m_82553_();
                double d = maxDist = this.f_24974_.m_20191_().m_82309_() > 1.0 ? 1.0 : this.f_24974_.m_20191_().m_82309_();
                if (d5 < maxDist) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82490_(0.85));
                } else {
                    this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82549_(vector3d.m_82490_(this.f_24978_ * (double)0.02f / d5)));
                    Vec3 vector3d1 = this.f_24974_.m_20184_();
                    float f = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 180.0f / (float)Math.PI;
                    this.f_24974_.m_146922_(Mth.m_14148_((float)this.f_24974_.m_146908_(), (float)f, (float)10.0f));
                    this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
                }
            }
        }
    }

    private class SwimInSchoolGoal
    extends Goal {
        private final LanternfishEntity fish;
        float circleDistance = 3.0f;
        boolean clockwise = false;

        public SwimInSchoolGoal(LanternfishEntity fish) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.fish = fish;
        }

        public boolean m_8036_() {
            return this.fish.isGroupLeader() || this.fish.hasNoLeader() || this.fish.hasGroupLeader() && this.fish.groupLeader.circlePos != null;
        }

        public void m_8037_() {
            if (this.fish.circleTime > this.fish.maxCircleTime) {
                this.fish.circleTime = 0;
                this.fish.circlePos = null;
            }
            if (this.fish.circlePos != null && this.fish.circleTime <= this.fish.maxCircleTime) {
                ++this.fish.circleTime;
                Vec3 movePos = this.orbitAroundPos(this.fish.circlePos);
                this.fish.m_21573_().m_26519_(movePos.m_7096_(), movePos.m_7098_(), movePos.m_7094_(), (double)this.fish.circleSpeed);
            } else if (this.fish.isGroupLeader()) {
                if (this.fish.baitballCooldown == 0) {
                    this.fish.baitballCooldown = 100 + this.fish.f_19796_.m_188503_(150);
                    if (this.fish.circlePos == null || this.fish.circleTime >= this.fish.maxCircleTime) {
                        this.fish.circleTime = 0;
                        this.fish.maxCircleTime = 100 + this.fish.f_19796_.m_188503_(200);
                        this.circleDistance = 1.0f + this.fish.f_19796_.m_188501_() * 1.5f;
                        this.fish.circleSpeed = 0.75f + this.fish.f_19796_.m_188501_() * 0.5f;
                        this.clockwise = this.fish.f_19796_.m_188499_();
                        this.fish.circlePos = this.findSwimToPos(3);
                    }
                }
            } else if (this.fish.f_19796_.m_188503_(40) == 0 || this.fish.hasNoLeader()) {
                Vec3 result = Vec3.m_82512_((Vec3i)this.findSwimToPos(6));
                this.fish.m_21573_().m_26519_(result.f_82479_, result.f_82480_, result.f_82481_, 1.0);
            } else if (this.fish.hasGroupLeader() && this.fish.groupLeader.circlePos != null && this.fish.circlePos == null) {
                this.fish.circlePos = this.fish.groupLeader.circlePos;
                this.fish.circleTime = this.fish.groupLeader.circleTime;
                this.fish.maxCircleTime = this.fish.groupLeader.maxCircleTime;
                this.circleDistance = 1.0f + this.fish.f_19796_.m_188501_() * 1.5f;
                this.clockwise = this.fish.f_19796_.m_188499_();
                this.fish.circleSpeed = 0.75f + this.fish.f_19796_.m_188501_() * 0.5f;
            }
        }

        public BlockPos findSwimToPos(int range) {
            int fishY = this.fish.m_146904_();
            BlockPos.MutableBlockPos move = new BlockPos.MutableBlockPos();
            move.m_122169_(this.fish.m_20185_(), this.fish.m_20186_() + 1.0, this.fish.m_20189_());
            while (move.m_123342_() < LanternfishEntity.this.m_9236_().m_151558_() && LanternfishEntity.this.m_9236_().m_6425_((BlockPos)move).m_205070_(FluidTags.f_13131_)) {
                move.m_122184_(0, 5, 0);
            }
            int surfaceY = move.m_123342_();
            move.m_122169_(this.fish.m_20185_(), this.fish.m_20186_() - 1.0, this.fish.m_20189_());
            while (move.m_123342_() > LanternfishEntity.this.m_9236_().m_141937_() && LanternfishEntity.this.m_9236_().m_6425_((BlockPos)move).m_205070_(FluidTags.f_13131_)) {
                move.m_122184_(0, -5, 0);
            }
            int floorY = move.m_123342_();
            int oceanHeight = surfaceY - floorY;
            BlockPos base = LanternfishEntity.this.m_9236_().m_46462_() ? this.fish.m_20183_().m_175288_(Mth.m_14045_((int)fishY, (int)(floorY + (int)((float)oceanHeight * 0.85f)), (int)surfaceY)) : this.fish.m_20183_().m_175288_(Mth.m_14045_((int)fishY, (int)(floorY + (int)((float)oceanHeight * 0.25f)), (int)(surfaceY - (int)((float)oceanHeight * 0.85f))));
            for (int i = 0; i < 15; ++i) {
                BlockPos blockPos = base.m_7918_(LanternfishEntity.this.f_19796_.m_188503_(range) - range / 2, LanternfishEntity.this.f_19796_.m_188503_(range) - range / 2, LanternfishEntity.this.f_19796_.m_188503_(range) - range / 2);
                if (!this.fish.m_9236_().m_6425_(blockPos).m_205070_(FluidTags.f_13131_) || blockPos.m_123342_() <= LanternfishEntity.this.m_9236_().m_141937_() + 1) continue;
                return blockPos;
            }
            return base;
        }

        public Vec3 orbitAroundPos(BlockPos target) {
            float prog = 1.0f - (float)this.fish.circleTime / (float)this.fish.maxCircleTime;
            float angle = 0.17453292f * this.fish.circleSpeed * (float)(this.clockwise ? -this.fish.circleTime : this.fish.circleTime);
            double extraX = (this.circleDistance * prog + 1.75f) * Mth.m_14031_((float)angle);
            double extraY = Math.sin(1.0f + (float)this.fish.m_19879_() * 0.2f + (float)this.fish.circleTime * 0.2f);
            double extraZ = (this.circleDistance * prog + 1.75f) * prog * Mth.m_14089_((float)angle);
            return new Vec3((double)((float)target.m_123341_() + 0.5f) + extraX, Math.max((double)((float)target.m_123342_() + 0.5f) + extraY, -62.0), (double)((float)target.m_123343_() + 0.5f) + extraZ);
        }
    }

    class JoinSchoolGoal
    extends Goal {
        private static final int INTERVAL_TICKS = 200;
        private final LanternfishEntity mob;
        private int timeToRecalcPath;
        private int nextStartTick;

        public JoinSchoolGoal(LanternfishEntity fish) {
            this.mob = fish;
            this.nextStartTick = this.nextStartTick(fish);
        }

        protected int nextStartTick(LanternfishEntity fish) {
            return JoinSchoolGoal.m_186073_((int)(100 + fish.m_217043_().m_188503_(100) % 20));
        }

        public boolean m_8036_() {
            if (this.mob.isGroupLeader() || this.mob.isCircling()) {
                return false;
            }
            if (this.mob.hasGroupLeader()) {
                return true;
            }
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            this.nextStartTick = this.nextStartTick(this.mob);
            Predicate<LanternfishEntity> predicate = p_25258_ -> p_25258_.canGroupGrow() || !p_25258_.hasGroupLeader();
            List list = this.mob.m_9236_().m_6443_(LanternfishEntity.class, this.mob.m_20191_().m_82377_(8.0, 8.0, 8.0), predicate);
            LanternfishEntity cc = (LanternfishEntity)((Object)DataFixUtils.orElse(list.stream().filter(LanternfishEntity::canGroupGrow).findAny(), (Object)((Object)this.mob)));
            cc.createFromStream(list.stream().filter(p_25255_ -> !p_25255_.hasGroupLeader()));
            return this.mob.hasGroupLeader();
        }

        public boolean m_8045_() {
            return this.mob.hasGroupLeader() && this.mob.inRangeOfGroupLeader() && !this.mob.isCircling();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.mob.leaveGroup();
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.mob.moveToGroupLeader();
            }
        }
    }

    public static class GroupData
    extends AgeableMob.AgeableMobGroupData {
        public final LanternfishEntity groupLeader;

        public GroupData(LanternfishEntity groupLeaderIn) {
            super(0.05f);
            this.groupLeader = groupLeaderIn;
        }
    }
}

