/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class UnderzealotProcessionGoal
extends Goal {
    public final UnderzealotEntity entity;
    private double speedModifier;
    private int attemptToFollowTicks = 0;

    public UnderzealotProcessionGoal(UnderzealotEntity underzealot, double speed) {
        this.entity = underzealot;
        this.speedModifier = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.entity.m_217043_().m_188503_(20) == 0 && this.entity.isPackFollower() && this.entity.getPriorPackMember() != null;
    }

    public boolean m_8045_() {
        return this.entity.isPackFollower() && this.entity.getPriorPackMember() != null;
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        this.attemptToFollowTicks = 0;
    }

    public void m_8037_() {
        if (this.entity.isDiggingInProgress() || this.entity.isBuried()) {
            this.entity.setPraying(false);
            return;
        }
        if (this.entity.getPriorPackMember() != null) {
            UnderzealotEntity priorPackMember = (UnderzealotEntity)this.entity.getPriorPackMember();
            double distanceTo = this.entity.m_20270_((Entity)priorPackMember);
            if (distanceTo > (double)(this.entity.m_20205_() + 0.5f)) {
                Vec3 vec3 = new Vec3(priorPackMember.m_20185_() - this.entity.m_20185_(), priorPackMember.m_20186_() - this.entity.m_20186_(), priorPackMember.m_20189_() - this.entity.m_20189_()).m_82541_().m_82490_(Math.max(distanceTo - 1.0, 0.0));
                this.entity.m_21573_().m_26519_(this.entity.m_20185_() + vec3.f_82479_, this.entity.m_20186_() + vec3.f_82480_, this.entity.m_20189_() + vec3.f_82481_, this.speedModifier);
            }
            if (distanceTo > 8.0) {
                ++this.attemptToFollowTicks;
                if (this.entity.m_21573_().m_26577_() || this.attemptToFollowTicks > 60) {
                    this.entity.setBuried(true);
                    this.entity.reemergeAt(priorPackMember.m_20183_(), 20 + this.entity.m_217043_().m_188503_(20));
                }
            } else {
                this.attemptToFollowTicks = 0;
            }
        }
    }
}

