/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.GloomothEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GloomothFlightGoal
extends Goal {
    private GloomothEntity entity;
    private double x;
    private double y;
    private double z;
    private int orbitAngleOffset = 0;
    private int orbitDistance = 1;

    public GloomothFlightGoal(GloomothEntity notor) {
        this.entity = notor;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.entity.m_20160_() || this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() || this.entity.m_20159_()) {
            return false;
        }
        if (this.entity.m_20096_() && !this.entity.isFlying() && this.entity.m_217043_().m_188503_(4) != 0) {
            return false;
        }
        Vec3 target = this.generatePosition();
        if (target == null) {
            return false;
        }
        this.x = target.f_82479_;
        this.y = target.f_82480_;
        this.z = target.f_82481_;
        return true;
    }

    public void m_8037_() {
        Vec3 target;
        if ((this.entity.f_19862_ || this.entity.f_19863_ && !this.entity.m_20096_() || this.entity.m_20275_(this.x, this.y, this.z) > 100.0) && (target = this.generatePosition()) != null) {
            this.x = target.f_82479_;
            this.y = target.f_82480_;
            this.z = target.f_82481_;
        }
        float speed = 1.0f;
        if (this.entity.lightPos != null) {
            this.entity.setFlying(true);
            speed = 1.1f;
        } else if (this.entity.m_20096_()) {
            this.entity.setFlying(false);
            speed = 1.0f;
        }
        this.entity.m_21573_().m_26519_(this.x, this.y, this.z, (double)speed);
    }

    @Nullable
    protected Vec3 generatePosition() {
        if (this.entity.lightPos != null) {
            return this.findLightCirclePos(this.entity.lightPos);
        }
        Vec3 vec3 = this.findFlightPos();
        if (this.isOverWaterOrVoid()) {
            return vec3.m_82520_(0.0, (double)(this.entity.m_217043_().m_188501_() * 8.0f), 0.0);
        }
        if (this.entity.m_217043_().m_188503_(20) != 0) {
            return vec3;
        }
        return this.groundPosition(vec3);
    }

    private Vec3 findLightCirclePos(BlockPos lightPos) {
        Vec3 center = lightPos.m_252807_();
        Vec3 offset = new Vec3((double)(this.entity.m_217043_().m_188501_() * 4.0f + 1.0f), (double)(this.entity.m_217043_().m_188501_() * 2.0f), 0.0).m_82524_((float)(Math.PI * 2 * (double)this.entity.m_217043_().m_188501_()));
        return center.m_82549_(offset);
    }

    private Vec3 findFlightPos() {
        Vec3 heightAdjusted = this.entity.m_20182_().m_82520_((double)(this.entity.m_217043_().m_188503_(10) - 5), 0.0, (double)(this.entity.m_217043_().m_188503_(10) - 5));
        if (this.entity.m_9236_().m_45527_(BlockPos.m_274446_((Position)heightAdjusted))) {
            ground = this.groundPosition(heightAdjusted);
            heightAdjusted = new Vec3(heightAdjusted.f_82479_, ground.f_82480_ + 4.0 + (double)this.entity.m_217043_().m_188503_(3), heightAdjusted.f_82481_);
        } else {
            ground = this.groundPosition(heightAdjusted);
            BlockPos ceiling = BlockPos.m_274446_((Position)ground).m_6630_(2);
            while (ceiling.m_123342_() < this.entity.m_9236_().m_151558_() && !this.entity.m_9236_().m_8055_(ceiling).m_280296_()) {
                ceiling = ceiling.m_7494_();
            }
            float randCeilVal = 0.3f + this.entity.m_217043_().m_188501_() * 0.5f;
            heightAdjusted = new Vec3(heightAdjusted.f_82479_, ground.f_82480_ + ((double)ceiling.m_123342_() - ground.f_82480_) * (double)randCeilVal, heightAdjusted.f_82481_);
        }
        BlockHitResult result = this.entity.m_9236_().m_45547_(new ClipContext(this.entity.m_146892_(), heightAdjusted, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return heightAdjusted;
        }
        return result.m_82450_();
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.entity.m_20183_();
        while (position.m_123342_() > this.entity.m_9236_().m_141937_() && this.entity.m_9236_().m_46859_(position)) {
            position = position.m_7495_();
        }
        return !this.entity.m_9236_().m_6425_(position).m_76178_() || this.entity.m_9236_().m_8055_(position).m_60713_(Blocks.f_50191_) || position.m_123342_() <= this.entity.m_9236_().m_141937_();
    }

    public Vec3 groundPosition(Vec3 airPosition) {
        BlockPos ground = BlockPos.m_274446_((Position)airPosition);
        while (ground.m_123342_() > this.entity.m_9236_().m_141937_() && !this.entity.m_9236_().m_8055_(ground).m_280296_()) {
            ground = ground.m_7495_();
        }
        return Vec3.m_82512_((Vec3i)ground.m_7495_());
    }

    public boolean m_8045_() {
        return this.entity.m_20275_(this.x, this.y, this.z) > 3.0 && !this.entity.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.entity.setFlying(true);
        this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
    }

    public void m_8041_() {
        this.entity.m_21573_().m_26573_();
        super.m_8041_();
    }
}

