/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.GingerbarrelBlockEntity;
import com.github.alexmodguy.alexscaves.server.block.poi.ACPOIRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.GingerbreadManEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class GingerbreadManStoreStolenItemsGoal
extends Goal {
    private int executionCooldown;
    private BlockPos barrelPos = null;
    private final GingerbreadManEntity mob;
    private int openBarrelTicks = 0;

    public GingerbreadManStoreStolenItemsGoal(GingerbreadManEntity mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.mob = mob;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if ((target == null || !target.m_6084_()) && (this.mob.m_21120_(InteractionHand.OFF_HAND).m_204117_(ACTagRegistry.GINGERBREAD_MAN_STEALS) || this.mob.isOvenSpawned() && !this.mob.m_21120_(InteractionHand.OFF_HAND).m_41619_())) {
            if (this.executionCooldown-- > 0) {
                return false;
            }
            this.executionCooldown = 20 + this.mob.m_217043_().m_188503_(30);
            BlockPos pos = null;
            if (this.mob.getLastBarrelPos() != null) {
                if (GingerbreadManStoreStolenItemsGoal.doesBarrelHaveSpace(this.mob.m_9236_(), this.mob.getLastBarrelPos(), this.mob.m_21120_(InteractionHand.OFF_HAND))) {
                    this.executionCooldown = 10;
                    pos = this.mob.getLastBarrelPos();
                } else {
                    this.mob.setLastBarrelPos(null);
                }
            }
            if (pos == null) {
                List<BlockPos> list = this.getNearbyBarrels(this.mob.m_20183_(), (ServerLevel)this.mob.m_9236_(), 32).sorted(Comparator.comparingDouble(arg_0 -> ((BlockPos)this.mob.m_20183_()).m_123331_(arg_0))).toList();
                if (!list.isEmpty()) {
                    pos = list.get(0);
                }
            }
            if (pos != null) {
                this.barrelPos = pos;
                this.mob.setLastBarrelPos(this.barrelPos);
                this.openBarrelTicks = 0;
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        return this.barrelPos != null && !this.mob.m_21120_(InteractionHand.OFF_HAND).m_41619_() && GingerbreadManStoreStolenItemsGoal.doesBarrelHaveSpace(this.mob.m_9236_(), this.barrelPos, this.mob.m_21120_(InteractionHand.OFF_HAND)) && (target == null || !target.m_6084_());
    }

    public void m_8041_() {
        BlockState barrelState;
        if (this.barrelPos != null && (barrelState = this.mob.m_9236_().m_8055_(this.barrelPos)).m_60713_((Block)ACBlockRegistry.GINGERBARREL.get())) {
            this.mob.m_9236_().m_46597_(this.barrelPos, (BlockState)barrelState.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(false)));
        }
        this.barrelPos = null;
    }

    private Stream<BlockPos> getNearbyBarrels(BlockPos blockpos, ServerLevel world, int range) {
        PoiManager pointofinterestmanager = world.m_8904_();
        return pointofinterestmanager.m_27138_(poiTypeHolder -> poiTypeHolder.m_203565_(ACPOIRegistry.GINGERBARREL.getKey()), blockpos2 -> GingerbreadManStoreStolenItemsGoal.doesBarrelHaveSpace((Level)world, blockpos2, this.mob.m_21120_(InteractionHand.OFF_HAND)), blockpos, range, PoiManager.Occupancy.ANY);
    }

    private static boolean doesBarrelHaveSpace(Level world, BlockPos pos, ItemStack addTo) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof GingerbarrelBlockEntity) {
            GingerbarrelBlockEntity barrel = (GingerbarrelBlockEntity)blockEntity;
            for (int i = 0; i < barrel.m_6643_(); ++i) {
                ItemStack stack = barrel.m_8020_(i);
                if (stack.m_41619_()) {
                    return true;
                }
                if (!stack.m_150930_(addTo.m_41720_()) || stack.m_41613_() + addTo.m_41613_() > addTo.m_41741_()) continue;
                return true;
            }
        }
        return false;
    }

    public void m_8037_() {
        Vec3 center = Vec3.m_82512_((Vec3i)this.barrelPos);
        double distance = Vec3.m_82539_((Vec3i)this.barrelPos).m_82546_(this.mob.m_20182_()).m_165924_();
        if (distance < 8.0) {
            this.mob.m_21563_().m_24950_(center.f_82479_, center.f_82480_, center.f_82481_, 10.0f, (float)this.mob.m_8132_());
        }
        if (distance > 1.5 && this.hasLineOfSightBarrel()) {
            this.mob.m_21573_().m_26519_((double)((float)this.barrelPos.m_123341_() + 0.5f), (double)this.barrelPos.m_123342_(), (double)((float)this.barrelPos.m_123343_() + 0.5f), 1.0);
        } else {
            BlockEntity blockEntity;
            if (this.openBarrelTicks < 5 && (this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION || this.mob.getAnimation() == null)) {
                this.mob.setAnimation(this.mob.getAnimationForHand(true));
            }
            ++this.openBarrelTicks;
            this.mob.setLastBarrelPos(this.barrelPos);
            this.mob.m_21573_().m_26573_();
            if (this.openBarrelTicks < 12 && this.openBarrelTicks > 5) {
                BlockState barrelState = this.mob.m_9236_().m_8055_(this.barrelPos);
                if (barrelState.m_60713_((Block)ACBlockRegistry.GINGERBARREL.get())) {
                    this.mob.m_9236_().m_46597_(this.barrelPos, (BlockState)barrelState.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(true)));
                }
            } else if (this.openBarrelTicks >= 12 && (blockEntity = this.mob.m_9236_().m_7702_(this.barrelPos)) instanceof GingerbarrelBlockEntity) {
                GingerbarrelBlockEntity barrel = (GingerbarrelBlockEntity)blockEntity;
                ItemStack itemstack = this.mob.m_21120_(InteractionHand.OFF_HAND).m_41777_();
                ItemStack itemstack1 = HopperBlockEntity.m_59326_(null, (Container)barrel, (ItemStack)itemstack, null);
                if (!this.mob.isOvenSpawned()) {
                    ItemStack itemStack;
                    int j;
                    int i = barrel.m_6643_();
                    HashSet<Item> candyItems = new HashSet<Item>();
                    for (j = 0; j < i && !barrel.m_7983_(); ++j) {
                        itemStack = barrel.m_8020_(j);
                        if (!itemStack.m_204117_(ACTagRegistry.GINGERBREAD_MAN_STEALS)) continue;
                        candyItems.add(itemStack.m_41720_());
                    }
                    if (candyItems.size() >= 9) {
                        for (j = 0; j < i && !barrel.m_7983_(); ++j) {
                            itemStack = barrel.m_8020_(j);
                            if (!itemStack.m_204117_(ACTagRegistry.GINGERBREAD_MAN_STEALS)) continue;
                            itemStack.m_41774_(1);
                        }
                        itemstack1 = HopperBlockEntity.m_59326_(null, (Container)barrel, (ItemStack)this.getRandomArmor(this.mob.m_217043_()), null);
                    }
                }
                this.mob.m_21008_(InteractionHand.OFF_HAND, itemstack1);
                this.m_8041_();
            }
        }
    }

    private ItemStack getRandomArmor(RandomSource random) {
        float f = random.m_188501_();
        if (f < 0.25f) {
            return new ItemStack((ItemLike)ACItemRegistry.GINGERBREAD_BOOTS.get());
        }
        if (f < 0.5f) {
            return new ItemStack((ItemLike)ACItemRegistry.GINGERBREAD_LEGGINGS.get());
        }
        if (f < 0.75f) {
            return new ItemStack((ItemLike)ACItemRegistry.GINGERBREAD_CHESTPLATE.get());
        }
        return new ItemStack((ItemLike)ACItemRegistry.GINGERBREAD_HELMET.get());
    }

    public boolean hasLineOfSightBarrel() {
        BlockHitResult raytraceresult = this.mob.m_9236_().m_45547_(new ClipContext(this.mob.m_20299_(1.0f), new Vec3((double)this.barrelPos.m_123341_() + 0.5, (double)this.barrelPos.m_123342_() + 0.5, (double)this.barrelPos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob));
        if (raytraceresult instanceof BlockHitResult) {
            BlockHitResult blockRayTraceResult = raytraceresult;
            BlockPos pos = blockRayTraceResult.m_82425_();
            return pos.equals((Object)this.barrelPos) || this.mob.m_9236_().m_46859_(pos) || this.mob.m_9236_().m_7702_(pos) == this.mob.m_9236_().m_7702_(this.barrelPos);
        }
        return true;
    }
}

