/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.level.storage.ACWorldData;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class AmberMonolithBlockEntity
extends BlockEntity {
    public int tickCount;
    private int spawnsMobIn = 0;
    private int findSpawnsCooldown = 0;
    private EntityType spawnType;
    private int spawnCount;
    private Entity displayEntity;
    private Entity prevDisplayEntity;
    private float switchProgress;
    private float previousRotation;
    private float rotation = (float)(Math.random() * 360.0);
    private boolean hasDonePostBossSpawn;

    public AmberMonolithBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.AMBER_MONOLITH.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AmberMonolithBlockEntity entity) {
        ++entity.tickCount;
        entity.previousRotation = entity.rotation;
        entity.rotation += 1.0f;
        if (entity.spawnsMobIn <= 1000) {
            float f = (1000.0f - (float)entity.spawnsMobIn) / 1000.0f;
            entity.rotation += f * 20.0f;
        }
        if (entity.prevDisplayEntity != entity.displayEntity) {
            if (entity.displayEntity == null) {
                if (entity.switchProgress > 0.0f) {
                    entity.switchProgress -= 1.0f;
                } else {
                    entity.prevDisplayEntity = null;
                }
            } else if (entity.switchProgress < 10.0f) {
                entity.switchProgress += 1.0f;
            } else {
                entity.prevDisplayEntity = entity.displayEntity;
            }
        }
        if (!level.f_46443_) {
            if (entity.spawnType == null && entity.findSpawnsCooldown-- <= 0 || !entity.hasDonePostBossSpawn && entity.isMigration()) {
                entity.findSpawnsCooldown = 40 + level.f_46441_.m_188503_(50);
                entity.generateSpawnData();
                if (!entity.hasDonePostBossSpawn && entity.isMigration()) {
                    entity.hasDonePostBossSpawn = true;
                    entity.spawnsMobIn = (int)Math.ceil((float)entity.spawnsMobIn * 0.25f) + 100;
                }
            }
            if (entity.spawnsMobIn <= 0) {
                if (entity.spawnType == null) {
                    entity.generateSpawnData();
                } else if (level.m_45924_((double)((float)entity.m_58899_().m_123341_() + 0.5f), (double)((float)entity.m_58899_().m_123342_() + 0.5f), (double)((float)entity.m_58899_().m_123343_() + 0.5f), 28.0, false) != null && entity.spawnMobs()) {
                    level.m_247517_((Player)null, blockPos, (SoundEvent)ACSoundRegistry.AMBER_MONOLITH_SUMMON.get(), SoundSource.BLOCKS);
                    entity.generateSpawnData();
                }
            }
        }
        if (entity.spawnsMobIn > 0) {
            --entity.spawnsMobIn;
        }
    }

    private boolean spawnMobs() {
        SpawnGroupData spawngroupdata = null;
        boolean spawned = false;
        for (int l1 = 0; l1 < this.spawnCount; ++l1) {
            boolean flag = false;
            for (int i2 = 0; !flag && i2 < 6; ++i2) {
                int i;
                Mob mob;
                Entity entity;
                BlockPos blockpos = this.getRandomSpawnPos();
                if (blockpos == null || !this.spawnType.m_20654_() || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_((EntityType)this.spawnType), (LevelReader)this.f_58857_, (BlockPos)blockpos, (EntityType)this.spawnType)) continue;
                double d0 = (float)blockpos.m_123341_() + 0.5f;
                double d1 = (float)blockpos.m_123343_() + 0.5f;
                if (!this.f_58857_.m_45772_(this.spawnType.m_20585_(d0, (double)blockpos.m_123342_(), d1)) || !SpawnPlacements.m_217074_((EntityType)this.spawnType, (ServerLevelAccessor)((ServerLevelAccessor)this.f_58857_), (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)BlockPos.m_274561_((double)d0, (double)blockpos.m_123342_(), (double)d1), (RandomSource)this.f_58857_.m_213780_())) continue;
                try {
                    entity = this.spawnType.m_20615_(this.f_58857_);
                }
                catch (Exception exception) {
                    AlexsCaves.LOGGER.warn("Failed to create mob", (Throwable)exception);
                    continue;
                }
                if (entity == null) continue;
                entity.m_7678_(d0, (double)blockpos.m_123342_(), d1, this.f_58857_.f_46441_.m_188501_() * 360.0f, 0.0f);
                if (!(entity instanceof Mob) || !ForgeEventFactory.checkSpawnPosition((Mob)(mob = (Mob)entity), (ServerLevelAccessor)((ServerLevelAccessor)this.f_58857_), (MobSpawnType)MobSpawnType.CHUNK_GENERATION)) continue;
                spawngroupdata = mob.m_6518_((ServerLevelAccessor)this.f_58857_, this.f_58857_.m_6436_(mob.m_20183_()), MobSpawnType.CHUNK_GENERATION, spawngroupdata, (CompoundTag)null);
                ((ServerLevel)this.f_58857_).m_47205_((Entity)mob);
                spawned = true;
                flag = true;
                Vec3 center = this.m_58899_().m_252807_();
                Vec3 target = entity.m_146892_();
                Vec3 distance = target.m_82546_(center);
                int maxDist = (int)(distance.m_82553_() * 1.5);
                for (i = 0; i < maxDist; ++i) {
                    Vec3 vec3 = center.m_82549_(distance.m_82541_().m_82490_(distance.m_82553_() * (double)((float)i / (float)maxDist))).m_82520_((double)(this.f_58857_.f_46441_.m_188501_() - 0.5f), (double)(this.f_58857_.f_46441_.m_188501_() - 0.5f), (double)(this.f_58857_.f_46441_.m_188501_() - 0.5f));
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)((SimpleParticleType)ACParticleRegistry.AMBER_MONOLITH.get()), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0, target.f_82479_, target.f_82480_, target.f_82481_, 1.0);
                }
                for (i = 0; i < 5; ++i) {
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)((SimpleParticleType)ACParticleRegistry.AMBER_EXPLOSION.get()), entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 0, 0.0, 0.0, 0.0, 1.0);
                }
            }
        }
        return spawned;
    }

    private BlockPos getRandomSpawnPos() {
        boolean caveCreature = this.spawnType.m_20674_() == ACEntityRegistry.CAVE_CREATURE;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 20; ++i) {
            mutableBlockPos.m_122178_(this.m_58899_().m_123341_() + this.f_58857_.m_213780_().m_188503_(20) - 10, this.m_58899_().m_123342_() + 1, this.m_58899_().m_123343_() + this.f_58857_.m_213780_().m_188503_(20) - 10);
            if (!this.f_58857_.m_46749_((BlockPos)mutableBlockPos)) continue;
            while ((this.f_58857_.m_8055_((BlockPos)mutableBlockPos).m_60795_() || this.f_58857_.m_8055_((BlockPos)mutableBlockPos).m_247087_()) && mutableBlockPos.m_123342_() > this.f_58857_.m_141937_()) {
                mutableBlockPos.m_122184_(0, -1, 0);
            }
            if (Math.abs(mutableBlockPos.m_123342_() - this.m_58899_().m_123342_()) >= 20) continue;
            BlockPos pos = mutableBlockPos.m_7949_();
            if (caveCreature && this.f_58857_.m_45527_(pos.m_7494_())) continue;
            return pos.m_7494_();
        }
        return null;
    }

    private void generateSpawnData() {
        MobSpawnSettings.SpawnerData spawnerData;
        ArrayList forcedEntityList = new ArrayList();
        if (this.isMigration() && !this.hasDonePostBossSpawn) {
            forcedEntityList.add((EntityType)ACEntityRegistry.ATLATITAN.get());
        }
        if ((spawnerData = AmberMonolithBlockEntity.getDepopulatedEntitySpawnData(this.f_58857_, this.m_58899_(), 4 + this.f_58857_.f_46441_.m_188503_(8), 64, forcedEntityList)) != null) {
            this.spawnType = spawnerData.f_48404_;
            int j = Math.max(spawnerData.f_48406_ - spawnerData.f_48405_, 0);
            this.spawnCount = j <= 0 ? spawnerData.f_48405_ : this.f_58857_.f_46441_.m_188503_(j) + spawnerData.f_48405_;
        }
        int i = Math.max(1000, (Integer)AlexsCaves.COMMON_CONFIG.amberMonolithMeanTime.get());
        this.spawnsMobIn = i / 2 + this.f_58857_.m_213780_().m_188503_(i);
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    private static boolean isEntitySpawnBlocked(MobSpawnSettings.SpawnerData settings, Level level, BlockPos pos, int range) {
        ACWorldData worldData;
        if (settings.f_48404_.m_204039_(ACTagRegistry.AMBER_MONOLITH_SKIPS)) {
            return true;
        }
        if (settings.f_48404_ == ACEntityRegistry.ATLATITAN.get() && (worldData = ACWorldData.get(level)) != null && !worldData.isPrimordialBossDefeatedOnce()) {
            return true;
        }
        return !level.m_142425_((EntityTypeTest)settings.f_48404_, new AABB(pos).m_82400_((double)range), Entity::m_6084_).isEmpty();
    }

    private static MobSpawnSettings.SpawnerData getEntitySpawnSettingsForBiome(Level level, BlockPos pos, List<EntityType<?>> forcedEntityTypes) {
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        if (biome != null) {
            WeightedRandomList spawnList = biome.m_47518_().m_151798_(ACEntityRegistry.CAVE_CREATURE);
            if (spawnList.m_146337_()) {
                spawnList = biome.m_47518_().m_151798_(MobCategory.CREATURE);
            }
            if (!forcedEntityTypes.isEmpty()) {
                ArrayList<MobSpawnSettings.SpawnerData> matching = new ArrayList<MobSpawnSettings.SpawnerData>();
                for (MobSpawnSettings.SpawnerData unwrapped : spawnList.m_146338_()) {
                    if (!forcedEntityTypes.contains(unwrapped.f_48404_)) continue;
                    matching.add(unwrapped);
                }
                if (!matching.isEmpty()) {
                    spawnList = WeightedRandomList.m_146328_(matching);
                }
            }
            if (!spawnList.m_146337_()) {
                return (MobSpawnSettings.SpawnerData)spawnList.m_216829_(level.f_46441_).get();
            }
        }
        return null;
    }

    private static MobSpawnSettings.SpawnerData getDepopulatedEntitySpawnData(Level level, BlockPos pos, int rolls, int range, List<EntityType<?>> forcedEntityTypes) {
        MobSpawnSettings.SpawnerData spawnerData = null;
        for (int roll = 0; roll < rolls; ++roll) {
            if (spawnerData != null && !AmberMonolithBlockEntity.isEntitySpawnBlocked(spawnerData, level, pos, range)) {
                return spawnerData;
            }
            spawnerData = AmberMonolithBlockEntity.getEntitySpawnSettingsForBiome(level, pos, forcedEntityTypes);
        }
        return spawnerData;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            if (packet.m_131708_().m_128441_("EntityType")) {
                String str = packet.m_131708_().m_128461_("EntityType");
                this.spawnType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(str));
            }
            this.spawnCount = packet.m_131708_().m_128451_("SpawnCount");
            this.spawnsMobIn = packet.m_131708_().m_128451_("SpawnMobsIn");
            this.hasDonePostBossSpawn = packet.m_131708_().m_128471_("PostBossSpawn");
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("EntityType")) {
            String str = tag.m_128461_("EntityType");
            this.spawnType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(str));
        }
        this.spawnCount = tag.m_128451_("SpawnCount");
        this.spawnsMobIn = tag.m_128451_("SpawnMobsIn");
        this.hasDonePostBossSpawn = tag.m_128471_("PostBossSpawn");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.spawnType != null) {
            tag.m_128359_("EntityType", ForgeRegistries.ENTITY_TYPES.getKey((Object)this.spawnType).toString());
        }
        tag.m_128405_("SpawnCount", this.spawnCount);
        tag.m_128405_("SpawnMobsIn", this.spawnsMobIn);
        tag.m_128379_("PostBossSpawn", this.hasDonePostBossSpawn);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public int getSpawnsMobIn() {
        return this.spawnsMobIn;
    }

    public Entity getDisplayEntity(Level level) {
        if (this.displayEntity == null && this.spawnType != null || this.displayEntity != null && this.displayEntity.m_6095_() != this.spawnType) {
            this.displayEntity = this.spawnType.m_20615_(level);
        }
        return this.displayEntity;
    }

    public Entity getPrevDisplayEntity() {
        return this.prevDisplayEntity;
    }

    public float getRotation(float partialTicks) {
        return this.previousRotation + (this.rotation - this.previousRotation) * partialTicks;
    }

    private boolean isMigration() {
        ACWorldData worldData = ACWorldData.get(this.f_58857_);
        if (worldData != null) {
            return worldData.isPrimordialBossDefeatedOnce() && worldData.getFirstPrimordialBossDefeatTimestamp() != -1L && worldData.getFirstPrimordialBossDefeatTimestamp() + 24000L > this.f_58857_.m_46467_();
        }
        return false;
    }
}

