/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.model.SplashModel;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class BigSplashParticle
extends Particle {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/particle/splash.png");
    private static final ResourceLocation TEXTURE_OVERLAY = new ResourceLocation("alexscaves:textures/particle/splash_overlay.png");
    private static final SplashModel MODEL = new SplashModel();
    private float scale;
    private final int waterColor;

    protected BigSplashParticle(ClientLevel level, double x, double y, double z, float scale, int lifetime) {
        super(level, x, y, z);
        this.f_107226_ = 0.0f;
        this.f_107225_ = lifetime;
        this.scale = scale;
        this.waterColor = BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z));
        this.m_107250_(3.0f, 3.0f);
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5989_() {
        super.m_5989_();
        int k = this.f_107225_ - this.f_107224_;
        if (k < 5) {
            float f = (float)k / 5.0f;
            this.m_107271_(f);
        } else {
            int j = 0;
            while ((float)j < this.scale * 2.0f + 1.0f) {
                Vec3 sputterFrom = new Vec3((double)((this.f_107208_.f_46441_.m_188501_() - 0.5f) * 0.1f * this.scale), -0.25, (double)((this.f_107208_.f_46441_.m_188501_() - 0.5f) * 0.1f * this.scale)).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_);
                this.f_107208_.m_7106_((ParticleOptions)ACParticleRegistry.BIG_SPLASH_EFFECT.get(), sputterFrom.f_82479_, sputterFrom.f_82480_, sputterFrom.f_82481_, (double)((this.f_107208_.f_46441_.m_188501_() - 0.5f) * 0.2f), (double)(0.3f + this.f_107208_.f_46441_.m_188501_() * 0.2f), (double)((this.f_107208_.f_46441_.m_188501_() - 0.5f) * 0.2f));
                ++j;
            }
        }
    }

    public void m_107274_() {
        super.m_107274_();
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        int packedLight = this.m_6355_(partialTick);
        float colorR = (float)(this.waterColor >> 16 & 0xFF) / 255.0f;
        float colorG = (float)(this.waterColor >> 8 & 0xFF) / 255.0f;
        float colorB = (float)(this.waterColor & 0xFF) / 255.0f;
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_252880_(f, f1 - 0.5f, f2);
        posestack.m_85841_(-this.scale, -this.scale, this.scale);
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        MODEL.m_6973_(null, 0.0f, this.f_107225_, (float)this.f_107224_ + partialTick, 0.0f, 0.0f);
        VertexConsumer baseConsumer = multibuffersource$buffersource.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE));
        MODEL.m_7695_(posestack, baseConsumer, packedLight, OverlayTexture.f_118083_, colorR, colorG, colorB, this.f_107230_);
        VertexConsumer overlayconsumer = multibuffersource$buffersource.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE_OVERLAY));
        MODEL.m_7695_(posestack, overlayconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, this.f_107230_);
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (xSpeed == 0.0) {
                xSpeed = 1.0;
            }
            int lifetime = 5 + (int)Math.round(ySpeed * 5.0);
            return new BigSplashParticle(worldIn, x, y, z, (float)Math.max(0.5, xSpeed), lifetime);
        }
    }
}

