/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.effects.VampirismNightVisionPotion;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.FactionBasePlayer;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.werewolves.api.WReference;
import de.teamlapen.werewolves.api.entities.player.IWerewolfPlayer;
import de.teamlapen.werewolves.api.entities.werewolf.WerewolfForm;
import de.teamlapen.werewolves.api.items.IWerewolfArmor;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSkills;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.effects.WolfsbaneEffect;
import de.teamlapen.werewolves.effects.inst.WerewolfNightVisionEffectInstance;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.player.werewolf.LevelHandler;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfInventory;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayerSpecialAttributes;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.mixin.ArmorItemAccessor;
import de.teamlapen.werewolves.mixin.FoodStatsAccessor;
import de.teamlapen.werewolves.mixin.entity.PlayerAccessor;
import de.teamlapen.werewolves.util.DamageHandler;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.NBTHelper;
import de.teamlapen.werewolves.util.Permissions;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WUtils;
import de.teamlapen.werewolves.world.WerewolvesWorld;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WerewolfPlayer
extends FactionBasePlayer<IWerewolfPlayer>
implements IWerewolfPlayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final UUID ARMOR_TOUGHNESS = UUID.fromString("f3979aec-b8ef-4e95-84a7-2c6dab8ea46e");
    private static final UUID CLAWS = UUID.fromString("70435284-afcd-4470-85c2-d9b36b3d94e8");
    public static final Capability<IWerewolfPlayer> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IWerewolfPlayer>(){});
    @Nonnull
    private final ActionHandler<IWerewolfPlayer> actionHandler;
    @Nonnull
    private final SkillHandler<IWerewolfPlayer> skillHandler;
    @Nonnull
    private final WerewolfPlayerSpecialAttributes specialAttributes = new WerewolfPlayerSpecialAttributes();
    @Nonnull
    private WerewolfForm form = WerewolfForm.NONE;
    @Nullable
    private WerewolfFormAction lastFormAction;
    @Nonnull
    private final LevelHandler levelHandler = new LevelHandler(this);
    private final Map<WerewolfForm, Integer> eyeType = new HashMap<WerewolfForm, Integer>();
    private final Map<WerewolfForm, Integer> skinType = new HashMap<WerewolfForm, Integer>();
    private final Map<WerewolfForm, Boolean> glowingEyes = new HashMap<WerewolfForm, Boolean>();
    private final WerewolfInventory inventory = new WerewolfInventory(this);
    private int sleepTimer;
    private int wolfsbaneCache = -1;

    public static WerewolfPlayer get(@Nonnull Player playerEntity) {
        return (WerewolfPlayer)playerEntity.getCapability(CAP).orElseThrow(() -> new IllegalStateException("Cannot get werewolf player capability from player" + String.valueOf(playerEntity)));
    }

    public static LazyOptional<WerewolfPlayer> getOpt(@Nonnull Player playerEntity) {
        LazyOptional opt = playerEntity.getCapability(CAP).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Werewolf player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static LazyOptional<WerewolfPlayer> getOptSave(Player player) {
        if (player == null || !player.m_6084_()) {
            return LazyOptional.empty();
        }
        return WerewolfPlayer.getOpt(player);
    }

    public static LazyOptional<WerewolfPlayer> getOptEx(@Nullable Entity entity) {
        if (!(entity instanceof Player) || !Helper.isWerewolf((Player)entity)) {
            return LazyOptional.empty();
        }
        return WerewolfPlayer.getOpt((Player)entity);
    }

    public WerewolfPlayer(@Nonnull Player player) {
        super(player);
        this.actionHandler = new ActionHandler((IFactionPlayer)this);
        this.skillHandler = new SkillHandler((IFactionPlayer)this, WReference.WEREWOLF_FACTION);
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    public void setForm(WerewolfFormAction action, WerewolfForm form) {
        this.switchForm(form);
        this.lastFormAction = action;
        if (!this.player.m_9236_().f_46443_) {
            this.sync(NBTHelper.nbtWith(nbt -> nbt.m_128359_("form", this.form.getName())), true);
        }
    }

    public WerewolfInventory getInventory() {
        return this.inventory;
    }

    public void switchForm(WerewolfForm form) {
        if (this.form == form) {
            return;
        }
        this.form = form;
        this.player.m_6210_();
        if (!this.form.isHumanLike()) {
            ((PlayerAccessor)this.player).invoke_removeEntitiesOnShoulder();
        }
        if (!this.player.m_9236_().f_46443_) {
            this.inventory.swapArmorItems(form);
        }
        this.checkToolDamage(this.player.m_21205_(), this.player.m_21205_(), true);
    }

    @Override
    public boolean canWearArmor(ItemStack stack) {
        return this.canWearArmor(this.form, stack);
    }

    public boolean canWearArmor(List<ItemStack> stacks) {
        return stacks.stream().allMatch(this::canWearArmor);
    }

    public boolean canWearArmor(WerewolfForm form, List<ItemStack> stack) {
        return stack.stream().allMatch(s -> this.canWearArmor(form, (ItemStack)s));
    }

    public boolean canWearArmor(WerewolfForm form, ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        Item item = stack.m_41720_();
        if (item instanceof IWerewolfArmor) {
            IWerewolfArmor armor = (IWerewolfArmor)item;
            return armor.canWear(this, form);
        }
        return form.isHumanLike() && (!form.isTransformed() || this.getSkillHandler().isSkillEnabled((ISkill)ModSkills.WEAR_ARMOR.get()));
    }

    protected FactionBasePlayer<IWerewolfPlayer> copyFromPlayer(Player playerEntity) {
        WerewolfPlayer oldWerewolf = WerewolfPlayer.get(playerEntity);
        CompoundTag nbt = new CompoundTag();
        oldWerewolf.saveData(nbt);
        this.loadData(nbt);
        return oldWerewolf;
    }

    public void removeArmorModifier() {
        for (UUID uuid : ArmorItemAccessor.getARMOR_MODIFIERS().values()) {
            this.player.m_21051_(Attributes.f_22285_).m_22120_(uuid);
            this.player.m_21051_(Attributes.f_22284_).m_22120_(uuid);
        }
    }

    public void addArmorModifier() {
        HashSet uuids = Sets.newHashSet(ArmorItemAccessor.getARMOR_MODIFIERS().values());
        int i = 0;
        for (ItemStack stack : this.player.m_6168_()) {
            EquipmentSlot slotType = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i++);
            Multimap map = stack.m_41638_(slotType);
            for (Map.Entry entry : map.asMap().entrySet()) {
                for (AttributeModifier modifier : (Collection)entry.getValue()) {
                    AttributeInstance attribute;
                    if (!uuids.contains(modifier.m_22209_()) || (attribute = this.player.m_21051_((Attribute)entry.getKey())).m_22109_(modifier)) continue;
                    attribute.m_22125_(modifier);
                }
            }
        }
    }

    public void onChangedDimension(ResourceKey<Level> registryKey, ResourceKey<Level> registryKey1) {
    }

    @Nonnull
    public WerewolfPlayerSpecialAttributes getSpecialAttributes() {
        return this.specialAttributes;
    }

    public void onUpdate() {
        this.player.m_20193_().m_46473_().m_6180_("werewolves_werewolfplayer");
        super.onUpdate();
        if (this.getLevel() > 0) {
            if (!this.isRemote()) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundTag syncPacket = new CompoundTag();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    syncToAll = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (this.player.m_9236_().m_46467_() % 10L == 0L) {
                    if (this.specialAttributes.transformationTime > 0.0 && !FormHelper.isFormActionActive(this)) {
                        this.specialAttributes.transformationTime = Mth.m_14008_((double)(this.specialAttributes.transformationTime - this.player.m_21051_((Attribute)ModAttributes.TIME_REGAIN.get()).m_22135_()), (double)0.0, (double)1.0);
                        syncPacket.m_128347_("transformationTime", this.specialAttributes.transformationTime);
                    }
                    if (this.player.m_9236_().m_46467_() % 20L == 0L) {
                        if (Helper.isFullMoon(this.getRepresentingPlayer().m_20193_()) && !FormHelper.isFormActionActive(this) && !this.skillHandler.isSkillEnabled((ISkill)ModSkills.FREE_WILL.get())) {
                            Optional<WerewolfFormAction> action = this.lastFormAction != null ? Optional.of(this.lastFormAction) : WerewolfFormAction.getAllAction().stream().filter(arg_0 -> this.actionHandler.isActionUnlocked(arg_0)).findAny();
                            action.ifPresent(a -> this.actionHandler.toggleAction(a, (IAction.ActivationContext)new ActionHandler.ActivationContext()));
                        }
                        if (this.player.m_20069_() && this.player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !this.skillHandler.isSkillEnabled((ISkill)ModSkills.WATER_LOVER.get())) {
                            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 50, 0, true, true));
                        }
                    }
                }
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.HEALTH_REG.get())) {
                    this.tickFoodStats();
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
                MobEffectInstance effect = this.player.m_21124_(MobEffects.f_19611_);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision) {
                    if (effect == null || !VampirismNightVisionPotion.ID.equals((Object)((EffectInstanceWithSource)effect).getSource())) {
                        if (effect != null) {
                            this.player.m_6234_(effect.m_19544_());
                        }
                        this.player.m_7292_((MobEffectInstance)new WerewolfNightVisionEffectInstance(effect));
                    }
                } else if (effect != null && VampirismNightVisionPotion.ID.equals((Object)((EffectInstanceWithSource)effect).getSource())) {
                    this.player.m_21195_(effect.m_19544_());
                    effect = ((EffectInstanceWithSource)effect).getHiddenEffect();
                    if (effect != null) {
                        this.player.m_7292_(effect);
                    }
                }
                if (this.player.f_19797_ % 40 == 0 && this.isAffectedByWolfsbane((LevelAccessor)this.player.m_9236_(), true)) {
                    this.player.m_7292_(WolfsbaneEffect.createWolfsbaneEffect((LivingEntity)this.player, 50, this.wolfsbaneCache));
                }
            } else {
                this.actionHandler.updateActions();
                if (this.player.m_9236_().m_46467_() % 10L == 0L && this.specialAttributes.transformationTime > 0.0 && !FormHelper.isFormActionActive(this)) {
                    this.specialAttributes.transformationTime = Mth.m_14008_((double)(this.specialAttributes.transformationTime - (double)((float)this.player.m_21051_((Attribute)ModAttributes.TIME_REGAIN.get()).m_22135_())), (double)0.0, (double)1.0);
                }
                MobEffectInstance effect = this.player.m_21124_(MobEffects.f_19611_);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision && !(effect instanceof WerewolfNightVisionEffectInstance)) {
                    this.player.m_6234_(MobEffects.f_19611_);
                    this.player.m_7292_((MobEffectInstance)new WerewolfNightVisionEffectInstance());
                }
            }
            this.specialAttributes.biteTicks = Math.max(0, this.specialAttributes.biteTicks - 1);
        } else if (!this.isRemote() && this.player.m_5803_() && this.player.m_21023_((MobEffect)ModEffects.LUPUS_SANGUINEM.get())) {
            if (this.sleepTimer++ >= 200) {
                this.player.m_21124_((MobEffect)ModEffects.LUPUS_SANGUINEM.get()).m_19550_((LivingEntity)this.player);
                this.player.m_21195_((MobEffect)ModEffects.LUPUS_SANGUINEM.get());
                this.player.m_5796_();
            }
        } else {
            this.sleepTimer = 0;
        }
        this.player.m_20193_().m_46473_().m_7238_();
    }

    private void tickFoodStats() {
        FoodData stats = this.player.m_36324_();
        ((FoodStatsAccessor)stats).setTickTimer(((FoodStatsAccessor)stats).getTickTimer() + 1);
    }

    public boolean setGlowingEyes(WerewolfForm form, boolean on) {
        if (on != this.glowingEyes.getOrDefault(form, false)) {
            this.glowingEyes.put(form, on);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag glowingEyes = new CompoundTag();
                this.glowingEyes.forEach((key, value) -> glowingEyes.m_128379_(key.getName(), value.booleanValue()));
                nbt.m_128365_("glowingEyes", (Tag)glowingEyes);
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setEyeType(WerewolfForm form, int type) {
        if (type != this.eyeType.getOrDefault(form, -1)) {
            this.eyeType.put(form, type);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag eye = new CompoundTag();
                this.eyeType.forEach((key, value) -> eye.m_128405_(key.getName(), value.intValue()));
                nbt.m_128365_("eyeTypes", (Tag)eye);
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setSkinType(WerewolfForm form, int type) {
        if (type != this.skinType.getOrDefault(form, -1)) {
            this.skinType.put(form, type);
            if (!this.isRemote()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag skin = new CompoundTag();
                this.skinType.forEach((key, value) -> skin.m_128405_(key.getName(), value.intValue()));
                nbt.m_128365_("skinTypes", (Tag)skin);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void setSkinData(WerewolfForm form, int[] data) {
        this.setEyeType(form, data[0]);
        this.setSkinType(form, data[1]);
        this.setGlowingEyes(form, data[2] == 1);
    }

    public void onDeath(DamageSource damageSource) {
        super.onDeath(damageSource);
        this.actionHandler.deactivateAllActions();
    }

    @Nonnull
    public LevelHandler getLevelHandler() {
        return this.levelHandler;
    }

    public boolean onEntityAttacked(DamageSource damageSource, float v) {
        return false;
    }

    public void onEntityKilled(LivingEntity victim, DamageSource src) {
        if (this.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.RAGE_FURY.get())) {
            this.player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 40, 1));
            this.actionHandler.extendActionTimer((ILastingAction)ModActions.RAGE.get(), ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.rage_fury_timer_extend.get()).intValue());
        }
        this.levelHandler.increaseProgress((int)((double)victim.m_21233_() * 0.2));
        this.syncLevelHandler();
    }

    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    public void syncLevelHandler() {
        CompoundTag sync = new CompoundTag();
        this.levelHandler.saveToNbt(sync);
        this.sync(sync, false);
    }

    public void onPlayerLoggedIn() {
    }

    public void onPlayerLoggedOut() {
    }

    public void onUpdatePlayer(TickEvent.Phase phase) {
    }

    public boolean canBiteEntity(LivingEntity entity) {
        return (double)entity.m_20270_((Entity)this.player) <= this.player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() + 1.0 && (!(entity instanceof ServerPlayer) || (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.BITE_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false);
    }

    public boolean canBite() {
        return this.form.isTransformed() && !this.player.m_5833_() && this.getLevel() > 0 && this.specialAttributes.biteTicks <= 0 && (!(this.player instanceof ServerPlayer) || (Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.BITE, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false);
    }

    public boolean bite(int entityId) {
        Entity entity = this.player.m_9236_().m_6815_(entityId);
        if (entity instanceof LivingEntity) {
            return this.bite((LivingEntity)entity);
        }
        return false;
    }

    private boolean bite(LivingEntity entity) {
        if (this.specialAttributes.biteTicks > 0) {
            return false;
        }
        if (!this.form.isTransformed()) {
            return false;
        }
        if (!this.canBite()) {
            return false;
        }
        if (!this.canBiteEntity(entity)) {
            return false;
        }
        double damage = this.player.m_21051_((Attribute)ModAttributes.BITE_DAMAGE.get()).m_22135_();
        boolean flag = DamageHandler.hurtModded((Entity)entity, sources -> sources.bite((LivingEntity)this.player), (float)damage);
        if (flag) {
            this.getRepresentingPlayer().m_5496_((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), 1.0f, 1.0f);
            this.getRepresentingPlayer().m_6330_((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.eatEntity(entity);
            this.specialAttributes.biteTicks = (Integer)WerewolvesConfig.BALANCE.PLAYER.bite_cooldown.get();
            if (!this.getForm().isHumanLike()) {
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.STUN_BITE.get())) {
                    int duration = (Integer)WerewolvesConfig.BALANCE.SKILLS.stun_bite_duration.get();
                    if (this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.STUN_BITE.get())) {
                        duration += ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.stun_bite_duration_extend.get()).intValue();
                    }
                    entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), duration));
                }
                if (this.skillHandler.isSkillEnabled((ISkill)ModSkills.BLEEDING_BITE.get())) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), ((Integer)WerewolvesConfig.BALANCE.SKILLS.bleeding_bite_duration.get()).intValue(), this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.BLEEDING_BITE.get()) ? 3 : 0));
                }
            }
            this.sync(NBTHelper.nbtWith(nbt -> nbt.m_128405_("biteTicks", this.specialAttributes.biteTicks)), false);
            if (!(entity instanceof ServerPlayer) || ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)this.getRepresentingPlayer()), Permissions.INFECT_PLAYER, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue()) {
                LupusSanguinemEffect.infectRandomByPlayer(entity);
            }
        }
        return flag;
    }

    private void eatEntity(LivingEntity entity) {
        if (!Helper.isNoLiving(entity)) {
            return;
        }
        if (!entity.m_6084_()) {
            this.player.m_36324_().m_38707_(1, 1.0f);
        }
    }

    public void onLevelChanged(int newLevel, int oldLevel) {
        super.onLevelChanged(newLevel, oldLevel);
        this.applyEntityAttributes();
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard((Player)this.player, (ObjectiveCriteria)WUtils.WEREWOLF_LEVEL_CRITERIA, (int)newLevel);
            LevelAttributeModifier.applyModifier((Player)this.player, (Attribute)Attributes.f_22279_, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.3, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((Player)this.player, (Attribute)Attributes.f_22285_, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((Player)this.player, (Attribute)Attributes.f_22281_, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_damage.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION, (boolean)false);
            if (newLevel > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill((ISkillType)SkillType.LEVEL);
                }
            } else {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
            }
        } else if (newLevel == 0) {
            this.actionHandler.resetTimers();
        }
    }

    public boolean isAffectedByWolfsbane(LevelAccessor accessor, boolean forceRefresh) {
        if (forceRefresh) {
            int n;
            if (accessor instanceof Level) {
                Level level = (Level)accessor;
                n = WerewolvesWorld.getOpt(level).map(x -> x.isEffectedByWolfsbane(this.getRepresentingPlayer().m_20183_())).orElse(-1);
            } else {
                n = -1;
            }
            this.wolfsbaneCache = n;
        }
        return this.wolfsbaneCache > -1;
    }

    private void eatFleshFrom(LivingEntity entity) {
        this.player.m_36324_().m_38707_(1, 1.0f);
    }

    public ResourceLocation getCapKey() {
        return REFERENCE.WEREWOLF_PLAYER_KEY;
    }

    public boolean canLeaveFaction() {
        return true;
    }

    @Nullable
    public IFaction<?> getDisguisedAs() {
        if (this.getForm().isTransformed()) {
            return WReference.WEREWOLF_FACTION;
        }
        return null;
    }

    public Optional<Tier> getDigDropTier() {
        return Optional.ofNullable(this.specialAttributes.diggerTier);
    }

    public float getDigSpeed() {
        return this.specialAttributes.diggingSpeed;
    }

    public int getMaxLevel() {
        return 14;
    }

    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate((IFaction)this.getFaction(), ignoreDisguise);
    }

    public boolean isDisguised() {
        return !this.getForm().isTransformed();
    }

    @Nullable
    public WerewolfFormAction getLastFormAction() {
        return this.lastFormAction;
    }

    public ISkillHandler<IWerewolfPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    public IActionHandler<IWerewolfPlayer> getActionHandler() {
        return this.actionHandler;
    }

    public void saveData(CompoundTag compound) {
        super.saveData(compound);
        compound.m_128365_("inventory", (Tag)this.inventory.save());
        this.skillHandler.saveToNbt(compound);
        this.actionHandler.saveToNbt(compound);
        this.levelHandler.saveToNbt(compound);
        compound.m_128359_("form", this.form.getName());
        if (this.lastFormAction != null) {
            compound.m_128359_("lastFormAction", RegUtil.id((IAction)this.lastFormAction).toString());
        }
        compound.m_128405_("biteTicks", this.specialAttributes.biteTicks);
        CompoundTag eye = new CompoundTag();
        this.eyeType.forEach((key, value) -> eye.m_128405_(key.getName(), value.intValue()));
        compound.m_128365_("eyeTypes", (Tag)eye);
        CompoundTag skin = new CompoundTag();
        this.skinType.forEach((key, value) -> skin.m_128405_(key.getName(), value.intValue()));
        compound.m_128365_("skinTypes", (Tag)skin);
        CompoundTag glowingEye = new CompoundTag();
        this.glowingEyes.forEach((key, value) -> glowingEye.m_128379_(key.getName(), value.booleanValue()));
        compound.m_128365_("glowingEyes", (Tag)glowingEye);
        compound.m_128347_("transformationTime", this.specialAttributes.transformationTime);
        ListTag armor = new ListTag();
    }

    public void loadData(CompoundTag compound) {
        super.loadData(compound);
        this.inventory.load(compound.m_128469_("inventory"));
        this.skillHandler.loadFromNbt(compound);
        this.actionHandler.loadFromNbt(compound);
        this.levelHandler.loadFromNbt(compound);
        CompoundTag armor = compound.m_128469_("armor");
        for (int i = 0; i < armor.m_128440_(); ++i) {
            try {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)armor.m_128469_("" + i));
                this.player.m_8061_(EquipmentSlot.values()[i], stack);
                continue;
            }
            catch (Exception stack) {
                // empty catch block
            }
        }
        if (NBTHelper.containsString(compound, "lastFormAction")) {
            this.lastFormAction = (WerewolfFormAction)RegUtil.getAction((ResourceLocation)new ResourceLocation(compound.m_128461_("lastFormAction")));
        }
        this.specialAttributes.biteTicks = compound.m_128451_("biteTicks");
        CompoundTag eye = compound.m_128469_("eyeTypes");
        eye.m_128431_().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.m_128451_(string)));
        CompoundTag skin = compound.m_128469_("skinTypes");
        skin.m_128431_().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.m_128451_(string)));
        CompoundTag glowingEyes = compound.m_128469_("glowingEyes");
        glowingEyes.m_128431_().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.m_128471_(string)));
        if (compound.m_128441_("transformationTime")) {
            this.specialAttributes.transformationTime = compound.m_128457_("transformationTime");
        }
    }

    protected void writeFullUpdate(CompoundTag nbt) {
        super.writeFullUpdate(nbt);
        nbt.m_128365_("inventory", (Tag)this.inventory.save());
        this.skillHandler.writeUpdateForClient(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.levelHandler.saveToNbt(nbt);
        nbt.m_128359_("form", this.form.getName());
        nbt.m_128405_("biteTicks", this.specialAttributes.biteTicks);
        CompoundTag eye = new CompoundTag();
        this.eyeType.forEach((key, value) -> eye.m_128405_(key.getName(), value.intValue()));
        nbt.m_128365_("eyeTypes", (Tag)eye);
        CompoundTag skin = new CompoundTag();
        this.skinType.forEach((key, value) -> skin.m_128405_(key.getName(), value.intValue()));
        nbt.m_128365_("skinTypes", (Tag)skin);
        CompoundTag glowingEye = new CompoundTag();
        this.glowingEyes.forEach((key, value) -> glowingEye.m_128379_(key.getName(), value.booleanValue()));
        nbt.m_128365_("glowingEyes", (Tag)glowingEye);
        nbt.m_128347_("transformationTime", this.specialAttributes.transformationTime);
    }

    protected void loadUpdate(CompoundTag nbt) {
        super.loadUpdate(nbt);
        this.inventory.load(nbt.m_128469_("inventory"));
        this.skillHandler.readUpdateFromServer(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.levelHandler.loadFromNbt(nbt);
        if (NBTHelper.containsString(nbt, "form")) {
            this.switchForm(this.form);
        }
        if (nbt.m_128441_("biteTicks")) {
            this.specialAttributes.biteTicks = nbt.m_128451_("biteTicks");
        }
        if (nbt.m_128441_("eyeTypes")) {
            CompoundTag eye = nbt.m_128469_("eyeTypes");
            eye.m_128431_().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.m_128451_(string)));
        }
        if (nbt.m_128441_("skinTypes")) {
            CompoundTag skin = nbt.m_128469_("skinTypes");
            skin.m_128431_().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.m_128451_(string)));
        }
        if (nbt.m_128441_("glowingEyes")) {
            CompoundTag glowingEyes = nbt.m_128469_("glowingEyes");
            glowingEyes.m_128431_().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.m_128471_(string)));
        }
        if (nbt.m_128441_("transformationTime")) {
            this.specialAttributes.transformationTime = nbt.m_128457_("transformationTime");
        }
    }

    private void applyEntityAttributes() {
        try {
            this.player.m_21051_((Attribute)ModAttributes.BITE_DAMAGE.get());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public static ICapabilityProvider createNewCapability(final Player player) {
        return new ICapabilitySerializable<CompoundTag>(){
            final WerewolfPlayer inst;
            final LazyOptional<IWerewolfPlayer> opt;
            {
                this.inst = new WerewolfPlayer(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CAP.orEmpty(cap, this.opt);
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveData(tag);
                return tag;
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.inst.loadData(nbt);
            }
        };
    }

    public void checkToolDamage(@NotNull ItemStack from, @NotNull ItemStack itemInHand, boolean forceCalculation) {
        AttributeInstance attribute = this.player.m_21051_(Attributes.f_22281_);
        if (this.getLevel() > 0 && this.form.isTransformed() && itemInHand.m_41619_()) {
            if (!from.m_41619_() || forceCalculation) {
                float damage = ((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_claw_damage.get()).floatValue();
                if (this.specialAttributes.diggerTier != null) {
                    damage += (1.0f + this.specialAttributes.diggerTier.m_6631_()) / 2.0f;
                }
                attribute.m_22120_(CLAWS);
                attribute.m_22118_(new AttributeModifier(CLAWS, "werewolf_claws", (double)damage, AttributeModifier.Operation.ADDITION));
            }
        } else {
            attribute.m_22120_(CLAWS);
        }
    }

    public void checkWerewolfFormModifier() {
        WerewolfFormAction.getAllAction().stream().filter(action -> this.getActionHandler().isActionActive((ILastingAction)action)).findAny().ifPresent(action -> action.checkDayNightModifier(this));
    }

    @Override
    public int getEyeType(WerewolfForm form) {
        return this.eyeType.getOrDefault(form, 0);
    }

    @Override
    public int getSkinType(WerewolfForm form) {
        return this.skinType.getOrDefault(form, 0);
    }

    @Override
    public boolean hasGlowingEyes(WerewolfForm form) {
        return this.glowingEyes.getOrDefault(form, false);
    }

    public void dropEquipment() {
        this.inventory.dropEquipment();
    }

    @Override
    public void updateMinionAttributes(boolean increasedStats) {
        MinionWorldData.getData((Level)this.player.m_9236_()).flatMap(a -> FactionPlayerHandler.getOpt((Player)this.player).map(arg_0 -> ((MinionWorldData)a).getOrCreateController(arg_0))).ifPresent(controller -> controller.contactMinions(minion -> {
            minion.getMinionData().ifPresent(b -> ((WerewolfMinionEntity.WerewolfMinionData)((Object)((Object)((Object)b)))).setIncreasedStats(increasedStats));
            HelperLib.sync((Entity)minion);
        }));
    }

    static {
        LevelAttributeModifier.registerModdedAttributeModifier((Attribute)Attributes.f_22285_, (UUID)ARMOR_TOUGHNESS);
    }
}

