/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.sit;

import de.teamlapen.vampirism.sit.SitEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SitUtil {
    private static final Map<ResourceLocation, Map<BlockPos, SitEntity>> OCCUPIED = new HashMap<ResourceLocation, Map<BlockPos, SitEntity>>();

    public static boolean addSitEntity(@NotNull Level level, BlockPos blockPos, SitEntity entity) {
        if (!level.f_46443_) {
            Map<BlockPos, SitEntity> map;
            ResourceLocation id = SitUtil.getDimensionTypeId(level);
            if (!OCCUPIED.containsKey(id)) {
                OCCUPIED.put(id, new HashMap());
            }
            if ((map = OCCUPIED.get(id)).containsKey(blockPos) && map.get(blockPos) != entity) {
                entity.m_146870_();
                return false;
            }
            map.put(blockPos, entity);
            return true;
        }
        return false;
    }

    public static boolean removeSitEntity(@NotNull Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(level)) && OCCUPIED.get(id).containsKey(pos)) {
            OCCUPIED.get(id).remove(pos);
            return true;
        }
        return false;
    }

    @Nullable
    public static SitEntity getSitEntity(@NotNull Level level, BlockPos pos) {
        ResourceLocation id;
        if (!level.f_46443_ && OCCUPIED.containsKey(id = SitUtil.getDimensionTypeId(level)) && OCCUPIED.get(id).containsKey(pos)) {
            return OCCUPIED.get(id).get(pos);
        }
        return null;
    }

    public static boolean isOccupied(@NotNull Level world, BlockPos pos) {
        ResourceLocation id = SitUtil.getDimensionTypeId(world);
        return OCCUPIED.containsKey(id) && OCCUPIED.get(id).containsKey(pos);
    }

    public static boolean isPlayerSitting(@NotNull Player player) {
        for (ResourceLocation i : OCCUPIED.keySet()) {
            for (SitEntity pair : OCCUPIED.get(i).values()) {
                if (!pair.m_20363_((Entity)player)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static ResourceLocation getDimensionTypeId(@NotNull Level level) {
        return level.m_46472_().m_135782_();
    }
}

