/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.mixin;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IVampirismCrossbow;
import de.teamlapen.vampirism.entity.player.IVampirismPlayer;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.util.MixinHooks;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class MixinPlayerEntity
extends LivingEntity
implements IVampirismPlayer {
    private final VampirismPlayerAttributes vampirismPlayerAttributes = new VampirismPlayerAttributes();

    private MixinPlayerEntity(@NotNull EntityType<? extends LivingEntity> type, @NotNull Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public VampirismPlayerAttributes getVampAtts() {
        return this.vampirismPlayerAttributes;
    }

    @ModifyVariable(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="STORE", ordinal=0), ordinal=1)
    public float vampireSlayerEnchantment(float damage, Entity target) {
        return damage + MixinHooks.calculateVampireSlayerEnchantments(target, this.m_21205_());
    }

    @Redirect(method={"getProjectile"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ProjectileWeaponItem;getSupportedHeldProjectiles()Ljava/util/function/Predicate;"))
    private Predicate<ItemStack> getSupportedHeldProjectilesWithItemStack(ProjectileWeaponItem instance, ItemStack stack) {
        if (instance instanceof IVampirismCrossbow) {
            IVampirismCrossbow crossbow = (IVampirismCrossbow)instance;
            return crossbow.getSupportedProjectiles(stack);
        }
        return instance.m_6442_();
    }

    @Redirect(method={"getProjectile"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ProjectileWeaponItem;getAllSupportedProjectiles()Ljava/util/function/Predicate;"))
    private Predicate<ItemStack> getAllSupportedProjectilesWithItemStack(ProjectileWeaponItem instance, ItemStack stack) {
        if (instance instanceof IVampirismCrossbow) {
            IVampirismCrossbow crossbow = (IVampirismCrossbow)instance;
            return crossbow.getSupportedProjectiles(stack);
        }
        return instance.m_6442_();
    }

    @Inject(method={"canTakeItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void canTakeItem(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        IFactionExclusiveItem item;
        IFaction<?> exclusiveFaction;
        Item item2 = stack.m_41720_();
        if (item2 instanceof IFactionExclusiveItem && (exclusiveFaction = (item = (IFactionExclusiveItem)item2).getExclusiveFaction(stack)) != null && exclusiveFaction != this.vampirismPlayerAttributes.faction) {
            cir.setReturnValue((Object)false);
        }
    }
}

