/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.ICaptureIgnore;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.ai.goals.ForceLookEntityGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.inventory.HunterTrainerMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HunterTrainerEntity
extends HunterBaseEntity
implements ForceLookEntityGoal.TaskOwner,
ICaptureIgnore {
    private static final Component name = Component.m_237115_((String)"container.huntertrainer");
    private static final int MOVE_TO_RESTRICT_PRIO = 3;
    @Nullable
    private Player trainee;
    private boolean shouldCreateHome;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return VampirismEntity.getAttributeBuilder().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22281_, 19.0).m_22268_(Attributes.f_22279_, 0.17).m_22268_(Attributes.f_22277_, 5.0);
    }

    public HunterTrainerEntity(EntityType<? extends HunterTrainerEntity> type, Level world) {
        super(type, world, false);
        this.saveHome = true;
        this.hasArms = true;
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.peaceful = true;
        this.setDontDropEquipment();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("createHome", this.shouldCreateHome);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.trainee != null && !(this.trainee.f_36096_ instanceof HunterTrainerMenu)) {
            this.trainee = null;
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    @Override
    @NotNull
    public Optional<Player> getForceLookTarget() {
        return Optional.ofNullable(this.trainee);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("createHome") && (this.shouldCreateHome = nbt.m_128471_("createHome")) && this.m_21534_().equals((Object)BlockPos.f_121853_)) {
            this.m_21446_(this.m_20183_(), 5);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_8061_(EquipmentSlot.HEAD, HunterBaseEntity.HatType.HAT_0.getHeadItem());
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return super.m_6785_(distanceToClosestPlayer) && this.getHome() == null;
    }

    @Override
    public void setHome(AABB box) {
        super.setHome(box);
        this.setMoveTowardsRestriction(3, true);
    }

    public boolean m_6052_() {
        return true;
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        boolean flag;
        if (this.tryCureSanguinare(player)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        boolean bl = flag = !stack.m_41619_() && stack.m_41720_() instanceof SpawnEggItem;
        if (!flag && this.m_6084_() && !player.m_6144_() && hand == InteractionHand.MAIN_HAND) {
            int lvl = VampirismPlayerAttributes.get((Player)player).hunterLevel;
            if (!this.m_9236_().f_46443_ && lvl > 0) {
                if (HunterLeveling.getTrainerRequirement(lvl + 1).isPresent()) {
                    if (this.trainee == null) {
                        player.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerEntity) -> new HunterTrainerMenu(id, playerInventory, this), name));
                        this.trainee = player;
                        this.m_21573_().m_26573_();
                    } else {
                        player.m_213846_((Component)Component.m_237115_((String)"text.vampirism.i_am_busy_right_now"));
                    }
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"text.vampirism.hunter_trainer.trainer_level_wrong"));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, new ForceLookEntityGoal<HunterTrainerEntity>(this));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 13.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, VampireBaseEntity.class, 17.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, false, false, null)));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, PathfinderMob.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
    }
}

