/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.hunter;

import de.teamlapen.vampirism.advancements.critereon.VampireActionCriterionTrigger;
import de.teamlapen.vampirism.api.entity.hunter.IHunterMob;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class HunterBaseEntity
extends VampirismEntity
implements IHunterMob,
Npc {
    protected final int MOVE_TO_RESTRICT_PRIO = 3;
    private final boolean countAsMonster;

    public static boolean spawnPredicateHunter(@NotNull EntityType<? extends HunterBaseEntity> entityType, @NotNull LevelAccessor world, MobSpawnType spawnReason, @NotNull BlockPos blockPos, RandomSource random) {
        return world.m_46791_() != Difficulty.PEACEFUL && Mob.m_217057_(entityType, (LevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)blockPos, (RandomSource)random);
    }

    public HunterBaseEntity(EntityType<? extends HunterBaseEntity> type, Level world, boolean countAsMonster) {
        super(type, world);
        this.countAsMonster = countAsMonster;
    }

    public MobCategory getClassification(boolean forSpawnCount) {
        if (forSpawnCount && this.countAsMonster) {
            return MobCategory.MONSTER;
        }
        return super.getClassification(forSpawnCount);
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        if (cause.m_7639_() instanceof ServerPlayer && Helper.isVampire((Player)cause.m_7639_()) && this.m_21124_((MobEffect)ModEffects.FREEZE.get()) != null) {
            ModAdvancements.TRIGGER_VAMPIRE_ACTION.trigger((ServerPlayer)cause.m_7639_(), VampireActionCriterionTrigger.Action.KILL_FROZEN_HUNTER);
        }
    }

    public void makeCampHunter(@NotNull BlockPos pos) {
        super.setHome(new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1)).m_82400_(10.0));
        this.setMoveTowardsRestriction(3, true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
    }

    protected boolean tryCureSanguinare(@NotNull Player entity) {
        if (!this.m_9236_().f_46443_ && entity.m_21023_((MobEffect)ModEffects.SANGUINARE.get())) {
            entity.m_21195_((MobEffect)ModEffects.SANGUINARE.get());
            entity.m_213846_((Component)Component.m_237115_((String)"text.vampirism.hunter.cured_sanguinare"));
            return true;
        }
        return false;
    }

    public static enum HatType {
        NONE(null),
        HAT_0((Supplier<? extends Item>)ModItems.HUNTER_HAT_HEAD_0),
        HAT_1((Supplier<? extends Item>)ModItems.HUNTER_HAT_HEAD_1);

        private final Supplier<? extends Item> headItem;

        private HatType(Supplier<? extends Item> headItem) {
            this.headItem = headItem;
        }

        public ItemStack getHeadItem() {
            if (this.headItem == null) {
                return ItemStack.f_41583_;
            }
            return this.headItem.get().m_7968_();
        }

        @NotNull
        public static HatType get(String value) {
            try {
                return HatType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return NONE;
            }
        }
    }

    public static enum EquipmentType {
        NONE(null, null),
        STAKE((Supplier<? extends Item>)ModItems.STAKE, null),
        AXE((Supplier<? extends Item>)ModItems.HUNTER_AXE_NORMAL, null),
        AXE_STAKE((Supplier<? extends Item>)ModItems.HUNTER_AXE_NORMAL, (Supplier<? extends Item>)ModItems.STAKE),
        CROSSBOW((Supplier<? extends Item>)ModItems.BASIC_CROSSBOW, null),
        DOUBLE_AXE((Supplier<? extends Item>)ModItems.HUNTER_AXE_NORMAL, (Supplier<? extends Item>)ModItems.HUNTER_AXE_NORMAL);

        private final Supplier<? extends Item> mainHand;
        private final Supplier<? extends Item> offHand;

        private EquipmentType(Supplier<? extends Item> mainHand, Supplier<? extends Item> offHand) {
            this.mainHand = mainHand;
            this.offHand = offHand;
        }

        public ItemStack getMainHand() {
            if (this.mainHand == null) {
                return ItemStack.f_41583_;
            }
            return this.mainHand.get().m_7968_();
        }

        public ItemStack getOffHand() {
            if (this.offHand == null) {
                return ItemStack.f_41583_;
            }
            return this.offHand.get().m_7968_();
        }

        @NotNull
        public static EquipmentType get(String value) {
            try {
                return EquipmentType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                return NONE;
            }
        }
    }
}

