/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.inventory.VampireBeaconMenu;
import de.teamlapen.vampirism.mixin.BeaconBeamSectionyMixin;
import de.teamlapen.vampirism.util.Helper;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class VampireBeaconBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    private static final int MAX_LEVELS = 3;
    public static final MobEffect[][] BEACON_EFFECTS = new MobEffect[][]{{MobEffects.f_19596_, MobEffects.f_19618_}, {MobEffects.f_19611_, MobEffects.f_19608_}, {MobEffects.f_19605_}};
    public static final int[][] BEACON_EFFECTS_AMPLIFIER = new int[][]{{0, 0}, {0, 0}, {0, 1}};
    public static final Set<MobEffect> NO_AMPLIFIER_EFFECTS = Set.of(MobEffects.f_19611_, MobEffects.f_19608_);
    private static final Set<MobEffect> VALID_EFFECTS = Arrays.stream(BEACON_EFFECTS).flatMap(Arrays::stream).collect(Collectors.toSet());
    public static final int DATA_LEVELS = 0;
    public static final int DATA_PRIMARY = 1;
    public static final int DATA_AMPLIFIER = 2;
    public static final int DATA_UPGRADED = 3;
    public static final int NUM_DATA_VALUES = 4;
    private static final int BLOCKS_CHECK_PER_TICK = 10;
    private static final Component DEFAULT_NAME = Component.m_237115_((String)"container.beacon");
    private List<BeaconBlockEntity.BeaconBeamSection> beamSections = Lists.newArrayList();
    private List<BeaconBlockEntity.BeaconBeamSection> checkingBeamSections = Lists.newArrayList();
    private int levels;
    private int lastCheckY;
    @Nullable
    private MobEffect primaryPower;
    private int effectAmplifier;
    private boolean isUpgraded;
    @Nullable
    private Component name;
    private LockCode lockKey = LockCode.f_19102_;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int slot) {
            return switch (slot) {
                case 0 -> VampireBeaconBlockEntity.this.levels;
                case 1 -> MobEffect.m_216882_((MobEffect)VampireBeaconBlockEntity.this.primaryPower);
                case 2 -> VampireBeaconBlockEntity.this.effectAmplifier;
                case 3 -> {
                    if (VampireBeaconBlockEntity.this.isUpgraded) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int slot, int value) {
            switch (slot) {
                case 0: {
                    VampireBeaconBlockEntity.this.levels = value;
                    break;
                }
                case 1: {
                    if (!((VampireBeaconBlockEntity)VampireBeaconBlockEntity.this).f_58857_.f_46443_ && !VampireBeaconBlockEntity.this.beamSections.isEmpty()) {
                        BeaconBlockEntity.m_155103_((Level)VampireBeaconBlockEntity.this.f_58857_, (BlockPos)VampireBeaconBlockEntity.this.f_58858_, (SoundEvent)SoundEvents.f_11739_);
                    }
                    VampireBeaconBlockEntity.this.primaryPower = VampireBeaconBlockEntity.getValidEffectById(value);
                    break;
                }
                case 2: {
                    VampireBeaconBlockEntity.this.effectAmplifier = value;
                    break;
                }
                case 3: {
                    VampireBeaconBlockEntity.this.isUpgraded = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public VampireBeaconBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.VAMPIRE_BEACON.get(), pPos, pBlockState);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, VampireBeaconBlockEntity pBlockEntity) {
        BlockPos blockpos;
        int i = pPos.m_123341_();
        int j = pPos.m_123342_();
        int k = pPos.m_123343_();
        if (pBlockEntity.lastCheckY < j) {
            blockpos = pPos;
            pBlockEntity.checkingBeamSections = Lists.newArrayList();
            pBlockEntity.lastCheckY = pPos.m_123342_() - 1;
        } else {
            blockpos = new BlockPos(i, pBlockEntity.lastCheckY + 1, k);
        }
        BeaconBlockEntity.BeaconBeamSection beaconblockentity$beaconbeamsection = pBlockEntity.checkingBeamSections.isEmpty() ? null : pBlockEntity.checkingBeamSections.get(pBlockEntity.checkingBeamSections.size() - 1);
        int l = pLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, i, k);
        for (int i1 = 0; i1 < 10 && blockpos.m_123342_() <= l; ++i1) {
            BlockState blockstate = pLevel.m_8055_(blockpos);
            Block block = blockstate.m_60734_();
            float[] afloat = blockstate.getBeaconColorMultiplier((LevelReader)pLevel, blockpos, pPos);
            if (afloat != null) {
                if (pBlockEntity.checkingBeamSections.size() <= 1) {
                    beaconblockentity$beaconbeamsection = new BeaconBlockEntity.BeaconBeamSection(afloat);
                    pBlockEntity.checkingBeamSections.add(beaconblockentity$beaconbeamsection);
                } else if (beaconblockentity$beaconbeamsection != null) {
                    if (Arrays.equals(afloat, beaconblockentity$beaconbeamsection.m_58722_())) {
                        ((BeaconBeamSectionyMixin)beaconblockentity$beaconbeamsection).invokeIncreaseHeight();
                    } else {
                        beaconblockentity$beaconbeamsection = new BeaconBlockEntity.BeaconBeamSection(new float[]{(beaconblockentity$beaconbeamsection.m_58722_()[0] + afloat[0]) / 2.0f, (beaconblockentity$beaconbeamsection.m_58722_()[1] + afloat[1]) / 2.0f, (beaconblockentity$beaconbeamsection.m_58722_()[2] + afloat[2]) / 2.0f});
                        pBlockEntity.checkingBeamSections.add(beaconblockentity$beaconbeamsection);
                    }
                }
            } else {
                if (beaconblockentity$beaconbeamsection == null || blockstate.m_60739_((BlockGetter)pLevel, blockpos) >= 15 && !blockstate.m_60713_(Blocks.f_50752_)) {
                    pBlockEntity.checkingBeamSections.clear();
                    pBlockEntity.lastCheckY = l;
                    break;
                }
                ((BeaconBeamSectionyMixin)beaconblockentity$beaconbeamsection).invokeIncreaseHeight();
            }
            blockpos = blockpos.m_7494_();
            ++pBlockEntity.lastCheckY;
        }
        int j1 = pBlockEntity.levels;
        if (pLevel.m_46467_() % 80L == 0L) {
            if (!pBlockEntity.beamSections.isEmpty()) {
                Pair<Integer, Boolean> integerBooleanPair = VampireBeaconBlockEntity.updateBase(pLevel, i, j, k);
                pBlockEntity.levels = (Integer)integerBooleanPair.getLeft();
                pBlockEntity.isUpgraded = (Boolean)integerBooleanPair.getRight();
            }
            if (pBlockEntity.levels > 0 && !pBlockEntity.beamSections.isEmpty()) {
                pBlockEntity.applyEffects(pLevel, pPos, pBlockEntity.levels, pBlockEntity.primaryPower, pBlockEntity.isUpgraded ? pBlockEntity.effectAmplifier + 1 : pBlockEntity.effectAmplifier);
                BeaconBlockEntity.m_155103_((Level)pLevel, (BlockPos)pPos, (SoundEvent)SoundEvents.f_11737_);
            }
        }
        if (pBlockEntity.lastCheckY >= l) {
            pBlockEntity.lastCheckY = pLevel.m_141937_() - 1;
            boolean flag = j1 > 0;
            pBlockEntity.beamSections = pBlockEntity.checkingBeamSections;
            if (!pLevel.f_46443_) {
                boolean flag1;
                boolean bl = flag1 = pBlockEntity.levels > 0;
                if (!flag && flag1) {
                    BeaconBlockEntity.m_155103_((Level)pLevel, (BlockPos)pPos, (SoundEvent)SoundEvents.f_11736_);
                    for (ServerPlayer serverplayer : pLevel.m_45976_(ServerPlayer.class, new AABB((double)i, (double)j, (double)k, (double)i, (double)(j - 3), (double)k).m_82377_(10.0, 5.0, 10.0))) {
                        CriteriaTriggers.f_10578_.m_148029_(serverplayer, pBlockEntity.levels);
                    }
                } else if (flag && !flag1) {
                    BeaconBlockEntity.m_155103_((Level)pLevel, (BlockPos)pPos, (SoundEvent)SoundEvents.f_11738_);
                }
            }
        }
    }

    protected void applyEffects(Level level, BlockPos pos, int levels, @Nullable MobEffect power, int effectAmplifier) {
        if (!level.f_46443_ && power != null) {
            if (NO_AMPLIFIER_EFFECTS.contains(power)) {
                effectAmplifier = 0;
            }
            AABB aabb = new AABB(pos).m_82400_((double)(levels * 10 + 10)).m_82363_(0.0, (double)level.m_141928_(), 0.0);
            int effectDuration = (9 + levels * 2) * 20;
            List list = level.m_6443_(Player.class, aabb, Helper::isHunter);
            int finalEffectAmplifier = effectAmplifier;
            list.forEach(player -> player.m_7292_(new MobEffectInstance(power, effectDuration, finalEffectAmplifier, true, true)));
        }
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    private static Pair<Integer, Boolean> updateBase(Level pLevel, int pX, int pY, int pZ) {
        int k;
        int i = 0;
        boolean upgradeFlag = true;
        int j = 1;
        while (j <= 3 && (k = pY - j) >= pLevel.m_141937_()) {
            boolean flag = true;
            boolean upgradeFlagLevel = upgradeFlag;
            block1: for (int l = pX - j; l <= pX + j && flag; ++l) {
                for (int i1 = pZ - j; i1 <= pZ + j; ++i1) {
                    BlockState blockState = pLevel.m_8055_(new BlockPos(l, k, i1));
                    if (!blockState.m_204336_(ModTags.Blocks.VAMPIRE_BEACON_BASE_BLOCKS)) {
                        flag = false;
                        continue block1;
                    }
                    if (!upgradeFlagLevel) continue;
                    upgradeFlagLevel = blockState.m_204336_(ModTags.Blocks.VAMPIRE_BEACON_BASE_ENHANCED_BLOCKS);
                }
            }
            if (!flag) break;
            upgradeFlag = upgradeFlag && upgradeFlagLevel;
            i = j++;
        }
        return Pair.of((Object)i, (Object)upgradeFlag);
    }

    public void m_7651_() {
        BeaconBlockEntity.m_155103_((Level)this.f_58857_, (BlockPos)this.f_58858_, (SoundEvent)SoundEvents.f_11738_);
        super.m_7651_();
    }

    public List<BeaconBlockEntity.BeaconBeamSection> getBeamSections() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSections;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    static MobEffect getValidEffectById(int pEffectId) {
        MobEffect mobeffect = MobEffect.m_19453_((int)pEffectId);
        return VALID_EFFECTS.contains(mobeffect) ? mobeffect : null;
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.primaryPower = VampireBeaconBlockEntity.getValidEffectById(pTag.m_128451_("Primary"));
        if (pTag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)pTag.m_128461_("CustomName"));
        }
        this.effectAmplifier = pTag.m_128451_("Amplifier");
        this.lockKey = LockCode.m_19111_((CompoundTag)pTag);
        this.isUpgraded = pTag.m_128471_("Upgraded");
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("Primary", MobEffect.m_216882_((MobEffect)this.primaryPower));
        pTag.m_128405_("Levels", this.levels);
        if (this.name != null) {
            pTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
        pTag.m_128405_("Amplifier", this.effectAmplifier);
        this.lockKey.m_19109_(pTag);
        pTag.m_128379_("Upgraded", this.isUpgraded);
    }

    public void setCustomName(@Nullable Component pName) {
        this.name = pName;
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return BaseContainerBlockEntity.m_58629_((Player)pPlayer, (LockCode)this.lockKey, (Component)this.m_5446_()) ? new VampireBeaconMenu(pContainerId, (Container)pPlayerInventory, this.dataAccess, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_())) : null;
    }

    @NotNull
    public Component m_5446_() {
        return this.m_7755_();
    }

    @NotNull
    public Component m_7755_() {
        return this.name != null ? this.name : DEFAULT_NAME;
    }

    public void m_142339_(@NotNull Level pLevel) {
        super.m_142339_(pLevel);
        this.lastCheckY = pLevel.m_141937_() - 1;
    }
}

