/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.data;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class BaseItemModelGenerator
extends ItemModelProvider {
    public BaseItemModelGenerator(@NotNull PackOutput packOutput, @NotNull String modid, @NotNull ExistingFileHelper existingFileHelper) {
        super(packOutput, modid, existingFileHelper);
    }

    public ItemModelBuilder block(Block name) {
        return this.block(name, ForgeRegistries.BLOCKS.getKey((Object)name).m_135815_());
    }

    public ItemModelBuilder block(Block name, String path) {
        try {
            return (ItemModelBuilder)super.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)name).m_135815_(), this.modid + ":block/" + path);
        }
        catch (IllegalStateException e) {
            return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(ForgeRegistries.BLOCKS.getKey((Object)name).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modid + ":block/" + path));
        }
    }

    @NotNull
    public String m_6055_() {
        return this.modid + " Item Models";
    }

    public ItemModelBuilder item(Item item) {
        return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated")).texture("layer0", this.modid + ":item/" + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_());
    }

    public ItemModelBuilder item(Item item, ResourceLocation ... texture) {
        return this.item(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), texture);
    }

    public ItemModelBuilder item(String item, ResourceLocation ... texture) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated"));
        for (int i = 0; i < texture.length; ++i) {
            model.texture("layer" + i, texture[i]);
        }
        return model;
    }

    @NotNull
    public ItemModelBuilder withExistingParent(Item name, Item parent) {
        return this.withExistingParent(name, ForgeRegistries.ITEMS.getKey((Object)parent));
    }

    @NotNull
    public ItemModelBuilder withExistingParent(Block name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)name).m_135815_(), parent);
    }

    @NotNull
    public ItemModelBuilder withExistingParent(Item name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)name).m_135815_(), parent);
    }
}

