/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.entities;

import com.lion.graveyard.entities.AngerableGraveyardEntity;
import com.lion.graveyard.entities.HordeGraveyardEntity;
import com.lion.graveyard.entities.LichEntity;
import com.lion.graveyard.entities.ai.goals.GhoulMeleeAttackGoal;
import com.lion.graveyard.init.TGSounds;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GhoulEntity
extends AngerableGraveyardEntity
implements GeoEntity {
    private AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final UUID SLOWNESS_ID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A1");
    private static final AttributeModifier SLOWNESS_EFFECT;
    private static final EntityDataAccessor<Byte> VARIANT;
    private static final EntityDataAccessor<Integer> ATTACK_ANIM_TIMER;
    private static final EntityDataAccessor<Integer> RAGE_ANIM_TIMER;
    private static final EntityDataAccessor<Integer> ANIMATION;
    private static final EntityDataAccessor<Integer> SPAWN_TIMER;
    private static final EntityDataAccessor<Boolean> IS_RAGING;
    private final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);
    private final RawAnimation IDLE_ANIMATION = RawAnimation.begin().then("idle", Animation.LoopType.LOOP);
    private final RawAnimation WALK_ANIMATION = RawAnimation.begin().then("walk", Animation.LoopType.LOOP);
    private final RawAnimation RAGE_ANIMATION = RawAnimation.begin().then("rage", Animation.LoopType.LOOP);
    private final RawAnimation RUNNING_ANIMATION = RawAnimation.begin().then("running", Animation.LoopType.LOOP);
    private final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().then("attack", Animation.LoopType.LOOP);
    private final RawAnimation SPAWN_ANIMATION = RawAnimation.begin().then("spawn", Animation.LoopType.PLAY_ONCE);
    protected static final int ANIMATION_IDLE = 0;
    protected static final int ANIMATION_WALK = 1;
    protected static final int ANIMATION_RAGE = 2;
    protected static final int ANIMATION_DEATH = 3;
    protected static final int ANIMATION_RUNNING = 4;
    protected static final int ANIMATION_MELEE = 5;
    protected static final int ANIMATION_SPAWN = 6;
    public final int ATTACK_ANIMATION_DURATION = 14;
    public final int RAGE_ANIMATION_DURATION = 35;
    public final int RAGE_ANIMATION_COOLDOWN = 300;

    public GhoulEntity(EntityType<? extends GhoulEntity> entityType, Level world) {
        super(entityType, world, "ghoul");
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        byte variant = (byte)((byte)this.f_19796_.m_188503_(8) + 1);
        this.f_19804_.m_135372_(VARIANT, (Object)variant);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
        this.f_19804_.m_135372_(ATTACK_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(RAGE_ANIM_TIMER, (Object)0);
        this.f_19804_.m_135372_(SPAWN_TIMER, (Object)32);
        this.f_19804_.m_135372_(IS_RAGING, (Object)false);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new GhoulMeleeAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{LichEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createGhoulAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, 0.175).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public int getAnimationState() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION, (Object)state);
    }

    public int getAttackAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_ANIM_TIMER);
    }

    public void setAttackAnimTimer(int time) {
        this.f_19804_.m_135381_(ATTACK_ANIM_TIMER, (Object)time);
    }

    public int getSpawnTimer() {
        return (Integer)this.f_19804_.m_135370_(SPAWN_TIMER);
    }

    public void setSpawnTimer(int ticks) {
        this.f_19804_.m_135381_(SPAWN_TIMER, (Object)ticks);
    }

    public int getRageAnimTimer() {
        return (Integer)this.f_19804_.m_135370_(RAGE_ANIM_TIMER);
    }

    public void setRageAnimTimer(int time) {
        this.f_19804_.m_135381_(RAGE_ANIM_TIMER, (Object)time);
    }

    public boolean isRaging() {
        return (Boolean)this.f_19804_.m_135370_(IS_RAGING);
    }

    public void setIsRaging(boolean raging) {
        this.f_19804_.m_135381_(IS_RAGING, (Object)raging);
    }

    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    protected void m_8024_() {
        int animTimer;
        if (this.getAttackAnimTimer() == 14) {
            this.setAnimationState(5);
            if (this.getRageAnimTimer() <= 0) {
                this.setRageAnimTimer(300);
            }
        }
        if (this.getRageAnimTimer() == 35) {
            this.m_5496_(TGSounds.GHOUL_ROAR.get(), 1.0f, 1.0f);
            this.setIsRaging(true);
            this.setAnimationState(2);
            this.aggroMobs();
        }
        if (this.getAttackAnimTimer() > 0) {
            animTimer = this.getAttackAnimTimer() - 1;
            this.setAttackAnimTimer(animTimer);
        }
        if (this.getRageAnimTimer() > 0) {
            animTimer = this.getRageAnimTimer() - 1;
            this.setRageAnimTimer(animTimer);
        }
        if (this.getRageAnimTimer() == 0) {
            this.setIsRaging(false);
        }
        if (this.getSpawnTimer() > 0) {
            this.setSpawnTimer(this.getSpawnTimer() - 1);
        }
        super.m_8024_();
    }

    @Override
    public void m_8107_() {
        AttributeInstance entityAttributeInstance = this.m_21051_(Attributes.f_22279_);
        if (this.isRaging()) {
            if (!entityAttributeInstance.m_22109_(SLOWNESS_EFFECT)) {
                entityAttributeInstance.m_22118_(SLOWNESS_EFFECT);
            }
        } else if (entityAttributeInstance.m_22109_(SLOWNESS_EFFECT)) {
            entityAttributeInstance.m_22130_(SLOWNESS_EFFECT);
        }
        super.m_8107_();
    }

    public void m_8119_() {
        if (this.getSpawnTimer() > 0 && this.m_20193_() != null) {
            RandomSource random = this.m_217043_();
            BlockState blockState = this.m_20075_();
            if (blockState.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    double d = this.m_20185_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                    double e = this.m_20186_();
                    double f = this.m_20189_() + (double)Mth.m_216283_((RandomSource)random, (float)-0.7f, (float)0.7f);
                    this.m_20193_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), d, e, f, 0.0, 0.0, 0.0);
                }
            }
        }
        super.m_8119_();
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("ghoulVariant", this.getVariant());
        nbt.m_128405_("spawnTimer", this.getSpawnTimer());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setVariant(nbt.m_128445_("ghoulVariant"));
        this.setSpawnTimer(nbt.m_128451_("spawnTimer"));
    }

    private void aggroMobs() {
        if (this.m_5448_() != null) {
            List monster = this.m_20193_().m_6443_(HordeGraveyardEntity.class, new AABB(this.m_20183_()).m_82400_(45.0), arg_0 -> ((GhoulEntity)this).m_142582_(arg_0));
            for (HordeGraveyardEntity entity : monster) {
                entity.m_6710_(this.m_5448_());
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, event -> {
            boolean isMoving;
            float limbSwingAmount = event.getLimbSwingAmount();
            boolean bl = isMoving = !(limbSwingAmount > -0.05f) || !(limbSwingAmount < 0.05f);
            if (this.getSpawnTimer() > 0) {
                event.getController().setAnimation(this.SPAWN_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.m_21224_() || (double)this.m_21223_() < 0.01) {
                event.getController().setAnimation(this.DEATH_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 5 && this.getAttackAnimTimer() == 13 && this.m_5912_() && !this.m_21224_() && !((double)this.m_21223_() < 0.01)) {
                this.setAttackAnimTimer(12);
                event.getController().setAnimation(this.ATTACK_ANIMATION);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 2 && this.getRageAnimTimer() == 34 && this.isRaging()) {
                event.getController().setAnimation(this.RAGE_ANIMATION);
                return PlayState.CONTINUE;
            }
            if ((event.isMoving() || isMoving) && this.getAttackAnimTimer() <= 0 && !this.isRaging()) {
                if (this.m_5912_() && !this.m_20071_()) {
                    event.getController().setAnimation(this.RUNNING_ANIMATION);
                } else {
                    event.getController().setAnimation(this.WALK_ANIMATION);
                }
                return PlayState.CONTINUE;
            }
            if (!event.isMoving() && !this.isRaging()) {
                event.getController().setAnimation(this.IDLE_ANIMATION);
            }
            if (this.getAnimationState() == 0 && this.getAttackAnimTimer() <= 0 && !event.isMoving()) {
                this.setAnimationState(0);
                return PlayState.CONTINUE;
            }
            if (this.getAnimationState() == 0 && this.getAttackAnimTimer() > 0) {
                this.setAnimationState(5);
                return PlayState.STOP;
            }
            if (this.getAttackAnimTimer() <= 0 && !this.m_21224_() && !((double)this.m_21223_() < 0.01) && this.getAnimationState() != 2) {
                this.setAnimationState(0);
                return PlayState.STOP;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void m_8032_() {
        this.m_5496_(TGSounds.GHOUL_AMBIENT.get(), 1.0f, -5.0f);
    }

    public void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(TGSounds.GHOUL_STEP.get(), 0.5f, -1.0f);
    }

    protected void m_6677_(DamageSource source) {
        this.m_5496_(TGSounds.GHOUL_HURT.get(), 1.0f, -5.0f);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        this.m_5496_(TGSounds.GHOUL_DEATH.get(), 1.0f, -5.0f);
    }

    static {
        VARIANT = SynchedEntityData.m_135353_(GhoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        ATTACK_ANIM_TIMER = SynchedEntityData.m_135353_(GhoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        RAGE_ANIM_TIMER = SynchedEntityData.m_135353_(GhoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ANIMATION = SynchedEntityData.m_135353_(GhoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        SPAWN_TIMER = SynchedEntityData.m_135353_(GhoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        IS_RAGING = SynchedEntityData.m_135353_(GhoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SLOWNESS_EFFECT = new AttributeModifier(SLOWNESS_ID, "Slowness effect", -0.3, AttributeModifier.Operation.ADDITION);
    }
}

