/*
 * Decompiled with CFR 0.152.
 */
package com.lion.graveyard.blocks;

import com.lion.graveyard.blockentities.GravestoneBlockEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundOpenSignEditorPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.GlowInkSacItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.InkSacItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GravestoneBlock
extends StandingSignBlock
implements EntityBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty FLOOR = BlockStateProperties.f_61427_;
    private static final VoxelShape SHAPE_FACING_EW = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_FACING_NS = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private final ResourceLocation texture;

    public GravestoneBlock(ResourceLocation texture) {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60955_().m_60918_(SoundType.f_154678_).m_60978_(1.5f), WoodType.f_61830_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FLOOR, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SignBlock.f_56268_, (Comparable)Boolean.valueOf(false)));
        this.texture = texture;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FLOOR, SignBlock.f_56268_, ROTATION});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (Direction.NORTH == state.m_61143_((Property)FACING) || Direction.SOUTH == state.m_61143_((Property)FACING)) {
            return SHAPE_FACING_NS;
        }
        return SHAPE_FACING_EW;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GravestoneBlockEntity(pos, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        Item item2 = itemStack.m_41720_();
        SignApplicator signChangingItem = item2 instanceof SignApplicator ? (SignApplicator)item2 : null;
        SignApplicator signChangingItem2 = signChangingItem;
        boolean bl = signChangingItem2 != null && player.m_36326_();
        BlockEntity var12 = world.m_7702_(pos);
        if (!(var12 instanceof GravestoneBlockEntity)) return InteractionResult.PASS;
        GravestoneBlockEntity signBlockEntity = (GravestoneBlockEntity)var12;
        if (world.f_46443_) return !bl && !signBlockEntity.isWaxed() ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
        SignText signText = signBlockEntity.getText();
        boolean bl3 = signBlockEntity.runCommandClickEvent(player, world, pos);
        if (signBlockEntity.isWaxed()) {
            world.m_247517_(null, signBlockEntity.m_58899_(), SoundEvents.f_276627_, SoundSource.BLOCKS);
            return InteractionResult.PASS;
        }
        if (bl && !this.isOtherPlayerEditing(player, signBlockEntity) && signChangingItem2.m_277072_(signText, player)) {
            boolean useOnSign = false;
            if (signChangingItem2 instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)signChangingItem2;
                useOnSign = this.useDyeOnSign(world, signBlockEntity, dyeItem.m_41089_());
            } else if (signChangingItem2 instanceof InkSacItem) {
                useOnSign = this.useInkOnSign(world, signBlockEntity);
            } else if (signChangingItem2 instanceof HoneycombItem) {
                useOnSign = this.useWaxOnSign(world, signBlockEntity);
            } else if (signChangingItem2 instanceof GlowInkSacItem) {
                useOnSign = this.useGlowInkOnSign(world, signBlockEntity);
            }
            if (!useOnSign) return InteractionResult.PASS;
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            world.m_220407_(GameEvent.f_157792_, signBlockEntity.m_58899_(), GameEvent.Context.m_223719_((Entity)player, (BlockState)signBlockEntity.m_58900_()));
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return InteractionResult.SUCCESS;
        }
        if (bl3) {
            return InteractionResult.SUCCESS;
        }
        if (this.isOtherPlayerEditing(player, signBlockEntity) || !player.m_36326_() || !this.isTextLiteralOrEmpty(player, signBlockEntity)) return InteractionResult.PASS;
        this.openEditScreen(player, signBlockEntity, world, pos, state);
        return InteractionResult.SUCCESS;
    }

    public boolean useDyeOnSign(Level world, GravestoneBlockEntity signBlockEntity, DyeColor color) {
        if (signBlockEntity.changeText(text -> text.m_276901_(color))) {
            world.m_5594_(null, signBlockEntity.m_58899_(), SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean useInkOnSign(Level world, GravestoneBlockEntity signBlockEntity) {
        if (signBlockEntity.changeText(text -> text.m_277132_(false))) {
            world.m_5594_(null, signBlockEntity.m_58899_(), SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean useGlowInkOnSign(Level world, GravestoneBlockEntity signBlockEntity) {
        if (signBlockEntity.changeText(text -> text.m_277132_(true))) {
            world.m_5594_(null, signBlockEntity.m_58899_(), SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean useWaxOnSign(Level world, GravestoneBlockEntity signBlockEntity) {
        if (signBlockEntity.setWaxed(true)) {
            world.m_5898_(null, 3003, signBlockEntity.m_58899_(), 0);
            return true;
        }
        return false;
    }

    private boolean isTextLiteralOrEmpty(Player player, GravestoneBlockEntity blockEntity) {
        SignText signText = blockEntity.getText();
        return Arrays.stream(signText.m_276945_(player.m_143387_())).allMatch(message -> message.equals(CommonComponents.f_237098_) || message.m_214077_() instanceof LiteralContents);
    }

    public void openEditScreen(Player player, GravestoneBlockEntity blockEntity, Level world, BlockPos pos, BlockState state) {
        blockEntity.setEditor(player.m_20148_());
        this.openScreen(world, pos, player);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            this.openScreen(world, pos, player);
        }
    }

    private void openScreen(Level world, BlockPos pos, Player placer) {
        GravestoneBlockEntity sign = (GravestoneBlockEntity)world.m_7702_(pos);
        if (!world.f_46443_) {
            sign.setEditor(placer.m_20148_());
            ((ServerPlayer)placer).f_8906_.m_9829_((Packet)new ClientboundOpenSignEditorPacket(pos, true));
        }
    }

    private boolean isOtherPlayerEditing(Player player, GravestoneBlockEntity blockEntity) {
        UUID uUID = blockEntity.getEditor();
        return uUID != null && !uUID.equals(player.m_20148_());
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Direction direction = ctx.m_8125_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_61124_((Property)SignBlock.f_56268_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_280296_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (Direction.NORTH == state.m_61143_((Property)FACING) || Direction.SOUTH == state.m_61143_((Property)FACING)) {
            return SHAPE_FACING_NS;
        }
        return SHAPE_FACING_EW;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }
}

