/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.network;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.tconstruct.smeltery.block.entity.FaucetBlockEntity;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public class FaucetActivationPacket
extends FluidUpdatePacket {
    private final boolean isPouring;

    public FaucetActivationPacket(BlockPos pos, FluidStack fluid, boolean isPouring) {
        super(pos, fluid);
        this.isPouring = isPouring;
    }

    public FaucetActivationPacket(FriendlyByteBuf buffer) {
        super(buffer);
        this.isPouring = buffer.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf packetBuffer) {
        super.encode(packetBuffer);
        packetBuffer.writeBoolean(this.isPouring);
    }

    @Override
    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(FaucetActivationPacket packet) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            BlockEntity te = Minecraft.m_91087_().f_91073_.m_7702_(packet.pos);
            if (te instanceof FaucetBlockEntity) {
                ((FaucetBlockEntity)te).onActivationPacket(packet.fluid, packet.isPouring);
            }
        }
    }
}

