/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.ArmorLootingModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.LootingModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.IntLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.LootingContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface LootingModule
extends ModifierModule,
IntLevelModule,
ModifierCondition.ConditionalModule<IToolStackView> {
    public static final LoadableField<IJsonPredicate<LivingEntity>, LootingModule> HOLDER = LivingEntityPredicate.LOADER.defaultField("holder", LootingModule::holder);
    public static final LoadableField<IJsonPredicate<LivingEntity>, LootingModule> TARGET = LivingEntityPredicate.LOADER.defaultField("target", LootingModule::target);
    public static final LoadableField<IJsonPredicate<DamageSource>, LootingModule> DAMAGE_SOURCE = DamageSourcePredicate.LOADER.defaultField("damage_source", LootingModule::damageSource);

    public IJsonPredicate<LivingEntity> holder();

    public IJsonPredicate<LivingEntity> target();

    public IJsonPredicate<DamageSource> damageSource();

    default public boolean matchesConditions(IToolStackView tool, ModifierEntry modifier, LootingContext context) {
        return this.condition().matches(tool, modifier) && this.holder().matches((Object)context.getHolder()) && TinkerPredicate.matches(this.target(), context.getLivingTarget()) && TinkerPredicate.matches(this.damageSource(), context.getDamageSource());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder> {
        private int level = 1;
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> target = LivingEntityPredicate.ANY;
        private IJsonPredicate<DamageSource> damageSource = DamageSourcePredicate.ANY;

        private Builder() {
        }

        public Weapon weapon() {
            return new Weapon(this.level, this.holder, this.target, this.damageSource, this.condition);
        }

        public Armor armor(EquipmentSlot ... slots) {
            if (slots.length == 0) {
                throw new IllegalArgumentException("Must have at least 1 slot");
            }
            return new Armor(this.level, this.holder, this.target, this.damageSource, this.condition, (Set<EquipmentSlot>)ImmutableSet.copyOf((Object[])slots));
        }

        public Armor armor() {
            return this.armor(EquipmentSlot.values());
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }

        public Builder target(IJsonPredicate<LivingEntity> target) {
            this.target = target;
            return this;
        }

        public Builder damageSource(IJsonPredicate<DamageSource> damageSource) {
            this.damageSource = damageSource;
            return this;
        }
    }

    public record Armor(int level, IJsonPredicate<LivingEntity> holder, IJsonPredicate<LivingEntity> target, IJsonPredicate<DamageSource> damageSource, ModifierCondition<IToolStackView> condition, Set<EquipmentSlot> slots) implements LootingModule,
    ArmorLootingModifierHook
    {
        private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.ARMOR_LOOTING);
        public static final RecordLoadable<Armor> LOADER = RecordLoadable.create(IntLevelModule.FIELD, (RecordField)HOLDER, (RecordField)TARGET, (RecordField)DAMAGE_SOURCE, ModifierCondition.TOOL_FIELD, (RecordField)TinkerLoadables.EQUIPMENT_SLOT_SET.requiredField("slots", Armor::slots), Armor::new);

        @Override
        public int updateArmorLooting(IToolStackView tool, ModifierEntry modifier, LootingContext context, EquipmentContext equipment, EquipmentSlot slot, int looting) {
            if (this.slots.contains(slot) && this.matchesConditions(tool, modifier, context)) {
                looting += this.getLevel(modifier);
            }
            return looting;
        }

        public RecordLoadable<Armor> getLoader() {
            return LOADER;
        }

        @Override
        public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }
    }

    public record Weapon(int level, IJsonPredicate<LivingEntity> holder, IJsonPredicate<LivingEntity> target, IJsonPredicate<DamageSource> damageSource, ModifierCondition<IToolStackView> condition) implements LootingModule,
    LootingModifierHook
    {
        private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.WEAPON_LOOTING);
        public static final RecordLoadable<Weapon> LOADER = RecordLoadable.create(IntLevelModule.FIELD, (RecordField)HOLDER, (RecordField)TARGET, (RecordField)DAMAGE_SOURCE, ModifierCondition.TOOL_FIELD, Weapon::new);

        @Override
        public int updateLooting(IToolStackView tool, ModifierEntry modifier, LootingContext context, int looting) {
            if (this.matchesConditions(tool, modifier, context)) {
                looting += this.getLevel(modifier);
            }
            return looting;
        }

        public RecordLoadable<Weapon> getLoader() {
            return LOADER;
        }

        @Override
        public List<ModuleHook<?>> getDefaultHooks() {
            return DEFAULT_HOOKS;
        }
    }
}

