/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.library.client.armor.ArmorModelManager;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;

public abstract class AbstractArmorModelProvider
extends GenericDataProvider {
    private final Map<ResourceLocation, ArmorModelManager.ArmorModel> models = new HashMap<ResourceLocation, ArmorModelManager.ArmorModel>();

    public AbstractArmorModelProvider(PackOutput packOutput) {
        super(packOutput, PackOutput.Target.RESOURCE_PACK, "tinkering/armor_models");
    }

    protected abstract void addModels();

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        this.addModels();
        return AbstractArmorModelProvider.allOf(this.models.entrySet().stream().map(entry -> this.saveJson(output, (ResourceLocation)entry.getKey(), ArmorModelManager.ArmorModel.LOADABLE.serialize((Object)((ArmorModelManager.ArmorModel)entry.getValue())))));
    }

    protected void addModel(ResourceLocation name, ArmorTextureSupplier ... layers) {
        ArmorModelManager.ArmorModel existing = this.models.putIfAbsent(name, new ArmorModelManager.ArmorModel(List.of(layers)));
        if (existing != null) {
            throw new IllegalArgumentException("Duplicate armor model at " + name + ", previous value " + existing);
        }
    }

    protected void addModel(IdAwareObject name, ArmorTextureSupplier ... layers) {
        this.addModel(name.getId(), layers);
    }

    protected void addModel(IdAwareObject name, Function<ResourceLocation, ArmorTextureSupplier[]> layers) {
        this.addModel(name.getId(), layers.apply(name.getId()));
    }
}

