/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.mixins.compat.ae2;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.util.INetworkToolAware;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.solarflux.attribute.SimpleAttributeProperty;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.compat.ae2.ContentsSFAE2;
import org.zeith.solarflux.compat.ae2.tile.IAE2SolarPanelTile;

@Mixin(value={SolarPanelTile.class})
@Implements(value={@Interface(iface=IAEPowerStorage.class, prefix="ae$"), @Interface(iface=IGridConnectedBlockEntity.class, prefix="aegrid$"), @Interface(iface=IInWorldGridNodeHost.class, prefix="aeinw$"), @Interface(iface=INetworkToolAware.class, prefix="aenta$"), @Interface(iface=IAE2SolarPanelTile.class, prefix="sfr$")})
public abstract class SolarPanelTileMixin
extends TileSyncableTickable
implements IAEPowerStorage,
IGridConnectedBlockEntity,
IAE2SolarPanelTile,
IInWorldGridNodeHost,
INetworkToolAware {
    @Shadow
    public long energy;
    @Shadow
    @Final
    public SimpleAttributeProperty capacity;
    private IManagedGridNode mainNode;

    public SolarPanelTileMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Shadow
    public abstract int getUpgrades(Item var1);

    @Shadow
    public abstract int extractEnergy(int var1, boolean var2);

    @Inject(method={"onConstructed"}, at={@At(value="HEAD")}, remap=false)
    private void constructed(CallbackInfo ci) {
        this.createAe2MainNode();
    }

    private void createAe2MainNode() {
        if (this.mainNode != null) {
            this.mainNode.destroy();
        }
        this.mainNode = GridHelper.createManagedNode((Object)((IGridConnectedBlockEntity)Cast.cast((Object)this)), (IGridNodeListener)BlockEntityNodeListener.INSTANCE).setVisualRepresentation((ItemLike)this.m_58900_().m_60734_()).setInWorldNode(true).setIdlePowerUsage(0.0).setExposedOnSides(Arrays.stream(Direction.values()).filter(f -> f != Direction.UP).collect(Collectors.toSet())).addService(IAEPowerStorage.class, (IGridNodeService)this);
    }

    @Inject(method={"onChunkUnloadedSFR"}, at={@At(value="HEAD")}, remap=false)
    public void onChunkUnloadedAE(CallbackInfo ci) {
        this.getMainNode().destroy();
    }

    @Inject(method={"setRemovedSFR"}, at={@At(value="HEAD")}, remap=false)
    public void setRemovedAE(CallbackInfo ci) {
        this.getMainNode().destroy();
    }

    @Inject(method={"clearRemovedSFR"}, at={@At(value="HEAD")}, remap=false)
    public void clearRemovedAE(CallbackInfo ci) {
        this.scheduleInit();
    }

    @Inject(method={"writeNBT"}, at={@At(value="HEAD")}, remap=false)
    public void writeNBT_AE(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag ae2 = new CompoundTag();
        this.mainNode.saveToNBT(ae2);
        nbt.m_128365_("AEGrid", (Tag)ae2);
    }

    @Inject(method={"readNBT"}, at={@At(value="TAIL")}, remap=false)
    public void readNBT_AE(CompoundTag nbt, CallbackInfo ci) {
        if (this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) > 0) {
            this.createAe2MainNode();
            this.mainNode.loadFromNBT(nbt.m_128469_("AEGrid"));
        }
    }

    public double ae$extractAEPower(double toExtract, Actionable action, PowerMultiplier mult) {
        if (this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) <= 0) {
            return 0.0;
        }
        int fe = (int)Math.min(Math.floor(PowerUnits.AE.convertTo(PowerUnits.FE, toExtract)), 2.147483646E9);
        fe = this.extractEnergy(fe, action.isSimulate());
        return mult.multiply(PowerUnits.FE.convertTo(PowerUnits.AE, (double)fe));
    }

    public IManagedGridNode aegrid$getMainNode() {
        return this.mainNode;
    }

    public double ae$getAECurrentPower() {
        return PowerUnits.FE.convertTo(PowerUnits.AE, (double)this.energy);
    }

    public double ae$getAEMaxPower() {
        return PowerUnits.FE.convertTo(PowerUnits.AE, this.capacity.getValue());
    }

    public AccessRestriction ae$getPowerFlow() {
        return this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) > 0 ? AccessRestriction.READ_WRITE : AccessRestriction.NO_ACCESS;
    }

    public double ae$injectAEPower(double amt, Actionable mode) {
        return 0.0;
    }

    public boolean ae$isAEPublicPowerStorage() {
        return true;
    }

    public int ae$getPriority() {
        return 0;
    }

    public void aegrid$saveChanges() {
    }

    public boolean aenta$showNetworkInfo(UseOnContext context) {
        return this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) > 0;
    }

    protected void scheduleInit() {
        GridHelper.onFirstTick((BlockEntity)((SolarPanelTile)Cast.cast((Object)this, SolarPanelTile.class)), e -> {
            if (e instanceof IGridConnectedBlockEntity) {
                IGridConnectedBlockEntity h = (IGridConnectedBlockEntity)e;
                if (this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) > 0) {
                    h.getMainNode().create(this.f_58857_, this.f_58858_);
                }
            }
        });
    }

    @Nullable
    public IGridNode aeinw$getGridNode(Direction dir) {
        if (this.getUpgrades(ContentsSFAE2.ENERGY_UPGRADE) <= 0) {
            return null;
        }
        return this.getMainNode().getNode();
    }

    public void sfr$setConnectedToAENetwork(boolean connected) {
        boolean isAe2NodeConnected;
        boolean bl = isAe2NodeConnected = this.mainNode.getNode() != null;
        if (isAe2NodeConnected != connected) {
            if (connected) {
                this.createAe2MainNode();
                this.mainNode.create(this.f_58857_, this.f_58858_);
            } else {
                this.mainNode.destroy();
            }
        }
    }
}

