/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.client;

import com.github.exopandora.shouldersurfing.api.callback.ICameraEntityTransparencyCallback;
import com.github.exopandora.shouldersurfing.api.client.ICameraEntityRenderer;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingCamera;
import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import com.github.exopandora.shouldersurfing.config.Config;
import com.github.exopandora.shouldersurfing.plugin.ShoulderSurfingRegistrar;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CameraEntityRenderer
implements ICameraEntityRenderer {
    private final ShoulderSurfingImpl instance;
    private float cameraEntityAlpha = 1.0f;
    private boolean isRenderingCameraEntity;

    public CameraEntityRenderer(ShoulderSurfingImpl instance) {
        this.instance = instance;
    }

    public boolean preRenderCameraEntity(Entity entity, float partialTick) {
        if (this.shouldSkipCameraEntityRendering(entity)) {
            return true;
        }
        this.cameraEntityAlpha = 1.0f;
        if (this.instance.isShoulderSurfing() && Config.CLIENT.isPlayerTransparencyEnabled()) {
            for (ICameraEntityTransparencyCallback callback : ShoulderSurfingRegistrar.getInstance().getCameraEntityTransparencyCallbacks()) {
                this.cameraEntityAlpha = Math.min(Mth.m_14036_((float)callback.getCameraEntityAlpha(this.instance, entity, partialTick), (float)0.0f, (float)1.0f), this.cameraEntityAlpha);
            }
        }
        this.isRenderingCameraEntity = true;
        return false;
    }

    public void postRenderCameraEntity(Entity entity, float partialTick) {
        this.isRenderingCameraEntity = false;
    }

    private boolean shouldSkipCameraEntityRendering(Entity cameraEntity) {
        Player player;
        ShoulderSurfingCamera camera = this.instance.getCamera();
        return this.instance.isShoulderSurfing() && !cameraEntity.m_5833_() && (camera.getCameraDistance() < (double)cameraEntity.m_20205_() * Config.CLIENT.keepCameraOutOfHeadMultiplier() || (double)camera.getXRot() < Config.CLIENT.getHidePlayerWhenLookingUpAngle() - 90.0 || cameraEntity instanceof Player && (player = (Player)cameraEntity).m_150108_());
    }

    public float applyCameraEntityAlphaContextAware(float alpha) {
        return this.isRenderingCameraEntity ? Math.min(alpha, this.cameraEntityAlpha) : alpha;
    }

    public int applyCameraEntityAlphaContextAware(int color) {
        return this.isRenderingCameraEntity ? this.applyCameraEntityAlpha(color) : color;
    }

    public int applyCameraEntityAlpha(int color) {
        int alpha;
        int cameraEntityAlpha = this.getCameraEntityAlphaAsInt();
        if (cameraEntityAlpha < (alpha = FastColor.ARGB32.m_13655_((int)color))) {
            return (color & 0xFFFFFF) + (cameraEntityAlpha << 24);
        }
        return color;
    }

    @Override
    public boolean isRenderingCameraEntity() {
        return this.isRenderingCameraEntity;
    }

    @Override
    public float getCameraEntityAlpha() {
        return this.cameraEntityAlpha;
    }

    @Override
    public int getCameraEntityAlphaAsInt() {
        return Mth.m_14143_((float)(this.cameraEntityAlpha * 255.0f));
    }
}

