/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import glitchcore.event.TagsUpdatedEvent;
import glitchcore.event.player.PlayerInteractEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModFertility;
import sereneseasons.init.ModTags;

public class SeasonalCropGrowthHandler {
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        ModFertility.populate();
    }

    public static void onCropGrowth(Level level, BlockPos pos, BlockState state, CallbackInfo ci) {
        if (!ModConfig.fertility.seasonalCrops || !ModFertility.isCrop(state)) {
            return;
        }
        Registry blockRegistry = level.m_9598_().m_175515_(Registries.f_256747_);
        boolean isFertile = ModFertility.isCropFertile(blockRegistry.m_7981_((Object)state.m_60734_()).toString(), level, pos);
        if (!isFertile && !SeasonalCropGrowthHandler.isGlassAboveBlock(level, pos)) {
            if (ModConfig.fertility.outOfSeasonCropBehavior == 0) {
                if (level.m_213780_().m_188503_(6) != 0) {
                    ci.cancel();
                }
            } else if (ModConfig.fertility.outOfSeasonCropBehavior == 1) {
                ci.cancel();
            } else if (ModConfig.fertility.outOfSeasonCropBehavior == 2) {
                if (!state.m_204336_(ModTags.Blocks.UNBREAKABLE_INFERTILE_CROPS)) {
                    level.m_46961_(pos, false);
                }
                ci.cancel();
            }
        }
    }

    public static void applyBonemeal(PlayerInteractEvent.UseBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() != Items.f_42499_) {
            return;
        }
        Player player = event.getPlayer();
        InteractionHand hand = event.getHand();
        Level level = player.m_9236_();
        BlockHitResult hitResult = event.getHitResult();
        BlockPos pos = hitResult.m_82425_();
        BlockState plant = level.m_8055_(pos);
        Block plantBlock = plant.m_60734_();
        Registry blockRegistry = level.m_9598_().m_175515_(Registries.f_256747_);
        if (!ModConfig.fertility.seasonalCrops || !ModFertility.isCrop(plant)) {
            return;
        }
        boolean isFertile = ModFertility.isCropFertile(blockRegistry.m_7981_((Object)plantBlock).toString(), level, pos);
        if (!isFertile && !SeasonalCropGrowthHandler.isGlassAboveBlock(level, pos)) {
            if (ModConfig.fertility.outOfSeasonCropBehavior == 0) {
                if (level.m_213780_().m_188503_(6) != 0) {
                    event.setCancelled(true);
                    event.setCancelResult(InteractionResultHolder.m_19090_((Object)stack));
                }
            } else if (ModConfig.fertility.outOfSeasonCropBehavior == 1) {
                event.setCancelled(true);
                event.setCancelResult(InteractionResultHolder.m_19100_((Object)stack));
            } else if (ModConfig.fertility.outOfSeasonCropBehavior == 2) {
                if (!plant.m_204336_(ModTags.Blocks.UNBREAKABLE_INFERTILE_CROPS)) {
                    level.m_46961_(pos, false);
                    event.setCancelled(true);
                    event.setCancelResult(InteractionResultHolder.m_19090_((Object)stack));
                } else {
                    event.setCancelled(true);
                }
            }
        }
        if (event.isCancelled() && !level.m_5776_()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (stack.m_41619_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
        }
    }

    private static boolean isGlassAboveBlock(Level world, BlockPos cropPos) {
        for (int i = 0; i < 16; ++i) {
            if (!world.m_8055_(cropPos.m_7918_(0, i + 1, 0)).m_204336_(ModTags.Blocks.GREENHOUSE_GLASS)) continue;
            return true;
        }
        return false;
    }
}

