/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.features.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SakuraFoliagePlacer
extends FoliagePlacer {
    public static final Codec<SakuraFoliagePlacer> CODEC = RecordCodecBuilder.create(placer -> SakuraFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)placer).and(placer.group((App)IntProvider.m_146545_((int)4, (int)16).fieldOf("height").forGetter(height -> height.height), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("flower_decoration_chance").forGetter(flowerChance -> Float.valueOf(flowerChance.flowerDecorationChance)))).apply((Applicative)placer, SakuraFoliagePlacer::new));
    private final IntProvider height;
    private final float flowerDecorationChance;
    public static FoliagePlacerType<?> fpt = new FoliagePlacerType(CODEC);

    public SakuraFoliagePlacer(IntProvider ip1, IntProvider ip2, IntProvider height, float flowerDecorationChance) {
        super(ip1, ip2);
        this.height = height;
        this.flowerDecorationChance = flowerDecorationChance;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return fpt;
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfig, int p_272975_, FoliagePlacer.FoliageAttachment foliage, int p_273647_, int p_273700_, int height) {
        BlockPos blockpos = foliage.m_161451_().m_6630_(height);
        if (random.m_188503_(2) == 0) {
            this.placeLeavesBlobLeft(level, setter, random, treeConfig, blockpos);
        } else {
            this.placeLeavesBlobRight(level, setter, random, treeConfig, blockpos);
        }
    }

    public boolean placeLeavesBlobLeft(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        this.placeLeavesTopLeft(level, setter, random, treeConfiguration, pos);
        this.placeLeavesMiddle(level, setter, random, treeConfiguration, pos.m_7494_());
        this.placeLeavesTopLeft(level, setter, random, treeConfiguration, pos.m_7494_().m_7494_());
        return true;
    }

    public boolean placeLeavesBlobRight(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        this.placeLeavesTopRight(level, setter, random, treeConfiguration, pos);
        this.placeLeavesMiddle(level, setter, random, treeConfiguration, pos.m_7494_());
        this.placeLeavesTopRight(level, setter, random, treeConfiguration, pos.m_7494_().m_7494_());
        return true;
    }

    public void placeLeavesMiddle(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_().m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_().m_122029_().m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_().m_122024_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_().m_122024_().m_122024_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_().m_122012_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_().m_122012_().m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_().m_122012_().m_122024_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_().m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_().m_122029_().m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_().m_122024_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_().m_122024_().m_122024_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_().m_122019_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_().m_122019_().m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_().m_122019_().m_122024_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122029_().m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122024_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122024_().m_122024_());
    }

    public void placeLeavesTopLeft(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_().m_122024_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_().m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122029_().m_122012_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122024_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122024_().m_122019_());
    }

    public void placeLeavesTopRight(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos);
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122012_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122019_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122029_());
        SakuraFoliagePlacer.tryPlaceLeaf(level, setter, random, treeConfiguration, pos.m_122024_());
    }

    public int m_214116_(RandomSource p_273679_, int p_273336_, TreeConfiguration p_273643_) {
        return this.height.m_214085_(p_273679_);
    }

    protected boolean m_214203_(RandomSource p_273294_, int p_273380_, int p_272865_, int p_272853_, int p_272631_, boolean p_273432_) {
        return false;
    }

    protected static boolean tryPlaceLeaf(LevelSimulatedReader level, FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration treeConfiguration, BlockPos pos) {
        if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            return false;
        }
        BlockState blockstate = treeConfiguration.f_161213_.m_213972_(random, pos);
        if (blockstate.m_61138_((Property)BlockStateProperties.f_61362_)) {
            blockstate = (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(pos, p_225638_ -> p_225638_.m_164512_((Fluid)Fluids.f_76193_))));
        }
        setter.m_271838_(pos, blockstate);
        return true;
    }
}

