/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.reload;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.json.JsonUtil;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.RegistryCallback;
import dev.shadowsoffire.placebo.reload.ReloadListenerPacket;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public abstract class DynamicRegistry<R extends CodecProvider<? super R>>
extends SimpleJsonResourceReloadListener {
    protected final Logger logger;
    protected final String path;
    protected final boolean synced;
    protected final boolean subtypes;
    protected final CodecMap<R> codecs;
    protected final Codec<DynamicHolder<R>> holderCodec;
    protected BiMap<ResourceLocation, R> registry = ImmutableBiMap.of();
    private final Map<ResourceLocation, R> staged = new HashMap<ResourceLocation, R>();
    private final Map<ResourceLocation, DynamicHolder<? extends R>> holders = new ConcurrentHashMap<ResourceLocation, DynamicHolder<? extends R>>();
    private final Set<RegistryCallback<R>> callbacks = new HashSet<RegistryCallback<R>>();
    private WeakReference<ICondition.IContext> context;

    public DynamicRegistry(Logger logger, String path, boolean synced, boolean subtypes) {
        super(new GsonBuilder().setLenient().create(), path);
        this.logger = logger;
        this.path = path;
        this.synced = synced;
        this.subtypes = subtypes;
        this.codecs = new CodecMap(path);
        this.registerBuiltinCodecs();
        if (this.codecs.isEmpty()) {
            throw new RuntimeException("Attempted to create a dynamic registry for " + path + " with no built-in codecs!");
        }
        this.holderCodec = ResourceLocation.f_135803_.xmap(this::holder, DynamicHolder::getId);
    }

    protected final void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.beginReload();
        objects.forEach((key, ele) -> {
            try {
                if (JsonUtil.checkAndLogEmpty(ele, key, this.path, this.logger) && JsonUtil.checkConditions(ele, key, this.path, this.logger, this.getContext())) {
                    JsonObject obj = ele.getAsJsonObject();
                    CodecProvider deserialized = (CodecProvider)((Pair)this.codecs.decode(JsonOps.INSTANCE, obj).getOrThrow(false, this::logCodecError)).getFirst();
                    Preconditions.checkNotNull(deserialized.getCodec(), (Object)("A " + this.path + " with id " + key + " is not declaring a codec."));
                    Preconditions.checkNotNull((Object)this.codecs.getKey(deserialized.getCodec()), (Object)("A " + this.path + " with id " + key + " is declaring an unregistered codec."));
                    this.register((ResourceLocation)key, (R)deserialized);
                }
            }
            catch (Exception e) {
                this.logger.error("Failed parsing {} file {}.", (Object)this.path, key);
                this.logger.error("Underlying Exception: ", (Throwable)e);
            }
        });
        this.onReload();
    }

    protected abstract void registerBuiltinCodecs();

    protected void beginReload() {
        this.callbacks.forEach(l -> l.beginReload(this));
        this.registry = HashBiMap.create();
        this.holders.values().forEach(DynamicHolder::unbind);
    }

    protected void onReload() {
        this.registry = ImmutableBiMap.copyOf(this.registry);
        this.logger.info("Registered {} {}.", (Object)this.registry.size(), (Object)this.path);
        this.callbacks.forEach(l -> l.onReload(this));
        this.holders.values().forEach(DynamicHolder::bind);
    }

    public Set<ResourceLocation> getKeys() {
        return this.registry.keySet();
    }

    public Collection<R> getValues() {
        return this.registry.values();
    }

    @Nullable
    public R getValue(ResourceLocation key) {
        return (R)((CodecProvider)this.registry.get((Object)key));
    }

    @Nullable
    public ResourceLocation getKey(R value) {
        return (ResourceLocation)this.registry.inverse().get(value);
    }

    public R getOrDefault(ResourceLocation key, R defValue) {
        return (R)((CodecProvider)this.registry.getOrDefault((Object)key, defValue));
    }

    public void registerToBus() {
        if (this.synced) {
            SyncManagement.registerForSync(this);
        }
        MinecraftForge.EVENT_BUS.addListener(this::addReloader);
    }

    public <T extends R> DynamicHolder<T> holder(ResourceLocation id) {
        return this.holders.computeIfAbsent(id, k -> new DynamicHolder(this, (ResourceLocation)k));
    }

    public <T extends R> DynamicHolder<T> holder(T t) {
        ResourceLocation key = this.getKey(t);
        return this.holder((T)(key == null ? DynamicHolder.EMPTY : key));
    }

    public DynamicHolder<R> emptyHolder() {
        return this.holder((Object)DynamicHolder.EMPTY);
    }

    public Codec<DynamicHolder<R>> holderCodec() {
        return this.holderCodec;
    }

    public final void registerCodec(ResourceLocation key, Codec<? extends R> codec) {
        if (!this.subtypes) {
            throw new UnsupportedOperationException("Attempted to call registerCodec on a registry which does not support subtypes.");
        }
        this.codecs.register(key, codec);
    }

    protected final void registerDefaultCodec(ResourceLocation key, Codec<? extends R> codec) {
        if (this.codecs.getDefaultCodec() != null) {
            throw new UnsupportedOperationException("Attempted to register a second " + this.path + " default codec with key " + key + " but subtypes are not supported!");
        }
        this.codecs.register(key, codec);
        this.codecs.setDefaultCodec(codec);
    }

    public final boolean addCallback(RegistryCallback<R> callback) {
        return this.callbacks.add(callback);
    }

    public final boolean removeCallback(RegistryCallback<R> callback) {
        return this.callbacks.remove(callback);
    }

    protected final void register(ResourceLocation key, R value) {
        if (this.registry.containsKey((Object)key)) {
            throw new UnsupportedOperationException("Attempted to register a " + this.path + " with a duplicate registry ID! Key: " + key);
        }
        this.validateItem(key, value);
        this.registry.put((Object)key, value);
        this.holders.computeIfAbsent(key, k -> new DynamicHolder(this, (ResourceLocation)k));
    }

    protected void validateItem(ResourceLocation key, R value) {
    }

    protected final ICondition.IContext getContext() {
        return this.context.get() != null ? (ICondition.IContext)this.context.get() : ICondition.IContext.EMPTY;
    }

    private void addReloader(AddReloadListenerEvent e) {
        e.addListener((PreparableReloadListener)this);
        this.context = new WeakReference<ICondition.IContext>(e.getConditionContext());
    }

    private void pushStagedToLive() {
        this.beginReload();
        this.staged.forEach(this::register);
        this.onReload();
    }

    private void logCodecError(String msg) {
        Placebo.LOGGER.error("Codec failure for type {}, message: {}", (Object)this.path, (Object)msg);
    }

    private void sync(OnDatapackSyncEvent e) {
        ServerPlayer player = e.getPlayer();
        PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
        Placebo.CHANNEL.send(target, (Object)new ReloadListenerPacket.Start(this.path));
        this.registry.forEach((k, v) -> Placebo.CHANNEL.send(target, new ReloadListenerPacket.Content<CodecProvider>(this.path, (ResourceLocation)k, (CodecProvider)v)));
        Placebo.CHANNEL.send(target, (Object)new ReloadListenerPacket.End(this.path));
    }

    @ApiStatus.Internal
    static class SyncManagement {
        private static final Map<String, DynamicRegistry<?>> SYNC_REGISTRY = new LinkedHashMap();

        SyncManagement() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void registerForSync(DynamicRegistry<?> listener) {
            if (!listener.synced) {
                throw new UnsupportedOperationException("Attempted to register the non-synced JSON Reload Listener " + listener.path + " as a synced listener!");
            }
            Map<String, DynamicRegistry<?>> map = SYNC_REGISTRY;
            synchronized (map) {
                if (SYNC_REGISTRY.containsKey(listener.path)) {
                    throw new UnsupportedOperationException("Attempted to register the JSON Reload Listener for syncing " + listener.path + " but one already exists!");
                }
                if (SYNC_REGISTRY.isEmpty()) {
                    MinecraftForge.EVENT_BUS.addListener(SyncManagement::syncAll);
                }
                SYNC_REGISTRY.put(listener.path, listener);
            }
        }

        static void initSync(String path) {
            SyncManagement.ifPresent(path, registry -> registry.staged.clear());
            Placebo.LOGGER.info("Starting sync for {}", (Object)path);
        }

        static <V extends CodecProvider<? super V>> void writeItem(String path, V value, FriendlyByteBuf buf) {
            SyncManagement.ifPresent(path, registry -> {
                CodecMap c = registry.codecs;
                buf.m_130079_((CompoundTag)c.encodeStart((DynamicOps)NbtOps.f_128958_, value).getOrThrow(false, registry::logCodecError));
            });
        }

        static <V> V readItem(String path, FriendlyByteBuf buf) {
            DynamicRegistry<?> registry = SYNC_REGISTRY.get(path);
            if (registry == null) {
                throw new RuntimeException("Received sync packet for unknown registry!");
            }
            CodecMap c = registry.codecs;
            return (V)((Pair)c.decode((DynamicOps)NbtOps.f_128958_, buf.m_130260_()).getOrThrow(false, registry::logCodecError)).getFirst();
        }

        static <V> void acceptItem(String path, ResourceLocation key, V value) {
            SyncManagement.ifPresent(path, registry -> registry.staged.put(key, value));
        }

        static void endSync(String path) {
            if (ServerLifecycleHooks.getCurrentServer() != null) {
                return;
            }
            SyncManagement.ifPresent(path, DynamicRegistry::pushStagedToLive);
        }

        private static void ifPresent(String path, Consumer<DynamicRegistry<?>> consumer) {
            DynamicRegistry<?> value = SYNC_REGISTRY.get(path);
            if (value != null) {
                consumer.accept(value);
            }
        }

        private static void syncAll(OnDatapackSyncEvent e) {
            SYNC_REGISTRY.values().forEach(r -> r.sync(e));
        }
    }
}

