/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.base.ClientAdvancements;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.page.PageEmpty;
import vazkii.patchouli.client.book.page.PageQuest;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;
import vazkii.patchouli.common.util.SerializationUtil;

public final class BookEntry
extends AbstractReadStateHolder
implements Comparable<BookEntry> {
    private final String name;
    private final String flag;
    private final boolean priority;
    private final boolean secret;
    private final boolean readByDefault;
    private final BookPage[] pages;
    @Nullable
    private final ResourceLocation advancement;
    @Nullable
    private final ResourceLocation turnin;
    private final int sortnum;
    private final int entryColor;
    private final Map<String, Integer> extraRecipeMappings;
    private final ResourceLocation id;
    private final Book book;
    @Nullable
    private final String addedBy;
    private final ResourceLocation categoryId;
    private BookCategory category;
    private final BookIcon icon;
    private final List<BookPage> realPages = new ArrayList<BookPage>();
    private final List<ItemStackUtil.StackWrapper> relevantStacks = new LinkedList<ItemStackUtil.StackWrapper>();
    private boolean locked;
    private boolean built;
    private static final List<BookPage> NO_PAGE = ImmutableList.of((Object)new PageEmpty());

    public BookEntry(JsonObject root, ResourceLocation id, Book book, @Nullable String addedBy) {
        this.id = id;
        this.book = book;
        this.addedBy = addedBy;
        String categoryId = GsonHelper.m_13906_((JsonObject)root, (String)"category");
        if (!categoryId.contains(":")) {
            String hint = String.format("`%s:%s`", book.id.m_135827_(), categoryId);
            throw new IllegalArgumentException("`category` must be fully qualified (domain:name). Hint: Try " + hint);
        }
        this.categoryId = new ResourceLocation(categoryId);
        this.name = GsonHelper.m_13906_((JsonObject)root, (String)"name");
        this.flag = GsonHelper.m_13851_((JsonObject)root, (String)"flag", (String)"");
        this.icon = BookIcon.from(GsonHelper.m_13906_((JsonObject)root, (String)"icon"));
        this.priority = GsonHelper.m_13855_((JsonObject)root, (String)"priority", (boolean)false);
        this.secret = GsonHelper.m_13855_((JsonObject)root, (String)"secret", (boolean)false);
        this.readByDefault = GsonHelper.m_13855_((JsonObject)root, (String)"read_by_default", (boolean)false);
        this.advancement = SerializationUtil.getAsResourceLocation(root, "advancement", null);
        this.turnin = SerializationUtil.getAsResourceLocation(root, "turnin", null);
        this.sortnum = GsonHelper.m_13824_((JsonObject)root, (String)"sortnum", (int)0);
        String entryColor = GsonHelper.m_13851_((JsonObject)root, (String)"entry_color", null);
        this.entryColor = entryColor != null ? Integer.parseInt(entryColor, 16) : book.textColor;
        this.pages = (BookPage[])ClientBookRegistry.INSTANCE.gson.fromJson((JsonElement)GsonHelper.m_13933_((JsonObject)root, (String)"pages"), BookPage[].class);
        JsonObject extraRecipeMap = GsonHelper.m_13841_((JsonObject)root, (String)"extra_recipe_mappings", null);
        this.extraRecipeMappings = extraRecipeMap == null ? Collections.emptyMap() : (Map)ClientBookRegistry.INSTANCE.gson.fromJson((JsonElement)extraRecipeMap, new TypeToken<Map<String, Integer>>(){}.getType());
    }

    public MutableComponent getName() {
        return this.book.i18n ? Component.m_237115_((String)this.name) : Component.m_237113_((String)this.name);
    }

    public List<BookPage> getPages() {
        List<BookPage> pages = !this.getBook().advancementsEnabled() ? this.realPages : this.realPages.stream().filter(BookPage::isPageUnlocked).collect(Collectors.toList());
        return pages.isEmpty() ? NO_PAGE : pages;
    }

    public int getPageFromAnchor(String anchor) {
        List<BookPage> pages = this.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            BookPage page = pages.get(i);
            if (!anchor.equals(page.anchor)) continue;
            return i;
        }
        return -1;
    }

    public boolean isPriority() {
        return this.priority;
    }

    public BookIcon getIcon() {
        return this.icon;
    }

    public void initCategory(ResourceLocation file, Function<ResourceLocation, BookCategory> categories) {
        this.category = categories.apply(this.categoryId);
        if (this.category == null) {
            String msg = String.format("Entry in file %s does not have a valid category.", file);
            throw new RuntimeException(msg);
        }
        this.category.addEntry(this);
    }

    public BookCategory getCategory() {
        return this.category;
    }

    public void updateLockStatus() {
        boolean currLocked = this.locked;
        this.locked = this.advancement != null && !ClientAdvancements.hasDone(this.advancement.toString());
        boolean dirty = false;
        if (!this.locked && currLocked) {
            dirty = true;
            this.book.markUpdated();
        }
        if (!dirty && !this.readStateDirty && this.getReadState() == EntryDisplayState.PENDING && ClientAdvancements.hasDone(this.turnin.toString())) {
            dirty = true;
        }
        if (dirty) {
            this.markReadStateDirty();
        }
    }

    public boolean isLocked() {
        if (this.isSecret()) {
            return this.locked;
        }
        return this.getBook().advancementsEnabled() && this.locked;
    }

    public boolean isSecret() {
        return this.secret;
    }

    public boolean shouldHide() {
        return this.isSecret() && this.isLocked();
    }

    public int getEntryColor() {
        return this.entryColor;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public boolean canAdd() {
        return this.flag.isEmpty() || PatchouliConfig.getConfigFlag(this.flag);
    }

    public boolean isFoundByQuery(String query) {
        if (this.getName().getString().toLowerCase().contains(query)) {
            return true;
        }
        for (ItemStackUtil.StackWrapper wrapper : this.relevantStacks) {
            if (!wrapper.stack.m_41786_().getString().toLowerCase().contains(query)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(BookEntry o) {
        EntryDisplayState otherState;
        if (o.locked != this.locked) {
            return this.locked ? 1 : -1;
        }
        EntryDisplayState ourState = this.getReadState();
        if (ourState != (otherState = o.getReadState())) {
            return ourState.compareTo(otherState);
        }
        if (o.priority != this.priority) {
            return this.priority ? -1 : 1;
        }
        int sort = this.sortnum - o.sortnum;
        return sort == 0 ? this.getName().getString().compareTo(o.getName().getString()) : sort;
    }

    public void build(Level level, BookContentsBuilder builder) {
        if (this.built) {
            return;
        }
        for (int i = 0; i < this.pages.length; ++i) {
            if (!this.pages[i].canAdd(this.book)) continue;
            try {
                this.pages[i].build(level, this, builder, i);
                this.realPages.add(this.pages[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while building entry %s page %d of book %s".formatted(this.id, i, this.book.id), e);
            }
        }
        if (this.extraRecipeMappings != null) {
            for (Map.Entry<String, Integer> entry : this.extraRecipeMappings.entrySet()) {
                List<ItemStack> stacks;
                String key = entry.getKey();
                int pageNumber = entry.getValue();
                try {
                    stacks = ItemStackUtil.loadStackListFromString(key);
                }
                catch (Exception e) {
                    PatchouliAPI.LOGGER.warn("Invalid extra recipe mapping: {} to page {} in entry {}: {}", (Object)key, (Object)pageNumber, (Object)this.id, (Object)e.getMessage());
                    continue;
                }
                if (!stacks.isEmpty() && pageNumber < this.pages.length) {
                    for (ItemStack stack : stacks) {
                        this.addRelevantStack(builder, stack, pageNumber);
                    }
                    continue;
                }
                PatchouliAPI.LOGGER.warn("Invalid extra recipe mapping: {} to page {} in entry {}: Empty entry or page out of bounds", (Object)key, (Object)pageNumber, (Object)this.id);
            }
        }
        this.built = true;
    }

    public void addRelevantStack(BookContentsBuilder builder, ItemStack stack, int page) {
        if (stack.m_41619_()) {
            return;
        }
        ItemStackUtil.StackWrapper wrapper = ItemStackUtil.wrapStack(stack);
        this.relevantStacks.add(wrapper);
        builder.addRecipeMapping(wrapper, this, page / 2);
    }

    public Book getBook() {
        return this.book;
    }

    @Nullable
    public String getAddedBy() {
        return this.addedBy;
    }

    @Override
    protected EntryDisplayState computeReadState() {
        PersistentData.BookData data = PersistentData.data.getBookData(this.book);
        if (!(data == null || this.getId() == null || this.readByDefault || this.isLocked() || data.viewedEntries.contains(this.getId()))) {
            return EntryDisplayState.UNREAD;
        }
        if (this.turnin != null && !ClientAdvancements.hasDone(this.turnin.toString())) {
            return EntryDisplayState.PENDING;
        }
        for (BookPage page : this.pages) {
            if (!(page instanceof PageQuest) || !((PageQuest)page).isCompleted(this.book)) continue;
            return EntryDisplayState.COMPLETED;
        }
        return EntryDisplayState.NEUTRAL;
    }

    @Override
    public void markReadStateDirty() {
        super.markReadStateDirty();
        this.getCategory().markReadStateDirty();
    }
}

