/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.vessel;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.Copy;
import tictim.paraglider.api.Serde;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.config.Cfg;

public class SimpleVesselContainer
implements VesselContainer,
Serde,
Copy {
    protected final Player player;
    protected int heartContainer;
    protected int staminaVessel;
    protected int essence;

    public SimpleVesselContainer(@Nullable Player player) {
        this.player = player;
    }

    @Override
    public final int heartContainer() {
        return this.heartContainer;
    }

    @Override
    public final int staminaVessel() {
        return this.staminaVessel;
    }

    @Override
    public final int essence() {
        return this.essence;
    }

    @Override
    @NotNull
    public VesselContainer.SetResult setHeartContainer(int amount, boolean simulate, boolean playEffect) {
        if (amount < 0) {
            return VesselContainer.SetResult.TOO_LOW;
        }
        if (amount > Cfg.get().maxHeartContainers()) {
            return VesselContainer.SetResult.TOO_HIGH;
        }
        int change = amount - this.heartContainer;
        if (change == 0) {
            return VesselContainer.SetResult.NO_CHANGE;
        }
        if (!simulate) {
            this.heartContainer = amount;
            this.onChange(ActionType.HEART_CONTAINER, change);
            if (playEffect) {
                this.playEffect(ActionType.HEART_CONTAINER, change);
            }
        }
        return VesselContainer.SetResult.OK;
    }

    @Override
    @NotNull
    public VesselContainer.SetResult setStaminaVessel(int amount, boolean simulate, boolean playEffect) {
        if (amount < 0) {
            return VesselContainer.SetResult.TOO_LOW;
        }
        if (amount > Cfg.get().maxStaminaVessels()) {
            return VesselContainer.SetResult.TOO_HIGH;
        }
        int change = amount - this.staminaVessel;
        if (change == 0) {
            return VesselContainer.SetResult.NO_CHANGE;
        }
        if (!simulate) {
            this.staminaVessel = amount;
            this.onChange(ActionType.STAMINA_VESSEL, change);
            if (playEffect) {
                this.playEffect(ActionType.STAMINA_VESSEL, change);
            }
        }
        return VesselContainer.SetResult.OK;
    }

    @Override
    @NotNull
    public VesselContainer.SetResult setEssence(int amount, boolean simulate, boolean playEffect) {
        if (amount < 0) {
            return VesselContainer.SetResult.TOO_LOW;
        }
        int change = amount - this.essence;
        if (change == 0) {
            return VesselContainer.SetResult.NO_CHANGE;
        }
        if (!simulate) {
            this.essence = amount;
            this.onChange(ActionType.ESSENCE, change);
            if (playEffect) {
                this.playEffect(ActionType.ESSENCE, change);
            }
        }
        return VesselContainer.SetResult.OK;
    }

    @Override
    public int giveHeartContainers(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, Cfg.get().maxHeartContainers() - this.heartContainer)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.heartContainer += amount;
            this.onChange(ActionType.HEART_CONTAINER, amount);
            if (playEffect) {
                this.playEffect(ActionType.HEART_CONTAINER, amount);
            }
        }
        return amount;
    }

    @Override
    public int giveStaminaVessels(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, Cfg.get().maxStaminaVessels() - this.staminaVessel)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.staminaVessel += amount;
            this.onChange(ActionType.STAMINA_VESSEL, amount);
            if (playEffect) {
                this.playEffect(ActionType.STAMINA_VESSEL, amount);
            }
        }
        return amount;
    }

    @Override
    public int giveEssences(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, Integer.MAX_VALUE - this.essence)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.essence += amount;
            this.onChange(ActionType.ESSENCE, amount);
            if (playEffect) {
                this.playEffect(ActionType.ESSENCE, amount);
            }
        }
        return amount;
    }

    @Override
    public int takeHeartContainers(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, this.heartContainer)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.heartContainer -= amount;
            this.onChange(ActionType.HEART_CONTAINER, -amount);
            if (playEffect) {
                this.playEffect(ActionType.HEART_CONTAINER, -amount);
            }
        }
        return amount;
    }

    @Override
    public int takeStaminaVessels(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, this.staminaVessel)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.staminaVessel -= amount;
            this.onChange(ActionType.STAMINA_VESSEL, -amount);
            if (playEffect) {
                this.playEffect(ActionType.STAMINA_VESSEL, -amount);
            }
        }
        return amount;
    }

    @Override
    public int takeEssences(int amount, boolean simulate, boolean playEffect) {
        if ((amount = Math.min(amount, this.essence)) <= 0) {
            return 0;
        }
        if (!simulate) {
            this.essence -= amount;
            this.onChange(ActionType.ESSENCE, -amount);
            if (playEffect) {
                this.playEffect(ActionType.ESSENCE, -amount);
            }
        }
        return amount;
    }

    @Override
    public void copyFrom(@NotNull Object from) {
        if (!(from instanceof VesselContainer)) {
            return;
        }
        VesselContainer vessels = (VesselContainer)from;
        this.setHeartContainer(vessels.heartContainer(), false, false);
        this.setStaminaVessel(vessels.staminaVessel(), false, false);
        this.setEssence(vessels.essence(), false, false);
    }

    protected void onChange(@NotNull ActionType actionType, int change) {
    }

    protected void playEffect(@NotNull ActionType actionType, int change) {
        if (change > 0) {
            switch (actionType) {
                case HEART_CONTAINER: {
                    this.spawnParticle((ParticleOptions)ParticleTypes.f_123750_, 5 + 5 * change);
                    break;
                }
                case STAMINA_VESSEL: {
                    this.spawnParticle((ParticleOptions)ParticleTypes.f_123748_, 7 + 7 * change);
                }
            }
        }
    }

    protected void spawnParticle(@NotNull ParticleOptions particle, int count) {
        Level level;
        if (this.player != null && (level = this.player.m_9236_()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            sl.m_8767_(particle, this.player.m_20185_(), this.player.m_20227_(0.5), this.player.m_20189_(), count, 1.0, 2.0, 1.0, 0.0);
        }
    }

    @Override
    @NotNull
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("heartContainers", this.heartContainer);
        tag.m_128405_("staminaVessels", this.staminaVessel);
        tag.m_128405_("essences", this.essence);
        return tag;
    }

    @Override
    public void read(@NotNull CompoundTag tag) {
        this.heartContainer = tag.m_128451_("heartContainers");
        this.staminaVessel = tag.m_128451_("staminaVessels");
        this.essence = tag.m_128451_("essences");
    }

    public String toString() {
        return "SimpleVesselContainer{heartContainer=" + this.heartContainer + ", staminaVessel=" + this.staminaVessel + ", essence=" + this.essence + "}";
    }

    public static enum ActionType {
        HEART_CONTAINER,
        STAMINA_VESSEL,
        ESSENCE;

    }
}

