/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge.contents;

import com.mojang.serialization.Codec;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.contents.CommonContents;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.block.GoddessStatueBlock;
import tictim.paraglider.contents.block.HornedStatueBlock;
import tictim.paraglider.contents.item.AntiVesselItem;
import tictim.paraglider.contents.item.EssenceItem;
import tictim.paraglider.contents.item.HeartContainerItem;
import tictim.paraglider.contents.item.ParagliderItem;
import tictim.paraglider.contents.item.SpiritOrbItem;
import tictim.paraglider.contents.item.StaminaVesselItem;
import tictim.paraglider.contents.recipe.CosmeticRecipe;
import tictim.paraglider.contents.recipe.SimpleBargainSerializer;
import tictim.paraglider.contents.worldgen.NetherHornedStatue;
import tictim.paraglider.contents.worldgen.TarreyTownGoddessStatue;
import tictim.paraglider.contents.worldgen.UndergroundHornedStatue;
import tictim.paraglider.forge.contents.item.ForgeParagliderItem;
import tictim.paraglider.forge.contents.loot.LootConditions;
import tictim.paraglider.forge.contents.loot.ParagliderLoot;
import tictim.paraglider.forge.contents.loot.SpawnerSpiritOrbLoot;
import tictim.paraglider.forge.contents.loot.SpiritOrbLoot;
import tictim.paraglider.forge.contents.loot.VesselLoot;

public final class ForgeContents
implements Contents {
    private final DeferredRegister<Block> blocks = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"paraglider");
    private final DeferredRegister<Item> items = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"paraglider");
    private final DeferredRegister<RecipeSerializer<?>> recipeSerializers = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"paraglider");
    private final DeferredRegister<RecipeType<?>> recipeTypes = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"paraglider");
    private final DeferredRegister<Attribute> attributes = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"paraglider");
    private final DeferredRegister<Codec<? extends IGlobalLootModifier>> loots = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"paraglider");
    private final DeferredRegister<LootItemConditionType> lootConditions = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"paraglider");
    private final DeferredRegister<StructureType<?>> structureTypes = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"paraglider");
    private final DeferredRegister<StructurePieceType> pieces = DeferredRegister.create((ResourceKey)Registries.f_256786_, (String)"paraglider");
    private final DeferredRegister<CreativeModeTab> creativeTabs = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"paraglider");
    private final RegistryObject<Block> goddessStatue = this.blocks.register("goddess_statue", () -> new GoddessStatueBlock(CommonContents.statueBlock()));
    private final RegistryObject<Block> kakarikoGoddessStatue = this.blocks.register("kakariko_goddess_statue", () -> new GoddessStatueBlock(CommonContents.statueBlock(), CommonContents.kakarikoStatueTooltip()));
    private final RegistryObject<Block> goronGoddessStatue = this.blocks.register("goron_goddess_statue", () -> new GoddessStatueBlock(CommonContents.statueBlock().m_60953_(value -> 15), CommonContents.goronStatueTooltip()));
    private final RegistryObject<Block> ritoGoddessStatue = this.blocks.register("rito_goddess_statue", () -> new GoddessStatueBlock(CommonContents.statueBlock(), CommonContents.ritoStatueTooltip()));
    private final RegistryObject<Block> hornedStatue = this.blocks.register("horned_statue", () -> new HornedStatueBlock(CommonContents.statueBlock()));
    private final RegistryObject<ParagliderItem> paraglider = this.items.register("paraglider", () -> new ForgeParagliderItem(10901845));
    private final RegistryObject<ParagliderItem> dekuLeaf = this.items.register("deku_leaf", () -> new ForgeParagliderItem(4175167));
    private final RegistryObject<Item> heartContainer = this.items.register("heart_container", () -> new HeartContainerItem(CommonContents.rareItem()));
    private final RegistryObject<Item> staminaVessel = this.items.register("stamina_vessel", () -> new StaminaVesselItem(CommonContents.rareItem()));
    private final RegistryObject<Item> spiritOrb = this.items.register("spirit_orb", () -> new SpiritOrbItem(CommonContents.uncommonItem()));
    private final RegistryObject<Item> antiVessel = this.items.register("anti_vessel", () -> new AntiVesselItem(CommonContents.epicItem()));
    private final RegistryObject<Item> essence = this.items.register("essence", () -> new EssenceItem(CommonContents.rareItem()));
    private final RegistryObject<BlockItem> goddessStatueItem = this.items.register("goddess_statue", () -> new BlockItem((Block)this.goddessStatue.get(), CommonContents.rareItem()));
    private final RegistryObject<BlockItem> kakarikoGoddessStatueItem = this.items.register("kakariko_goddess_statue", () -> new BlockItem((Block)this.kakarikoGoddessStatue.get(), CommonContents.rareItem()));
    private final RegistryObject<BlockItem> goronGoddessStatueItem = this.items.register("goron_goddess_statue", () -> new BlockItem((Block)this.goronGoddessStatue.get(), CommonContents.rareItem()));
    private final RegistryObject<BlockItem> ritoGoddessStatueItem = this.items.register("rito_goddess_statue", () -> new BlockItem((Block)this.ritoGoddessStatue.get(), CommonContents.rareItem()));
    private final RegistryObject<BlockItem> hornedStatueItem = this.items.register("horned_statue", () -> new BlockItem((Block)this.hornedStatue.get(), CommonContents.epicItem()));
    private final RegistryObject<CosmeticRecipe.Serializer> cosmeticRecipe = this.recipeSerializers.register("cosmetic", CosmeticRecipe.Serializer::new);
    private final RegistryObject<SimpleBargainSerializer.Simple> bargainRecipe = this.recipeSerializers.register("statue_bargain", SimpleBargainSerializer.Simple::new);
    private final RegistryObject<RecipeType<Bargain>> bargainRecipeType = this.recipeTypes.register("bargain", () -> RecipeType.simple((ResourceLocation)ParagliderAPI.id("bargain")));
    private final RegistryObject<Codec<ParagliderLoot>> paragliderLoot = this.loots.register("paraglider", () -> ParagliderLoot.CODEC);
    private final RegistryObject<Codec<SpiritOrbLoot>> spiritOrbLoot = this.loots.register("spirit_orb", () -> SpiritOrbLoot.CODEC);
    private final RegistryObject<Codec<VesselLoot>> vesselLoot = this.loots.register("vessel", () -> VesselLoot.CODEC);
    private final RegistryObject<Codec<SpawnerSpiritOrbLoot>> spawnerSpiritOrbLoot = this.loots.register("spawner_spirit_orb", () -> SpawnerSpiritOrbLoot.CODEC);
    public final RegistryObject<LootItemConditionType> witherDropsVesselConfigCondition = this.lootConditions.register("config_wither_drops_vessel", () -> new LootItemConditionType((Serializer)LootConditions.WITHER_DROPS_VESSEL));
    public final RegistryObject<LootItemConditionType> spiritOrbLootsConfigCondition = this.lootConditions.register("config_spirit_orb_loots", () -> new LootItemConditionType((Serializer)LootConditions.SPIRIT_ORB_LOOTS));
    private final RegistryObject<StructureType<TarreyTownGoddessStatue>> tarreyTownGoddessStatue = this.structureType("tarrey_town_goddess_statue", TarreyTownGoddessStatue.CODEC);
    private final RegistryObject<StructureType<NetherHornedStatue>> netherHornedStatue = this.structureType("nether_horned_statue", NetherHornedStatue.CODEC);
    private final RegistryObject<StructureType<UndergroundHornedStatue>> undergroundHornedStatue = this.structureType("underground_horned_statue", UndergroundHornedStatue.CODEC);
    private final RegistryObject<StructurePieceType> tarreyTownGoddessStatuePiece = this.pieces.register("tarrey_town_goddess_statue", TarreyTownGoddessStatue::pieceType);
    private final RegistryObject<StructurePieceType> netherHornedStatuePiece = this.pieces.register("nether_horned_statue", NetherHornedStatue::pieceType);
    private final RegistryObject<StructurePieceType> undergroundHornedStatuePiece = this.pieces.register("underground_horned_statue", UndergroundHornedStatue::pieceType);
    private final RegistryObject<CreativeModeTab> tab = this.creativeTabs.register("paraglider", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)this.paraglider.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.paraglider")).m_257501_((features, out) -> {
        out.m_246326_((ItemLike)this.paraglider.get());
        out.m_246326_((ItemLike)this.dekuLeaf.get());
        out.m_246326_((ItemLike)this.heartContainer.get());
        out.m_246326_((ItemLike)this.staminaVessel.get());
        out.m_246326_((ItemLike)this.spiritOrb.get());
        out.m_246326_((ItemLike)this.antiVessel.get());
        out.m_246326_((ItemLike)this.essence.get());
        out.m_246326_((ItemLike)this.goddessStatue.get());
        out.m_246326_((ItemLike)this.kakarikoGoddessStatue.get());
        out.m_246326_((ItemLike)this.goronGoddessStatue.get());
        out.m_246326_((ItemLike)this.ritoGoddessStatue.get());
        out.m_246326_((ItemLike)this.hornedStatue.get());
    }).m_257652_());

    public ForgeContents() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.blocks.register(eventBus);
        this.items.register(eventBus);
        this.loots.register(eventBus);
        this.lootConditions.register(eventBus);
        this.recipeSerializers.register(eventBus);
        this.attributes.register(eventBus);
        this.recipeTypes.register(eventBus);
        this.structureTypes.register(eventBus);
        this.pieces.register(eventBus);
        this.creativeTabs.register(eventBus);
    }

    private <T extends Structure> RegistryObject<StructureType<T>> structureType(String id, Codec<T> codec) {
        return this.structureTypes.register(id, () -> () -> codec);
    }

    @NotNull
    public DeferredRegister<Block> blocks() {
        return this.blocks;
    }

    @Override
    @NotNull
    public ParagliderItem paraglider() {
        return (ParagliderItem)this.paraglider.get();
    }

    @Override
    @NotNull
    public ParagliderItem dekuLeaf() {
        return (ParagliderItem)this.dekuLeaf.get();
    }

    @Override
    @NotNull
    public Item heartContainer() {
        return (Item)this.heartContainer.get();
    }

    @Override
    @NotNull
    public Item staminaVessel() {
        return (Item)this.staminaVessel.get();
    }

    @Override
    @NotNull
    public Item spiritOrb() {
        return (Item)this.spiritOrb.get();
    }

    @Override
    @NotNull
    public Item antiVessel() {
        return (Item)this.antiVessel.get();
    }

    @Override
    @NotNull
    public Item essence() {
        return (Item)this.essence.get();
    }

    @Override
    @NotNull
    public Block goddessStatue() {
        return (Block)this.goddessStatue.get();
    }

    @Override
    @NotNull
    public Block kakarikoGoddessStatue() {
        return (Block)this.kakarikoGoddessStatue.get();
    }

    @Override
    @NotNull
    public Block goronGoddessStatue() {
        return (Block)this.goronGoddessStatue.get();
    }

    @Override
    @NotNull
    public Block ritoGoddessStatue() {
        return (Block)this.ritoGoddessStatue.get();
    }

    @Override
    @NotNull
    public Block hornedStatue() {
        return (Block)this.hornedStatue.get();
    }

    @Override
    @NotNull
    public BlockItem goddessStatueItem() {
        return (BlockItem)this.goddessStatueItem.get();
    }

    @Override
    @NotNull
    public BlockItem kakarikoGoddessStatueItem() {
        return (BlockItem)this.kakarikoGoddessStatueItem.get();
    }

    @Override
    @NotNull
    public BlockItem goronGoddessStatueItem() {
        return (BlockItem)this.goronGoddessStatueItem.get();
    }

    @Override
    @NotNull
    public BlockItem ritoGoddessStatueItem() {
        return (BlockItem)this.ritoGoddessStatueItem.get();
    }

    @Override
    @NotNull
    public BlockItem hornedStatueItem() {
        return (BlockItem)this.hornedStatueItem.get();
    }

    @Override
    @NotNull
    public CosmeticRecipe.Serializer cosmeticRecipeSerializer() {
        return (CosmeticRecipe.Serializer)this.cosmeticRecipe.get();
    }

    @Override
    @NotNull
    public RecipeSerializer<? extends Bargain> bargainRecipeSerializer() {
        return (RecipeSerializer)this.bargainRecipe.get();
    }

    @Override
    @NotNull
    public RecipeType<Bargain> bargainRecipeType() {
        return (RecipeType)this.bargainRecipeType.get();
    }

    @Override
    @NotNull
    public StructureType<TarreyTownGoddessStatue> tarreyTownGoddessStatue() {
        return (StructureType)this.tarreyTownGoddessStatue.get();
    }

    @Override
    @NotNull
    public StructureType<NetherHornedStatue> netherHornedStatue() {
        return (StructureType)this.netherHornedStatue.get();
    }

    @Override
    @NotNull
    public StructureType<UndergroundHornedStatue> undergroundHornedStatue() {
        return (StructureType)this.undergroundHornedStatue.get();
    }

    @Override
    @NotNull
    public StructurePieceType tarreyTownGoddessStatuePiece() {
        return (StructurePieceType)this.tarreyTownGoddessStatuePiece.get();
    }

    @Override
    @NotNull
    public StructurePieceType netherHornedStatuePiece() {
        return (StructurePieceType)this.netherHornedStatuePiece.get();
    }

    @Override
    @NotNull
    public StructurePieceType undergroundHornedStatuePiece() {
        return (StructurePieceType)this.undergroundHornedStatuePiece.get();
    }
}

