/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.contents.Contents;

public class CosmeticRecipe
implements CraftingRecipe {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient input;
    protected final Ingredient reagent;
    protected final Item recipeOut;

    public CosmeticRecipe(@NotNull ResourceLocation id, @NotNull String group, @NotNull Ingredient input, @NotNull Ingredient reagent, @NotNull Item recipeOut) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.reagent = reagent;
        this.recipeOut = recipeOut;
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level level) {
        boolean paragliderSeen = false;
        boolean reagentSeen = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.reagent.test(stack)) {
                if (reagentSeen) {
                    return false;
                }
                reagentSeen = true;
                continue;
            }
            if (this.input.test(stack) && stack.m_41720_() != this.recipeOut) {
                if (paragliderSeen) {
                    return false;
                }
                paragliderSeen = true;
                continue;
            }
            return false;
        }
        return paragliderSeen && reagentSeen;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        ItemStack paraglider = new ItemStack((ItemLike)this.recipeOut);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || this.reagent.test(stack) || !this.input.test(stack)) continue;
            if (stack.m_41782_()) {
                paraglider.m_41751_(stack.m_41783_());
            }
            return paraglider;
        }
        return paraglider;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)this.recipeOut);
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (this.reagent.test(stack)) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                list.set(i, (Object)copy);
                continue;
            }
            int i0 = i;
            ParagliderUtils.forRemainingItem(stack, rem -> list.set(i0, rem));
        }
        return list;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)Ingredient.m_43927_((ItemStack[])((ItemStack[])Arrays.stream(this.input.m_43908_()).filter(it -> it.m_41720_() != this.recipeOut).toArray(ItemStack[]::new))));
        list.add((Object)this.reagent);
        return list;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Contents.get().cosmeticRecipeSerializer();
    }

    @NotNull
    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    public static class Serializer
    implements RecipeSerializer<CosmeticRecipe> {
        @NotNull
        public CosmeticRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            ResourceLocation itemName = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"result"));
            Item item = ParagliderUtils.getItem(itemName);
            if (item == Items.f_41852_) {
                throw new JsonSyntaxException("Unknown item '" + group + "'");
            }
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            Ingredient reagent = Ingredient.m_43917_((JsonElement)json.get("reagent"));
            return new CosmeticRecipe(recipeId, group, input, reagent, item);
        }

        @NotNull
        public CosmeticRecipe fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient reagent = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Item out = Item.m_41445_((int)buffer.m_130242_());
            return new CosmeticRecipe(recipeId, group, input, reagent, out);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull CosmeticRecipe recipe) {
            buffer.m_130070_(recipe.group);
            recipe.input.m_43923_(buffer);
            recipe.reagent.m_43923_(buffer);
            buffer.m_130130_(Item.m_41393_((Item)recipe.recipeOut));
        }
    }
}

