/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.DemandPreview;
import tictim.paraglider.api.bargain.OfferPreview;
import tictim.paraglider.bargain.BargainCatalog;
import tictim.paraglider.client.render.BargainScreenStaminaWheelRenderer;
import tictim.paraglider.client.render.StaminaWheelRenderer;
import tictim.paraglider.client.screen.DisableStaminaRender;
import tictim.paraglider.network.ParagliderNetwork;

public class BargainScreen
extends Screen
implements DisableStaminaRender {
    private static final ResourceLocation MERCHANT_GUI_TEXTURE = new ResourceLocation("textures/gui/container/villager2.png");
    private static final long ITEM_CYCLE_TIME = 1000L;
    private static final long DIALOG_FADEOUT_START = 1750L;
    private static final long DIALOG_FADEOUT_END = 2000L;
    private static final int SCROLL_BOX_THING_WIDTH = 97;
    private static final int SCROLL_BOX_THING_HEIGHT = 142;
    public final int sessionId;
    private final BargainButton[] buttons = new BargainButton[7];
    private Map<ResourceLocation, BargainCatalog> catalog;
    private List<Pair<BargainCatalog, Bargain>> catalogByOrder;
    private int buttonIndexOffset;
    private boolean isDragging;
    private long createdTime;
    private long currentTickTimestamp;
    @Nullable
    private Vec3 lookAt;
    @Nullable
    private Component dialog;
    private long dialogTimestamp;
    private boolean dialogUpdated;
    private StaminaWheelRenderer staminaWheelRenderer;
    private static final int BUTTON_INPUT_X_OFFSET_START = 2;
    private static final int BUTTON_INPUT_X_OFFSET_END = 22;
    private static final int BUTTON_OUTPUT_X_OFFSET_START = 50;
    private static final int BUTTON_OUTPUT_X_OFFSET_END = 70;

    public static int getDialogAlpha(long elapsedTime) {
        if (elapsedTime >= 2000L) {
            return 0;
        }
        if (elapsedTime <= 1750L) {
            return 255;
        }
        int alpha = Mth.m_14045_((int)((int)((2000L - elapsedTime) * 255L / 250L)), (int)0, (int)255);
        return alpha > 4 ? alpha : 0;
    }

    public BargainScreen(int sessionId, @NotNull Map<ResourceLocation, BargainCatalog> catalog, @Nullable Vec3 lookAt, @Nullable Component dialog) {
        super((Component)Component.m_237119_());
        this.sessionId = sessionId;
        this.setCatalog(catalog);
        this.setLookAt(lookAt);
        this.setDialog(dialog);
    }

    public void setCatalog(@NotNull Map<ResourceLocation, BargainCatalog> catalog) {
        this.catalog = catalog;
        this.catalogByOrder = catalog.values().stream().sorted(Comparator.comparing(BargainCatalog::bargain)).map(key -> Pair.of((Object)key, (Object)BargainScreen.getBargain(key.bargain()))).toList();
    }

    @Nullable
    private static Bargain getBargain(ResourceLocation id) {
        Bargain b;
        Object t;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        RecipeManager recipeManager = mc.f_91073_.m_7465_();
        Optional optionalRecipe = recipeManager.m_44043_(id);
        return optionalRecipe.isPresent() && (t = optionalRecipe.get()) instanceof Bargain ? (b = (Bargain)t) : null;
    }

    public void setLookAt(@Nullable Vec3 lookAt) {
        this.lookAt = lookAt;
    }

    public void setDialog(@Nullable Component dialog) {
        this.dialog = dialog;
        this.dialogUpdated = dialog != null;
    }

    protected void m_7856_() {
        this.currentTickTimestamp = this.createdTime = ParagliderUtils.ms();
        this.staminaWheelRenderer = new BargainScreenStaminaWheelRenderer();
        super.m_7856_();
        int y = this.getTop() + 1;
        for (int i = 0; i < 7; ++i) {
            this.buttons[i] = (BargainButton)this.m_142416_((GuiEventListener)new BargainButton(31, y + 20 * i, i));
        }
    }

    public int getLeft() {
        return 30;
    }

    public int getTop() {
        return (this.f_96544_ - 142) / 2;
    }

    public int getBottom() {
        return this.getTop() + 142;
    }

    private void renderScroller(GuiGraphics guiGraphics, int left, int top) {
        int yOffset;
        int offScreenBargains = this.catalog.size() + 1 - 7;
        if (offScreenBargains > 1) {
            int j = 139 - (27 + (offScreenBargains - 1) * 139 / offScreenBargains);
            int k = 1 + j / offScreenBargains + 139 / offScreenBargains;
            yOffset = Math.min(113, this.buttonIndexOffset * k);
            if (this.buttonIndexOffset == offScreenBargains - 1) {
                yOffset = 113;
            }
        } else {
            yOffset = 0;
        }
        guiGraphics.m_280398_(MERCHANT_GUI_TEXTURE, left + 90, top + 1 + yOffset, 0, 0.0f, 199.0f, 6, 27, 512, 256);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        long newTimestamp = ParagliderUtils.ms();
        if (BargainScreen.m_96638_()) {
            this.createdTime += newTimestamp - this.currentTickTimestamp;
        }
        this.currentTickTimestamp = newTimestamp;
        this.renderBg(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        for (BargainButton button : this.buttons) {
            button.renderToolTip(guiGraphics, mouseX, mouseY);
        }
        this.processLookAt(partialTicks);
    }

    protected void renderBg(GuiGraphics guiGraphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280163_(MERCHANT_GUI_TEXTURE, this.getLeft(), this.getTop(), 4.0f, 17.0f, 97, 142, 512, 256);
        this.staminaWheelRenderer.renderStamina(guiGraphics, this.getLeft() + 97 + 5, this.getTop() - 5 - 10, 0.0);
        if (this.dialog != null) {
            int alpha;
            if (this.dialogUpdated) {
                this.dialogTimestamp = this.currentTickTimestamp;
                this.dialogUpdated = false;
            }
            if ((alpha = BargainScreen.getDialogAlpha(this.currentTickTimestamp - this.dialogTimestamp)) > 0) {
                guiGraphics.m_280653_(this.f_96547_, this.dialog, this.f_96543_ / 2, this.getBottom() + 9, alpha << 24 | 0xFFFFFF);
            }
        }
        if (!this.catalog.isEmpty()) {
            this.renderScroller(guiGraphics, this.getLeft(), this.getTop());
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            for (BargainButton button : this.buttons) {
                button.renderItems(guiGraphics);
            }
            guiGraphics.m_280168_().m_85849_();
            for (BargainButton button : this.buttons) {
                if (button.m_274382_()) {
                    this.renderPreview(guiGraphics, button.actualIndex());
                }
                button.f_93624_ = button.index < this.catalog.size();
            }
            RenderSystem.enableDepthTest();
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        if (this.f_96541_.f_91073_ != null) {
            guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, 0x70101010, -1609560048);
        } else {
            this.m_280039_(guiGraphics);
        }
    }

    @Nullable
    private Pair<BargainCatalog, Bargain> getBargain(int bargainIndex) {
        return bargainIndex < 0 || bargainIndex >= this.catalogByOrder.size() ? null : this.catalogByOrder.get(bargainIndex);
    }

    private void renderPreview(GuiGraphics guiGraphics, int bargainIndex) {
        int textMag;
        Pair<BargainCatalog, Bargain> pair = this.getBargain(bargainIndex);
        if (pair == null) {
            return;
        }
        Bargain bargain = (Bargain)pair.getSecond();
        if (bargain == null) {
            BargainCatalog catalog = (BargainCatalog)pair.getFirst();
            int left = this.getLeft() + 97 + 20;
            int top = this.getTop();
            guiGraphics.m_280488_(this.f_96547_, catalog.bargain().toString(), left, top, 0xFF0000);
            return;
        }
        List<DemandPreview> demands = bargain.previewDemands();
        if (demands.isEmpty()) {
            return;
        }
        BargainCatalog catalog = (BargainCatalog)pair.getFirst();
        int mag = demands.size() <= 2 ? 8 : (demands.size() <= 8 ? 4 : 2);
        int n = textMag = demands.size() <= 8 ? 2 : 1;
        int rows = demands.size() <= 2 ? 2 : (demands.size() <= 8 ? 4 : 8);
        int left = this.getLeft() + 97 + 20;
        int top = this.getTop();
        for (int i = 0; i < demands.size(); ++i) {
            DemandPreview demand = demands.get(i);
            int xOff = left + i % rows * (16 * mag);
            int yOff = top + i / rows * (16 * mag);
            PoseStack modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.m_85836_();
            modelViewStack.m_252880_((float)xOff, (float)yOff, 0.0f);
            modelViewStack.m_85841_((float)mag, (float)mag, 1.0f);
            RenderSystem.applyModelViewMatrix();
            guiGraphics.m_280203_(this.cycle(demand.preview()), 0, 0);
            modelViewStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
            int count = catalog.getCount(i);
            String s = (Serializable)(count >= demand.quantity() ? Integer.valueOf(count) : "" + ChatFormatting.RED + count + ChatFormatting.RESET) + "/" + demand.quantity();
            PoseStack pose = new PoseStack();
            pose.m_252880_((float)xOff, (float)yOff, 0.0f);
            pose.m_252880_((float)(15 * mag + 2 * textMag), (float)(16 * mag - 7 * textMag), 200.0f);
            pose.m_85841_((float)textMag, (float)textMag, 1.0f);
            this.f_96547_.m_271703_(s, (float)(-this.f_96547_.m_92895_(s)), 0.0f, -1, true, pose.m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            guiGraphics.m_280262_();
        }
    }

    private void processLookAt(float partialTicks) {
        if (this.lookAt == null) {
            return;
        }
        LocalPlayer player = this.f_96541_.f_91074_;
        Vec3 eyePosition = player.m_20299_(partialTicks);
        double lookX = this.lookAt.m_7096_() - eyePosition.f_82479_;
        double lookY = this.lookAt.m_7098_() - eyePosition.f_82480_;
        double lookZ = this.lookAt.m_7094_() - eyePosition.f_82481_;
        double xzLength = Math.sqrt(lookX * lookX + lookZ * lookZ);
        double rotationPitch = Mth.m_14177_((float)((float)(-Mth.m_14136_((double)lookY, (double)xzLength) * 57.29577951308232)));
        double rotationYaw = Mth.m_14177_((float)((float)(Mth.m_14136_((double)lookZ, (double)lookX) * 57.29577951308232) - 90.0f));
        double lerpPercentage = (double)partialTicks * 0.3;
        player.m_146926_(BargainScreen.lerpAngle(lerpPercentage, Mth.m_14177_((float)player.m_146909_()), rotationPitch));
        player.m_146922_(BargainScreen.lerpAngle(lerpPercentage, Mth.m_14177_((float)player.m_146908_()), rotationYaw));
        player.m_5616_(player.m_146908_());
        player.f_19860_ = player.m_146909_();
        player.f_19859_ = player.m_146908_();
        player.f_20886_ = player.f_20885_;
        player.f_20884_ = player.f_20883_ = player.f_20885_;
    }

    private static float lerpAngle(double percentage, double start, double end) {
        return (float)Mth.m_14139_((double)percentage, (double)(start < end ? (end - start > 180.0 ? start + 360.0 : start) : (start - end > 180.0 ? start - 360.0 : start)), (double)end);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int bargainSize = this.catalog.size();
        if (bargainSize > 7) {
            this.buttonIndexOffset = Mth.m_14045_((int)((int)((double)this.buttonIndexOffset - delta)), (int)0, (int)(bargainSize - 7));
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDragging) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        int offScreenBargains = this.catalog.size() - 7;
        this.buttonIndexOffset = Mth.m_14045_((int)((int)((mouseY - (double)this.getTop() + 1.0 - 13.5) / 112.0 * (double)offScreenBargains + 0.5)), (int)0, (int)offScreenBargains);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        int left = this.getLeft();
        int top = this.getTop();
        if (this.catalog.size() > 7 && mouseX > (double)(left + 90) && mouseX < (double)(left + 90 + 6) && mouseY > (double)(top + 1) && mouseY <= (double)(top + 1 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers) || this.f_96541_ == null) {
            return true;
        }
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (ParagliderUtils.isActiveAndMatches(this.f_96541_.f_91066_.f_92092_, key)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        ParagliderNetwork.get().bargainEndToServer(this.sessionId);
        super.m_7379_();
    }

    @NotNull
    private ItemStack cycle(@NotNull List<ItemStack> stacks) {
        int i = this.cycleIndex(stacks.size());
        return i < 0 || i >= stacks.size() ? ItemStack.f_41583_ : stacks.get(i);
    }

    private int cycleIndex(int counts) {
        if (counts <= 0) {
            return -1;
        }
        return (int)(Math.abs(this.currentTickTimestamp - this.createdTime) / 1000L % (long)counts);
    }

    private static int determineItemPosition(int n, int length, int start, int end) {
        if (n >= length) {
            throw new IllegalArgumentException("length");
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start");
        }
        if (length == 1) {
            return (start + end) / 2;
        }
        int span = end - start;
        int spanPerElement = Math.min(16, span / (length - 1));
        if (spanPerElement == 0) {
            return start - (length - 1 - span) / 2 + n;
        }
        int leftover = span % spanPerElement;
        return start + leftover / 2 + spanPerElement * n;
    }

    private final class BargainButton
    extends AbstractButton {
        private final int index;
        @Nullable
        private ItemStack fallbackIcon;

        public BargainButton(int x, int y, int index) {
            super(x, y, 89, 20, (Component)Component.m_237119_());
            this.index = index;
            this.f_93624_ = false;
        }

        public void m_5691_() {
            BargainCatalog catalog = this.catalog();
            if (catalog != null) {
                ParagliderNetwork.get().bargain(BargainScreen.this.sessionId, catalog.bargain());
            }
        }

        public int actualIndex() {
            return this.index + BargainScreen.this.buttonIndexOffset;
        }

        @Nullable
        public BargainCatalog catalog() {
            Pair<BargainCatalog, Bargain> pair = BargainScreen.this.getBargain(this.actualIndex());
            return pair == null ? null : (BargainCatalog)pair.getFirst();
        }

        @Nullable
        public Bargain bargain() {
            Pair<BargainCatalog, Bargain> pair = BargainScreen.this.getBargain(this.actualIndex());
            return pair == null ? null : (Bargain)pair.getSecond();
        }

        private void renderTradeIndicator(GuiGraphics guiGraphics) {
            BargainCatalog catalog = this.catalog();
            RenderSystem.enableBlend();
            guiGraphics.m_280398_(MERCHANT_GUI_TEXTURE, this.m_252754_() + 39, this.m_252907_() + 5, 0, catalog == null || catalog.canBargain() ? 15.0f : 25.0f, 171.0f, 10, 9, 512, 256);
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            BargainCatalog catalog = this.catalog();
            this.f_93623_ = catalog != null && catalog.canBargain();
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
            this.f_93623_ = true;
            this.renderTradeIndicator(guiGraphics);
        }

        public void m_280139_(GuiGraphics guiGraphics, Font font, int color) {
        }

        private ItemStack fallbackIcon() {
            if (this.fallbackIcon != null) {
                return this.fallbackIcon;
            }
            this.fallbackIcon = new ItemStack((ItemLike)Items.f_42127_);
            return this.fallbackIcon;
        }

        private void renderItems(GuiGraphics guiGraphics) {
            int itemX;
            ItemStack stack;
            if (!this.f_93624_) {
                return;
            }
            Bargain bargain = this.bargain();
            if (bargain == null) {
                return;
            }
            List<DemandPreview> demands = bargain.previewDemands();
            for (int i = demands.size() - 1; i >= 0; --i) {
                DemandPreview demand = demands.get(i);
                List<ItemStack> stacks = demand.preview();
                if (stacks.isEmpty()) {
                    stack = this.fallbackIcon();
                } else {
                    stack = BargainScreen.this.cycle(stacks);
                    if (stack.m_41619_()) {
                        stack = this.fallbackIcon();
                    }
                }
                itemX = this.m_252754_() + BargainScreen.determineItemPosition(i, demands.size(), 2, 22);
                guiGraphics.m_280203_(stack, itemX, this.m_252907_() + 2);
                if (demand.quantity() == 1) continue;
                guiGraphics.m_280302_(BargainScreen.this.f_96547_, stack, itemX, this.m_252907_() + 2, String.valueOf(demand.quantity()));
            }
            List<OfferPreview> offers = bargain.previewOffers();
            for (int i = offers.size() - 1; i >= 0; --i) {
                OfferPreview offer = offers.get(i);
                stack = offer.preview();
                if (stack.m_41619_()) {
                    stack = this.fallbackIcon();
                }
                itemX = this.m_252754_() + BargainScreen.determineItemPosition(i, offers.size(), 50, 70);
                guiGraphics.m_280203_(stack, itemX, this.m_252907_() + 2);
                if (offer.quantity() == 1) continue;
                guiGraphics.m_280302_(BargainScreen.this.f_96547_, stack, itemX, this.m_252907_() + 2, String.valueOf(offer.quantity()));
            }
        }

        private void renderToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (!this.f_93622_) {
                return;
            }
            Bargain bargain = this.bargain();
            if (bargain == null) {
                return;
            }
            List<DemandPreview> demands = bargain.previewDemands();
            DemandPreview closestDemand = null;
            int closestDemandDistance = Integer.MAX_VALUE;
            for (int i = 0; i < demands.size(); ++i) {
                int itemX = this.m_252754_() + BargainScreen.determineItemPosition(i, demands.size(), 2, 22);
                if (mouseX < itemX || mouseX >= itemX + 16) continue;
                int dist = Math.abs(itemX + 8 - mouseX);
                if (closestDemandDistance <= dist) break;
                closestDemandDistance = dist;
                closestDemand = demands.get(i);
            }
            if (closestDemand != null) {
                List<ItemStack> preview = closestDemand.preview();
                int i = BargainScreen.this.cycleIndex(preview.size());
                guiGraphics.m_280666_(BargainScreen.this.f_96547_, i < 0 || i >= preview.size() ? List.of(Component.m_237113_((String)"No Preview")) : closestDemand.getTooltip(i), mouseX, mouseY);
                return;
            }
            List<OfferPreview> offers = bargain.previewOffers();
            OfferPreview closestOffer = null;
            int closestOfferDistance = Integer.MAX_VALUE;
            for (int i = 0; i < offers.size(); ++i) {
                int itemX = this.m_252754_() + BargainScreen.determineItemPosition(i, offers.size(), 50, 70);
                if (mouseX < itemX || mouseX >= itemX + 16) continue;
                int dist = Math.abs(itemX + 8 - mouseX);
                if (closestOfferDistance <= dist) break;
                closestOfferDistance = dist;
                closestOffer = offers.get(i);
            }
            if (closestOffer != null) {
                guiGraphics.m_280666_(BargainScreen.this.f_96547_, closestOffer.getTooltip(), mouseX, mouseY);
            }
        }

        protected void m_168797_(NarrationElementOutput o) {
        }
    }
}

