/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.treedecorators.TYGTreeDecoratorTypes;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.jetbrains.annotations.NotNull;

public class TYGLeavesVineDecorator
extends TreeDecorator {
    public static final Codec<TYGLeavesVineDecorator> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BuiltInRegistries.f_256975_.m_194605_().flatXmap(TYGLeavesVineDecorator.mustExtendVineBlock(), TYGLeavesVineDecorator.mustExtendVineBlock()).fieldOf("vine_block").forGetter(TYGLeavesVineDecorator2 -> TYGLeavesVineDecorator2.vineBlock), (App)Codec.FLOAT.fieldOf("probability").forGetter(TYGLeavesVineDecorator2 -> Float.valueOf(TYGLeavesVineDecorator2.probability))).apply((Applicative)builder, (vineBlock, probability) -> new TYGLeavesVineDecorator((VineBlock)vineBlock, probability.floatValue())));
    private final VineBlock vineBlock;
    private final float probability;

    static Function<Block, DataResult<Block>> mustExtendVineBlock() {
        return block -> block instanceof VineBlock ? DataResult.success((Object)block) : DataResult.error(() -> String.format("\"%s\" is not an instance of `VineBlock`.", BuiltInRegistries.f_256975_.m_7981_(block)));
    }

    public TYGLeavesVineDecorator(VineBlock vineBlock, float probability) {
        this.vineBlock = vineBlock;
        this.probability = probability;
    }

    @NotNull
    protected TreeDecoratorType<?> m_6663_() {
        return TYGTreeDecoratorTypes.LEAVE_VINE.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource randomSource = context.m_226067_();
        context.m_226069_().forEach(pos -> {
            BlockPos pos1;
            if (randomSource.m_188501_() <= this.probability && context.m_226059_(pos1 = pos.m_122024_())) {
                this.addHangingVine(pos1, VineBlock.f_57835_, context);
            }
            if (randomSource.m_188501_() <= this.probability && context.m_226059_(pos1 = pos.m_122029_())) {
                this.addHangingVine(pos1, VineBlock.f_57837_, context);
            }
            if (randomSource.m_188501_() <= this.probability && context.m_226059_(pos1 = pos.m_122012_())) {
                this.addHangingVine(pos1, VineBlock.f_57836_, context);
            }
            if (randomSource.m_188501_() <= this.probability && context.m_226059_(pos1 = pos.m_122019_())) {
                this.addHangingVine(pos1, VineBlock.f_57834_, context);
            }
        });
    }

    private void addHangingVine(BlockPos pos, BooleanProperty booleanProperty, TreeDecorator.Context context) {
        this.placeVine(context, pos, booleanProperty);
        pos = pos.m_7495_();
        for (int count = 4; context.m_226059_(pos) && count > 0; --count) {
            this.placeVine(context, pos, booleanProperty);
            pos = pos.m_7495_();
        }
    }

    public void placeVine(TreeDecorator.Context context, BlockPos blockPos, BooleanProperty booleanProperty) {
        context.m_226061_(blockPos, (BlockState)this.vineBlock.m_49966_().m_61124_((Property)booleanProperty, (Comparable)Boolean.valueOf(true)));
    }
}

