/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.entities;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import net.potionstudios.biomeswevegone.world.level.block.custom.PumpkinBurrowBlock;
import net.potionstudios.biomeswevegone.world.level.block.entities.BWGBlockEntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PumpkinBurrowBlockEntity
extends BlockEntity {
    private static final List<String> IGNORED_TAGS = List.of("Air", "ArmorDropChances", "ArmorItems", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "Hiding", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "OnGround", "PortalCooldown", "Pos", "Rotation", "UUID");
    public Occupant stored = Occupant.EMPTY;

    public PumpkinBurrowBlockEntity(BlockPos pos, BlockState blockState) {
        super(BWGBlockEntityType.PUMPKIN_BURROW.get(), pos, blockState);
    }

    public void addOccupant(LivingEntity occupant) {
        if (this.isEmpty()) {
            occupant.m_8127_();
            occupant.m_20153_();
            occupant.m_21250_(this.m_58899_());
            this.stored = Occupant.of((Entity)occupant);
            occupant.m_146870_();
            if (this.m_58904_() != null) {
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PumpkinBurrowBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)));
            }
            super.m_6596_();
        }
    }

    public boolean isEmpty() {
        return this.stored.equals(Occupant.EMPTY);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("occupant")) {
            this.stored = new Occupant(tag.m_128469_("occupant"));
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("occupant", (Tag)this.stored.entityData);
    }

    public void emptyOccupant(Level level) {
        Entity entity;
        if (!this.isEmpty() && (entity = this.stored.createEntity(level)) instanceof PumpkinWarden) {
            PumpkinWarden pumpkinWarden = (PumpkinWarden)entity;
            pumpkinWarden.m_6034_((double)this.m_58899_().m_123341_() + 0.5, this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() + 0.5);
            pumpkinWarden.m_5796_();
            this.stored = Occupant.EMPTY;
            level.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)PumpkinBurrowBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)));
            level.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)entity, (BlockState)this.m_58900_()));
            level.m_7967_((Entity)pumpkinWarden);
        }
    }

    private static void removeIgnoredTags(CompoundTag tag) {
        IGNORED_TAGS.forEach(arg_0 -> ((CompoundTag)tag).m_128473_(arg_0));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PumpkinBurrowBlockEntity blockEntity) {
        Entity entity;
        if (!blockEntity.isEmpty() && level.m_46461_() && level.m_213780_().m_188499_() && (entity = blockEntity.stored.createEntity(level)) instanceof PumpkinWarden) {
            PumpkinWarden pumpkinWarden = (PumpkinWarden)entity;
            Direction direction = (Direction)state.m_61143_((Property)PumpkinBurrowBlock.FACING);
            BlockPos blockPos = pos.m_121945_(direction);
            if (level.m_8055_(blockPos).m_60812_((BlockGetter)level, blockPos).m_83281_()) {
                pumpkinWarden.m_6034_((double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                pumpkinWarden.m_5796_();
                pumpkinWarden.m_6274_().m_21879_(MemoryModuleType.f_26359_, (Object)GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
                level.m_7967_((Entity)pumpkinWarden);
                blockEntity.stored = Occupant.EMPTY;
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)PumpkinBurrowBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public record Occupant(CompoundTag entityData) {
        public static final Occupant EMPTY = new Occupant(new CompoundTag());

        public Occupant {
            PumpkinBurrowBlockEntity.removeIgnoredTags(entityData);
        }

        public static Occupant of(Entity entity) {
            CompoundTag compoundTag = new CompoundTag();
            entity.m_20223_(compoundTag);
            PumpkinBurrowBlockEntity.removeIgnoredTags(compoundTag);
            return new Occupant(compoundTag);
        }

        @Nullable
        public Entity createEntity(Level level) {
            CompoundTag compoundTag = this.entityData.m_6426_();
            return EntityType.m_20645_((CompoundTag)compoundTag, (Level)level, entityx -> entityx);
        }
    }
}

