/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import org.jetbrains.annotations.NotNull;

public class DestroyPumpkin
extends Behavior<PumpkinWarden> {
    private BlockPos targetBlock;
    private Block fruitBlock;
    protected int tryTicks;

    public DestroyPumpkin() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden) {
        return pumpkinWarden.canMove() && pumpkinWarden.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    protected void tick(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        if (this.targetBlock == null) {
            return;
        }
        if (!this.targetBlock.m_203195_((Position)pumpkinWarden.m_20182_(), 1.0)) {
            ++this.tryTicks;
            if (this.tryTicks > 200) {
                this.stop(level, pumpkinWarden, gameTime);
            }
        } else if (level.m_8055_(this.targetBlock).m_60713_(this.fruitBlock)) {
            BlockState blockState = level.m_8055_(this.targetBlock);
            level.m_46953_(this.targetBlock, false, (Entity)pumpkinWarden);
            level.m_220407_(GameEvent.f_157794_, this.targetBlock, GameEvent.Context.m_223719_((Entity)pumpkinWarden, (BlockState)blockState));
            pumpkinWarden.m_21008_(InteractionHand.MAIN_HAND, blockState.m_60734_().m_5456_().m_7968_());
            this.stop(level, pumpkinWarden, gameTime);
        } else {
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        return this.checkExtraStartConditions(level, pumpkinWarden);
    }

    protected void start(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        Optional<BlockPos> optionalBlockPos = this.findNearestBlock(level, pumpkinWarden.m_20183_(), blockState -> blockState.m_60734_() instanceof AttachedStemBlock, 15.0);
        if (optionalBlockPos.isPresent()) {
            this.targetBlock = optionalBlockPos.get().m_121945_((Direction)level.m_8055_(optionalBlockPos.get()).m_61143_((Property)AttachedStemBlock.f_48830_));
            this.fruitBlock = level.m_8055_(this.targetBlock).m_60734_();
            pumpkinWarden.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new BlockPosTracker(this.targetBlock), 0.8f, 1));
            pumpkinWarden.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.targetBlock));
        } else {
            this.stop(level, pumpkinWarden, gameTime);
        }
    }

    private Optional<BlockPos> findNearestBlock(@NotNull ServerLevel level, BlockPos blockPos, Predicate<BlockState> predicate, double distance) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int i = 0;
        while ((double)i <= distance) {
            int j = 0;
            while ((double)j < distance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        mutableBlockPos.m_122154_((Vec3i)blockPos, k, i - 1, l);
                        if (blockPos.m_123314_((Vec3i)mutableBlockPos, distance) && predicate.test(level.m_8055_((BlockPos)mutableBlockPos))) {
                            return Optional.of(mutableBlockPos.m_7949_());
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return Optional.empty();
    }

    protected void stop(@NotNull ServerLevel level, @NotNull PumpkinWarden pumpkinWarden, long gameTime) {
        pumpkinWarden.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        pumpkinWarden.m_6274_().m_21936_(MemoryModuleType.f_26370_);
    }
}

