/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.recipe;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.crafting.condition.CropEnabledCondition;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ReprocessorRecipeBuilder {
    private final Ingredient input;
    private final Item result;
    private final int count;
    private final JsonArray conditions = new JsonArray();

    public ReprocessorRecipeBuilder(Ingredient input, ItemLike output, int count) {
        this.input = input;
        this.result = output.m_5456_();
        this.count = count;
    }

    public void addCondition(JsonObject condition) {
        this.conditions.add((JsonElement)condition);
    }

    public static ReprocessorRecipeBuilder newSeedReprocessingRecipe(Crop crop) {
        Ingredient input = Ingredient.m_43929_((ItemLike[])new ItemLike[]{crop.getSeedsItem()});
        Item output = crop.getEssenceItem();
        ReprocessorRecipeBuilder builder = new ReprocessorRecipeBuilder(input, (ItemLike)output, 2);
        JsonObject condition = new JsonObject();
        condition.addProperty("type", CropEnabledCondition.Serializer.INSTANCE.getID().toString());
        condition.addProperty("crop", crop.getId().toString());
        builder.addCondition(condition);
        return builder;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.result, this.count, this.input, this.conditions));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        private final Ingredient input;
        private final JsonArray conditions;

        public Result(ResourceLocation id, Item result, int count, Ingredient input, JsonArray conditions) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.input = input;
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject json) {
            json.add("conditions", (JsonElement)this.conditions);
            json.add("input", this.input.m_43942_());
            JsonObject result = new JsonObject();
            result.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
            if (this.count > 1) {
                result.addProperty("count", (Number)this.count);
            }
            json.add("result", (JsonElement)result);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializers.REPROCESSOR.get();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

