/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.jei;

import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.client.screen.EnchanterScreen;
import com.blakebr0.mysticalagriculture.client.screen.ReprocessorScreen;
import com.blakebr0.mysticalagriculture.client.screen.SoulExtractorScreen;
import com.blakebr0.mysticalagriculture.client.screen.SouliumSpawnerScreen;
import com.blakebr0.mysticalagriculture.compat.jei.CruxRecipe;
import com.blakebr0.mysticalagriculture.compat.jei.category.AwakeningCategory;
import com.blakebr0.mysticalagriculture.compat.jei.category.CruxCategory;
import com.blakebr0.mysticalagriculture.compat.jei.category.EnchanterCategory;
import com.blakebr0.mysticalagriculture.compat.jei.category.InfusionCategory;
import com.blakebr0.mysticalagriculture.compat.jei.category.ReprocessorCategory;
import com.blakebr0.mysticalagriculture.compat.jei.category.SoulExtractorCategory;
import com.blakebr0.mysticalagriculture.compat.jei.category.SouliumSpawnerCategory;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public final class JeiCompat
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("mysticalagriculture", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new InfusionCategory(guiHelper), new AwakeningCategory(guiHelper), new EnchanterCategory(guiHelper), new ReprocessorCategory(guiHelper), new SoulExtractorCategory(guiHelper), new SouliumSpawnerCategory(guiHelper), new CruxCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INFUSION_ALTAR.get()), new RecipeType[]{InfusionCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INFUSION_PEDESTAL.get()), new RecipeType[]{InfusionCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AWAKENING_ALTAR.get()), new RecipeType[]{AwakeningCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AWAKENING_PEDESTAL.get()), new RecipeType[]{AwakeningCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ESSENCE_VESSEL.get()), new RecipeType[]{AwakeningCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ENCHANTER.get()), new RecipeType[]{EnchanterCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.REPROCESSOR.get()), new RecipeType[]{ReprocessorCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SOUL_EXTRACTOR.get()), new RecipeType[]{SoulExtractorCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SOULIUM_SPAWNER.get()), new RecipeType[]{SouliumSpawnerCategory.RECIPE_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            RecipeManager manager = level.m_7465_();
            registration.addRecipes(InfusionCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.INFUSION.get()));
            registration.addRecipes(AwakeningCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.AWAKENING.get()));
            registration.addRecipes(EnchanterCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.ENCHANTER.get()));
            registration.addRecipes(ReprocessorCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.REPROCESSOR.get()));
            registration.addRecipes(SoulExtractorCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.SOUL_EXTRACTION.get()));
            registration.addRecipes(SouliumSpawnerCategory.RECIPE_TYPE, manager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.SOULIUM_SPAWNER.get()));
            registration.addRecipes(CruxCategory.RECIPE_TYPE, CruxRecipe.getGeneratedRecipes());
        }
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModItems.COGNIZANT_DUST.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.desc.mysticalagriculture.cognizant_dust")});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(EnchanterScreen.class, 104, 41, 22, 15, new RecipeType[]{EnchanterCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(ReprocessorScreen.class, 99, 52, 22, 15, new RecipeType[]{ReprocessorCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(SoulExtractorScreen.class, 99, 52, 22, 15, new RecipeType[]{SoulExtractorCategory.RECIPE_TYPE});
        registration.addRecipeClickArea(SouliumSpawnerScreen.class, 99, 52, 22, 15, new RecipeType[]{SouliumSpawnerCategory.RECIPE_TYPE});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ModItems.SOUL_JAR.ifPresent(jar -> registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, jar, (stack, context) -> {
            MobSoulType type = MobSoulUtils.getType(stack);
            return type != null ? type.getEntityIds().toString() : "";
        }));
    }
}

