/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.handler;

import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.item.AugmentItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class AugmentTooltipHandler {
    @SubscribeEvent
    public void onGatherComponents(RenderTooltipEvent.GatherComponents event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof AugmentItem) {
            AugmentItem item2 = (AugmentItem)item;
            List tooltip = event.getTooltipElements();
            List<ItemStack> stacks = AugmentTooltipHandler.getDisplayItemStacks(item2.getAugment());
            tooltip.add(1, Either.right((Object)new AugmentToolTypesComponent(10 * stacks.size() - 10, 12, stacks)));
        }
    }

    private static List<ItemStack> getDisplayItemStacks(Augment augment) {
        EnumSet<AugmentType> types = augment.getAugmentTypes();
        if (types.contains((Object)AugmentType.TOOL)) {
            return List.of(new ItemStack((ItemLike)Items.f_42390_), new ItemStack((ItemLike)Items.f_42389_), new ItemStack((ItemLike)Items.f_42391_), new ItemStack((ItemLike)Items.f_42392_), new ItemStack((ItemLike)Items.f_42574_), new ItemStack((ItemLike)Items.f_42523_), new ItemStack((ItemLike)ModItems.DIAMOND_SICKLE.get()), new ItemStack((ItemLike)ModItems.DIAMOND_SCYTHE.get()));
        }
        if (types.contains((Object)AugmentType.WEAPON)) {
            return List.of(new ItemStack((ItemLike)Items.f_42388_), new ItemStack((ItemLike)Items.f_42411_), new ItemStack((ItemLike)Items.f_42717_), new ItemStack((ItemLike)ModItems.DIAMOND_SICKLE.get()), new ItemStack((ItemLike)ModItems.DIAMOND_SCYTHE.get()));
        }
        if (types.contains((Object)AugmentType.ARMOR)) {
            return List.of(new ItemStack((ItemLike)Items.f_42472_), new ItemStack((ItemLike)Items.f_42473_), new ItemStack((ItemLike)Items.f_42474_), new ItemStack((ItemLike)Items.f_42475_));
        }
        return types.stream().map(AugmentTooltipHandler::getDisplayItemStackForAugmentType).filter(s -> !s.m_41619_()).toList();
    }

    private static ItemStack getDisplayItemStackForAugmentType(AugmentType type) {
        Item item = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case AugmentType.TOOL, AugmentType.WEAPON, AugmentType.ARMOR, AugmentType.STAFF -> null;
            case AugmentType.SWORD -> Items.f_42388_;
            case AugmentType.PICKAXE -> Items.f_42390_;
            case AugmentType.SHOVEL -> Items.f_42389_;
            case AugmentType.AXE -> Items.f_42391_;
            case AugmentType.HOE -> Items.f_42392_;
            case AugmentType.BOW -> Items.f_42411_;
            case AugmentType.CROSSBOW -> Items.f_42717_;
            case AugmentType.SHEARS -> Items.f_42574_;
            case AugmentType.FISHING_ROD -> Items.f_42523_;
            case AugmentType.SICKLE -> (Item)ModItems.DIAMOND_SICKLE.get();
            case AugmentType.SCYTHE -> (Item)ModItems.DIAMOND_SCYTHE.get();
            case AugmentType.HELMET -> Items.f_42472_;
            case AugmentType.CHESTPLATE -> Items.f_42473_;
            case AugmentType.LEGGINGS -> Items.f_42474_;
            case AugmentType.BOOTS -> Items.f_42475_;
        };
        return item == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)item);
    }

    public record AugmentToolTypesComponent(int width, int height, List<ItemStack> stacks) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(Font font, int tooltipX, int tooltipY, GuiGraphics gfx) {
            PoseStack matrix = gfx.m_280168_();
            matrix.m_85836_();
            matrix.m_252880_((float)tooltipX, (float)tooltipY, 0.0f);
            matrix.m_85841_(0.5f, 0.5f, 1.0f);
            int drawn = 0;
            for (ItemStack stack : this.stacks) {
                gfx.m_280480_(stack, drawn % 10 * 18, 0);
                ++drawn;
            }
            matrix.m_85849_();
        }

        public int m_142103_() {
            return this.height;
        }

        public int m_142069_(Font font) {
            return this.width;
        }
    }
}

